@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Shared Target.
 * @property resourceShareId The resource share ID of resource manager.
 * @property status The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
 * @property targetId The ID of the Shared Target.
 */
public data class GetSharedTargetsTarget(
    public val id: String,
    public val resourceShareId: String,
    public val status: String,
    public val targetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.resourcemanager.outputs.GetSharedTargetsTarget): GetSharedTargetsTarget = GetSharedTargetsTarget(
            id = javaType.id(),
            resourceShareId = javaType.resourceShareId(),
            status = javaType.status(),
            targetId = javaType.targetId(),
        )
    }
}
