@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Acl].
 */
@PulumiTagMarker
public class AclResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AclArgs = AclArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AclArgsBuilder.() -> Unit) {
        val builder = AclArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Acl {
        val builtJavaResource = com.pulumi.alicloud.rocketmq.Acl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Acl(builtJavaResource)
    }
}

/**
 * Provides a Sag Acl resource. Smart Access Gateway (SAG) provides the access control list (ACL) function in the form of whitelists and blacklists for different SAG instances.
 * For information about Sag Acl and how to use it, see [What is access control list (ACL)](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createacl).
 * > **NOTE:** Available since v1.60.0.
 * > **NOTE:** Only the following regions support create Cloud Connect Network. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.rocketmq.Acl("default", {name: "terraform-example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.rocketmq.Acl("default", name="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.RocketMQ.Acl("default", new()
 *     {
 *         Name = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rocketmq.NewAcl(ctx, "default", &rocketmq.AclArgs{
 * 			Name: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rocketmq.Acl;
 * import com.pulumi.alicloud.rocketmq.AclArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Acl("default", AclArgs.builder()
 *             .name("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:rocketmq:Acl
 *     properties:
 *       name: terraform-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Sag Acl can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/acl:Acl example acl-abc123456
 * ```
 */
public class Acl internal constructor(
    override val javaResource: com.pulumi.alicloud.rocketmq.Acl,
) : KotlinCustomResource(javaResource, AclMapper) {
    /**
     * The name of the ACL instance. The name can contain 2 to 128 characters including a-z, A-Z, 0-9, periods, underlines, and hyphens. The name must start with an English letter, but cannot start with http:// or https://.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object AclMapper : ResourceMapper<Acl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rocketmq.Acl::class == javaResource::class

    override fun map(javaResource: Resource): Acl = Acl(
        javaResource as
            com.pulumi.alicloud.rocketmq.Acl,
    )
}

/**
 * @see [Acl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Acl].
 */
public suspend fun acl(name: String, block: suspend AclResourceBuilder.() -> Unit): Acl {
    val builder = AclResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Acl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun acl(name: String): Acl {
    val builder = AclResourceBuilder()
    builder.name(name)
    return builder.build()
}
