@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AclRule].
 */
@PulumiTagMarker
public class AclRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AclRuleArgs = AclRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AclRuleArgsBuilder.() -> Unit) {
        val builder = AclRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AclRule {
        val builtJavaResource = com.pulumi.alicloud.rocketmq.AclRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AclRule(builtJavaResource)
    }
}

/**
 * Provides a Sag Acl Rule resource. This topic describes how to configure an access control list (ACL) rule for a target Smart Access Gateway instance to permit or deny access to or from specified IP addresses in the ACL rule.
 * For information about Sag Acl Rule and how to use it, see [What is access control list (ACL) rule](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/addaclrule).
 * > **NOTE:** Available since v1.60.0.
 * > **NOTE:** Only the following regions support create Cloud Connect Network. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.rocketmq.Acl("default", {name: name});
 * const defaultAclRule = new alicloud.rocketmq.AclRule("default", {
 *     aclId: _default.id,
 *     description: name,
 *     policy: "accept",
 *     ipProtocol: "ALL",
 *     direction: "in",
 *     sourceCidr: "10.10.1.0/24",
 *     sourcePortRange: "-1/-1",
 *     destCidr: "192.168.1.0/24",
 *     destPortRange: "-1/-1",
 *     priority: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.rocketmq.Acl("default", name=name)
 * default_acl_rule = alicloud.rocketmq.AclRule("default",
 *     acl_id=default.id,
 *     description=name,
 *     policy="accept",
 *     ip_protocol="ALL",
 *     direction="in",
 *     source_cidr="10.10.1.0/24",
 *     source_port_range="-1/-1",
 *     dest_cidr="192.168.1.0/24",
 *     dest_port_range="-1/-1",
 *     priority=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.RocketMQ.Acl("default", new()
 *     {
 *         Name = name,
 *     });
 *     var defaultAclRule = new AliCloud.RocketMQ.AclRule("default", new()
 *     {
 *         AclId = @default.Id,
 *         Description = name,
 *         Policy = "accept",
 *         IpProtocol = "ALL",
 *         Direction = "in",
 *         SourceCidr = "10.10.1.0/24",
 *         SourcePortRange = "-1/-1",
 *         DestCidr = "192.168.1.0/24",
 *         DestPortRange = "-1/-1",
 *         Priority = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := rocketmq.NewAcl(ctx, "default", &rocketmq.AclArgs{
 * 			Name: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rocketmq.NewAclRule(ctx, "default", &rocketmq.AclRuleArgs{
 * 			AclId:           _default.ID(),
 * 			Description:     pulumi.String(name),
 * 			Policy:          pulumi.String("accept"),
 * 			IpProtocol:      pulumi.String("ALL"),
 * 			Direction:       pulumi.String("in"),
 * 			SourceCidr:      pulumi.String("10.10.1.0/24"),
 * 			SourcePortRange: pulumi.String("-1/-1"),
 * 			DestCidr:        pulumi.String("192.168.1.0/24"),
 * 			DestPortRange:   pulumi.String("-1/-1"),
 * 			Priority:        pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rocketmq.Acl;
 * import com.pulumi.alicloud.rocketmq.AclArgs;
 * import com.pulumi.alicloud.rocketmq.AclRule;
 * import com.pulumi.alicloud.rocketmq.AclRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Acl("default", AclArgs.builder()
 *             .name(name)
 *             .build());
 *         var defaultAclRule = new AclRule("defaultAclRule", AclRuleArgs.builder()
 *             .aclId(default_.id())
 *             .description(name)
 *             .policy("accept")
 *             .ipProtocol("ALL")
 *             .direction("in")
 *             .sourceCidr("10.10.1.0/24")
 *             .sourcePortRange("-1/-1")
 *             .destCidr("192.168.1.0/24")
 *             .destPortRange("-1/-1")
 *             .priority("1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:rocketmq:Acl
 *     properties:
 *       name: ${name}
 *   defaultAclRule:
 *     type: alicloud:rocketmq:AclRule
 *     name: default
 *     properties:
 *       aclId: ${default.id}
 *       description: ${name}
 *       policy: accept
 *       ipProtocol: ALL
 *       direction: in
 *       sourceCidr: 10.10.1.0/24
 *       sourcePortRange: -1/-1
 *       destCidr: 192.168.1.0/24
 *       destPortRange: -1/-1
 *       priority: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Sag Acl Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/aclRule:AclRule example acr-abc123456
 * ```
 */
public class AclRule internal constructor(
    override val javaResource: com.pulumi.alicloud.rocketmq.AclRule,
) : KotlinCustomResource(javaResource, AclRuleMapper) {
    /**
     * The ID of the ACL.
     */
    public val aclId: Output<String>
        get() = javaResource.aclId().applyValue({ args0 -> args0 })

    /**
     * The description of the ACL rule. It must be 1 to 512 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The destination address. It is an IPv4 address range in CIDR format. Default value: 0.0.0.0/0.
     */
    public val destCidr: Output<String>
        get() = javaResource.destCidr().applyValue({ args0 -> args0 })

    /**
     * The range of the destination port. Valid value: 80/80.
     */
    public val destPortRange: Output<String>
        get() = javaResource.destPortRange().applyValue({ args0 -> args0 })

    /**
     * The direction of the ACL rule. Valid values: in|out.
     */
    public val direction: Output<String>
        get() = javaResource.direction().applyValue({ args0 -> args0 })

    /**
     * The protocol used by the ACL rule. The value is not case sensitive.
     */
    public val ipProtocol: Output<String>
        get() = javaResource.ipProtocol().applyValue({ args0 -> args0 })

    /**
     * The policy used by the ACL rule. Valid values: accept|drop.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The priority of the ACL rule. Value range: 1 to 100.
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The source address. It is an IPv4 address range in the CIDR format. Default value: 0.0.0.0/0.
     */
    public val sourceCidr: Output<String>
        get() = javaResource.sourceCidr().applyValue({ args0 -> args0 })

    /**
     * The range of the source port. Valid value: 80/80.
     */
    public val sourcePortRange: Output<String>
        get() = javaResource.sourcePortRange().applyValue({ args0 -> args0 })
}

public object AclRuleMapper : ResourceMapper<AclRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rocketmq.AclRule::class == javaResource::class

    override fun map(javaResource: Resource): AclRule = AclRule(
        javaResource as
            com.pulumi.alicloud.rocketmq.AclRule,
    )
}

/**
 * @see [AclRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AclRule].
 */
public suspend fun aclRule(name: String, block: suspend AclRuleResourceBuilder.() -> Unit): AclRule {
    val builder = AclRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AclRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun aclRule(name: String): AclRule {
    val builder = AclRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
