@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.AclRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Sag Acl Rule resource. This topic describes how to configure an access control list (ACL) rule for a target Smart Access Gateway instance to permit or deny access to or from specified IP addresses in the ACL rule.
 * For information about Sag Acl Rule and how to use it, see [What is access control list (ACL) rule](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/addaclrule).
 * > **NOTE:** Available since v1.60.0.
 * > **NOTE:** Only the following regions support create Cloud Connect Network. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.rocketmq.Acl("default", {name: name});
 * const defaultAclRule = new alicloud.rocketmq.AclRule("default", {
 *     aclId: _default.id,
 *     description: name,
 *     policy: "accept",
 *     ipProtocol: "ALL",
 *     direction: "in",
 *     sourceCidr: "10.10.1.0/24",
 *     sourcePortRange: "-1/-1",
 *     destCidr: "192.168.1.0/24",
 *     destPortRange: "-1/-1",
 *     priority: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.rocketmq.Acl("default", name=name)
 * default_acl_rule = alicloud.rocketmq.AclRule("default",
 *     acl_id=default.id,
 *     description=name,
 *     policy="accept",
 *     ip_protocol="ALL",
 *     direction="in",
 *     source_cidr="10.10.1.0/24",
 *     source_port_range="-1/-1",
 *     dest_cidr="192.168.1.0/24",
 *     dest_port_range="-1/-1",
 *     priority=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.RocketMQ.Acl("default", new()
 *     {
 *         Name = name,
 *     });
 *     var defaultAclRule = new AliCloud.RocketMQ.AclRule("default", new()
 *     {
 *         AclId = @default.Id,
 *         Description = name,
 *         Policy = "accept",
 *         IpProtocol = "ALL",
 *         Direction = "in",
 *         SourceCidr = "10.10.1.0/24",
 *         SourcePortRange = "-1/-1",
 *         DestCidr = "192.168.1.0/24",
 *         DestPortRange = "-1/-1",
 *         Priority = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := rocketmq.NewAcl(ctx, "default", &rocketmq.AclArgs{
 * 			Name: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rocketmq.NewAclRule(ctx, "default", &rocketmq.AclRuleArgs{
 * 			AclId:           _default.ID(),
 * 			Description:     pulumi.String(name),
 * 			Policy:          pulumi.String("accept"),
 * 			IpProtocol:      pulumi.String("ALL"),
 * 			Direction:       pulumi.String("in"),
 * 			SourceCidr:      pulumi.String("10.10.1.0/24"),
 * 			SourcePortRange: pulumi.String("-1/-1"),
 * 			DestCidr:        pulumi.String("192.168.1.0/24"),
 * 			DestPortRange:   pulumi.String("-1/-1"),
 * 			Priority:        pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rocketmq.Acl;
 * import com.pulumi.alicloud.rocketmq.AclArgs;
 * import com.pulumi.alicloud.rocketmq.AclRule;
 * import com.pulumi.alicloud.rocketmq.AclRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Acl("default", AclArgs.builder()
 *             .name(name)
 *             .build());
 *         var defaultAclRule = new AclRule("defaultAclRule", AclRuleArgs.builder()
 *             .aclId(default_.id())
 *             .description(name)
 *             .policy("accept")
 *             .ipProtocol("ALL")
 *             .direction("in")
 *             .sourceCidr("10.10.1.0/24")
 *             .sourcePortRange("-1/-1")
 *             .destCidr("192.168.1.0/24")
 *             .destPortRange("-1/-1")
 *             .priority("1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:rocketmq:Acl
 *     properties:
 *       name: ${name}
 *   defaultAclRule:
 *     type: alicloud:rocketmq:AclRule
 *     name: default
 *     properties:
 *       aclId: ${default.id}
 *       description: ${name}
 *       policy: accept
 *       ipProtocol: ALL
 *       direction: in
 *       sourceCidr: 10.10.1.0/24
 *       sourcePortRange: -1/-1
 *       destCidr: 192.168.1.0/24
 *       destPortRange: -1/-1
 *       priority: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Sag Acl Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/aclRule:AclRule example acr-abc123456
 * ```
 * @property aclId The ID of the ACL.
 * @property description The description of the ACL rule. It must be 1 to 512 characters in length.
 * @property destCidr The destination address. It is an IPv4 address range in CIDR format. Default value: 0.0.0.0/0.
 * @property destPortRange The range of the destination port. Valid value: 80/80.
 * @property direction The direction of the ACL rule. Valid values: in|out.
 * @property ipProtocol The protocol used by the ACL rule. The value is not case sensitive.
 * @property policy The policy used by the ACL rule. Valid values: accept|drop.
 * @property priority The priority of the ACL rule. Value range: 1 to 100.
 * @property sourceCidr The source address. It is an IPv4 address range in the CIDR format. Default value: 0.0.0.0/0.
 * @property sourcePortRange The range of the source port. Valid value: 80/80.
 */
public data class AclRuleArgs(
    public val aclId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val destCidr: Output<String>? = null,
    public val destPortRange: Output<String>? = null,
    public val direction: Output<String>? = null,
    public val ipProtocol: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val sourceCidr: Output<String>? = null,
    public val sourcePortRange: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.AclRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.AclRuleArgs =
        com.pulumi.alicloud.rocketmq.AclRuleArgs.builder()
            .aclId(aclId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .destCidr(destCidr?.applyValue({ args0 -> args0 }))
            .destPortRange(destPortRange?.applyValue({ args0 -> args0 }))
            .direction(direction?.applyValue({ args0 -> args0 }))
            .ipProtocol(ipProtocol?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .sourceCidr(sourceCidr?.applyValue({ args0 -> args0 }))
            .sourcePortRange(sourcePortRange?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AclRuleArgs].
 */
@PulumiTagMarker
public class AclRuleArgsBuilder internal constructor() {
    private var aclId: Output<String>? = null

    private var description: Output<String>? = null

    private var destCidr: Output<String>? = null

    private var destPortRange: Output<String>? = null

    private var direction: Output<String>? = null

    private var ipProtocol: Output<String>? = null

    private var policy: Output<String>? = null

    private var priority: Output<Int>? = null

    private var sourceCidr: Output<String>? = null

    private var sourcePortRange: Output<String>? = null

    /**
     * @param value The ID of the ACL.
     */
    @JvmName("srfagjewlewvrabc")
    public suspend fun aclId(`value`: Output<String>) {
        this.aclId = value
    }

    /**
     * @param value The description of the ACL rule. It must be 1 to 512 characters in length.
     */
    @JvmName("bllvijbxeqnsjehx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The destination address. It is an IPv4 address range in CIDR format. Default value: 0.0.0.0/0.
     */
    @JvmName("hagnsvqxtxnxcfjn")
    public suspend fun destCidr(`value`: Output<String>) {
        this.destCidr = value
    }

    /**
     * @param value The range of the destination port. Valid value: 80/80.
     */
    @JvmName("bpymgaqkmqlfowum")
    public suspend fun destPortRange(`value`: Output<String>) {
        this.destPortRange = value
    }

    /**
     * @param value The direction of the ACL rule. Valid values: in|out.
     */
    @JvmName("jwaichcloqrulfhv")
    public suspend fun direction(`value`: Output<String>) {
        this.direction = value
    }

    /**
     * @param value The protocol used by the ACL rule. The value is not case sensitive.
     */
    @JvmName("qcvtgpammumjtimu")
    public suspend fun ipProtocol(`value`: Output<String>) {
        this.ipProtocol = value
    }

    /**
     * @param value The policy used by the ACL rule. Valid values: accept|drop.
     */
    @JvmName("ksoiwtjvdgiyfakd")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The priority of the ACL rule. Value range: 1 to 100.
     */
    @JvmName("fnsnpcxnpmomyspm")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The source address. It is an IPv4 address range in the CIDR format. Default value: 0.0.0.0/0.
     */
    @JvmName("kkrlpfnkkowwfwgl")
    public suspend fun sourceCidr(`value`: Output<String>) {
        this.sourceCidr = value
    }

    /**
     * @param value The range of the source port. Valid value: 80/80.
     */
    @JvmName("bakhwbmudjfuvlft")
    public suspend fun sourcePortRange(`value`: Output<String>) {
        this.sourcePortRange = value
    }

    /**
     * @param value The ID of the ACL.
     */
    @JvmName("epfyvrdbbrguarle")
    public suspend fun aclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclId = mapped
    }

    /**
     * @param value The description of the ACL rule. It must be 1 to 512 characters in length.
     */
    @JvmName("gjrtejjmifcycpxl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The destination address. It is an IPv4 address range in CIDR format. Default value: 0.0.0.0/0.
     */
    @JvmName("urqslnchtukyckcc")
    public suspend fun destCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destCidr = mapped
    }

    /**
     * @param value The range of the destination port. Valid value: 80/80.
     */
    @JvmName("fedeamcnrfynqxwb")
    public suspend fun destPortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destPortRange = mapped
    }

    /**
     * @param value The direction of the ACL rule. Valid values: in|out.
     */
    @JvmName("rgjrnpuqkmcomtvn")
    public suspend fun direction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The protocol used by the ACL rule. The value is not case sensitive.
     */
    @JvmName("drbjxnpmgeufjrts")
    public suspend fun ipProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipProtocol = mapped
    }

    /**
     * @param value The policy used by the ACL rule. Valid values: accept|drop.
     */
    @JvmName("nwsyytsthioqjoyt")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The priority of the ACL rule. Value range: 1 to 100.
     */
    @JvmName("ssugfokyvqmqimye")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The source address. It is an IPv4 address range in the CIDR format. Default value: 0.0.0.0/0.
     */
    @JvmName("gycovdwovneailau")
    public suspend fun sourceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceCidr = mapped
    }

    /**
     * @param value The range of the source port. Valid value: 80/80.
     */
    @JvmName("obkkbqvcnylpqhks")
    public suspend fun sourcePortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRange = mapped
    }

    internal fun build(): AclRuleArgs = AclRuleArgs(
        aclId = aclId,
        description = description,
        destCidr = destCidr,
        destPortRange = destPortRange,
        direction = direction,
        ipProtocol = ipProtocol,
        policy = policy,
        priority = priority,
        sourceCidr = sourceCidr,
        sourcePortRange = sourcePortRange,
    )
}
