@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ClientUser].
 */
@PulumiTagMarker
public class ClientUserResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClientUserArgs = ClientUserArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClientUserArgsBuilder.() -> Unit) {
        val builder = ClientUserArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClientUser {
        val builtJavaResource = com.pulumi.alicloud.rocketmq.ClientUser(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClientUser(builtJavaResource)
    }
}

/**
 * Provides a Sag ClientUser resource. This topic describes how to manage accounts as an administrator. After you configure the network, you can create multiple accounts and distribute them to end users so that clients can access Alibaba Cloud.
 * For information about Sag ClientUser and how to use it, see [What is Sag ClientUser](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createsmartaccessgatewayclientuser).
 * > **NOTE:** Available since v1.65.0.
 * > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const sagId = config.get("sagId") || "sag-9bifkfaz4fg***";
 * const _default = new alicloud.rocketmq.ClientUser("default", {
 *     sagId: sagId,
 *     bandwidth: 20,
 *     userMail: "tf-example@abc.com",
 *     userName: name,
 *     password: "example1234",
 *     clientIp: "192.1.10.0",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * sag_id = config.get("sagId")
 * if sag_id is None:
 *     sag_id = "sag-9bifkfaz4fg***"
 * default = alicloud.rocketmq.ClientUser("default",
 *     sag_id=sag_id,
 *     bandwidth=20,
 *     user_mail="tf-example@abc.com",
 *     user_name=name,
 *     password="example1234",
 *     client_ip="192.1.10.0")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var sagId = config.Get("sagId") ?? "sag-9bifkfaz4fg***";
 *     var @default = new AliCloud.RocketMQ.ClientUser("default", new()
 *     {
 *         SagId = sagId,
 *         Bandwidth = 20,
 *         UserMail = "tf-example@abc.com",
 *         UserName = name,
 *         Password = "example1234",
 *         ClientIp = "192.1.10.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		sagId := "sag-9bifkfaz4fg***"
 * 		if param := cfg.Get("sagId"); param != "" {
 * 			sagId = param
 * 		}
 * 		_, err := rocketmq.NewClientUser(ctx, "default", &rocketmq.ClientUserArgs{
 * 			SagId:     pulumi.String(sagId),
 * 			Bandwidth: pulumi.Int(20),
 * 			UserMail:  pulumi.String("tf-example@abc.com"),
 * 			UserName:  pulumi.String(name),
 * 			Password:  pulumi.String("example1234"),
 * 			ClientIp:  pulumi.String("192.1.10.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rocketmq.ClientUser;
 * import com.pulumi.alicloud.rocketmq.ClientUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var sagId = config.get("sagId").orElse("sag-9bifkfaz4fg***");
 *         var default_ = new ClientUser("default", ClientUserArgs.builder()
 *             .sagId(sagId)
 *             .bandwidth("20")
 *             .userMail("tf-example@abc.com")
 *             .userName(name)
 *             .password("example1234")
 *             .clientIp("192.1.10.0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 *   sagId:
 *     type: string
 *     default: sag-9bifkfaz4fg***
 * resources:
 *   default:
 *     type: alicloud:rocketmq:ClientUser
 *     properties:
 *       sagId: ${sagId}
 *       bandwidth: '20'
 *       userMail: tf-example@abc.com
 *       userName: ${name}
 *       password: example1234
 *       clientIp: 192.1.10.0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Sag ClientUser can be imported using the name, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/clientUser:ClientUser example sag-abc123456:tf-username-abc123456
 * ```
 */
public class ClientUser internal constructor(
    override val javaResource: com.pulumi.alicloud.rocketmq.ClientUser,
) : KotlinCustomResource(javaResource, ClientUserMapper) {
    /**
     * The SAG APP bandwidth that the user can use. Unit: Kbit/s. Maximum value: 2000 Kbit/s.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The IP address of the SAG APP. If you specify this parameter, the current account always uses the specified IP address.Note The IP address must be in the private CIDR block of the SAG client.If you do not specify this parameter, the system automatically allocates an IP address from the private CIDR block of the SAG client. In this case, each re-connection uses a different IP address.
     */
    public val clientIp: Output<String>?
        get() = javaResource.clientIp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The password of the KMS Encryption.
     */
    public val kmsEncryptedPassword: Output<String>?
        get() = javaResource.kmsEncryptedPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The context of the KMS Encryption.
     */
    public val kmsEncryptionContext: Output<Map<String, String>>?
        get() = javaResource.kmsEncryptionContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The password used to log on to the SAG APP.Both the user name and the password must be specified. If you specify the user name, the password must be specified, too.
     */
    public val password: Output<String>
        get() = javaResource.password().applyValue({ args0 -> args0 })

    /**
     * The ID of the SAG instance created for the SAG APP.
     */
    public val sagId: Output<String>
        get() = javaResource.sagId().applyValue({ args0 -> args0 })

    /**
     * The email address of the user. The administrator uses this address to send the account information for logging on to the APP to the user.
     */
    public val userMail: Output<String>
        get() = javaResource.userMail().applyValue({ args0 -> args0 })

    /**
     * The user name. User names in the same SAG APP must be unique.Both the user name and the password must be specified. If you specify the user name, the password must be specified, too.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object ClientUserMapper : ResourceMapper<ClientUser> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rocketmq.ClientUser::class == javaResource::class

    override fun map(javaResource: Resource): ClientUser = ClientUser(
        javaResource as
            com.pulumi.alicloud.rocketmq.ClientUser,
    )
}

/**
 * @see [ClientUser].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClientUser].
 */
public suspend fun clientUser(name: String, block: suspend ClientUserResourceBuilder.() -> Unit): ClientUser {
    val builder = ClientUserResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClientUser].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clientUser(name: String): ClientUser {
    val builder = ClientUserResourceBuilder()
    builder.name(name)
    return builder.build()
}
