@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.ClientUserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Sag ClientUser resource. This topic describes how to manage accounts as an administrator. After you configure the network, you can create multiple accounts and distribute them to end users so that clients can access Alibaba Cloud.
 * For information about Sag ClientUser and how to use it, see [What is Sag ClientUser](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createsmartaccessgatewayclientuser).
 * > **NOTE:** Available since v1.65.0.
 * > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const sagId = config.get("sagId") || "sag-9bifkfaz4fg***";
 * const _default = new alicloud.rocketmq.ClientUser("default", {
 *     sagId: sagId,
 *     bandwidth: 20,
 *     userMail: "tf-example@abc.com",
 *     userName: name,
 *     password: "example1234",
 *     clientIp: "192.1.10.0",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * sag_id = config.get("sagId")
 * if sag_id is None:
 *     sag_id = "sag-9bifkfaz4fg***"
 * default = alicloud.rocketmq.ClientUser("default",
 *     sag_id=sag_id,
 *     bandwidth=20,
 *     user_mail="tf-example@abc.com",
 *     user_name=name,
 *     password="example1234",
 *     client_ip="192.1.10.0")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var sagId = config.Get("sagId") ?? "sag-9bifkfaz4fg***";
 *     var @default = new AliCloud.RocketMQ.ClientUser("default", new()
 *     {
 *         SagId = sagId,
 *         Bandwidth = 20,
 *         UserMail = "tf-example@abc.com",
 *         UserName = name,
 *         Password = "example1234",
 *         ClientIp = "192.1.10.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		sagId := "sag-9bifkfaz4fg***"
 * 		if param := cfg.Get("sagId"); param != "" {
 * 			sagId = param
 * 		}
 * 		_, err := rocketmq.NewClientUser(ctx, "default", &rocketmq.ClientUserArgs{
 * 			SagId:     pulumi.String(sagId),
 * 			Bandwidth: pulumi.Int(20),
 * 			UserMail:  pulumi.String("tf-example@abc.com"),
 * 			UserName:  pulumi.String(name),
 * 			Password:  pulumi.String("example1234"),
 * 			ClientIp:  pulumi.String("192.1.10.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rocketmq.ClientUser;
 * import com.pulumi.alicloud.rocketmq.ClientUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var sagId = config.get("sagId").orElse("sag-9bifkfaz4fg***");
 *         var default_ = new ClientUser("default", ClientUserArgs.builder()
 *             .sagId(sagId)
 *             .bandwidth("20")
 *             .userMail("tf-example@abc.com")
 *             .userName(name)
 *             .password("example1234")
 *             .clientIp("192.1.10.0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 *   sagId:
 *     type: string
 *     default: sag-9bifkfaz4fg***
 * resources:
 *   default:
 *     type: alicloud:rocketmq:ClientUser
 *     properties:
 *       sagId: ${sagId}
 *       bandwidth: '20'
 *       userMail: tf-example@abc.com
 *       userName: ${name}
 *       password: example1234
 *       clientIp: 192.1.10.0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Sag ClientUser can be imported using the name, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/clientUser:ClientUser example sag-abc123456:tf-username-abc123456
 * ```
 * @property bandwidth The SAG APP bandwidth that the user can use. Unit: Kbit/s. Maximum value: 2000 Kbit/s.
 * @property clientIp The IP address of the SAG APP. If you specify this parameter, the current account always uses the specified IP address.Note The IP address must be in the private CIDR block of the SAG client.If you do not specify this parameter, the system automatically allocates an IP address from the private CIDR block of the SAG client. In this case, each re-connection uses a different IP address.
 * @property kmsEncryptedPassword The password of the KMS Encryption.
 * @property kmsEncryptionContext The context of the KMS Encryption.
 * @property password The password used to log on to the SAG APP.Both the user name and the password must be specified. If you specify the user name, the password must be specified, too.
 * @property sagId The ID of the SAG instance created for the SAG APP.
 * @property userMail The email address of the user. The administrator uses this address to send the account information for logging on to the APP to the user.
 * @property userName The user name. User names in the same SAG APP must be unique.Both the user name and the password must be specified. If you specify the user name, the password must be specified, too.
 */
public data class ClientUserArgs(
    public val bandwidth: Output<Int>? = null,
    public val clientIp: Output<String>? = null,
    public val kmsEncryptedPassword: Output<String>? = null,
    public val kmsEncryptionContext: Output<Map<String, String>>? = null,
    public val password: Output<String>? = null,
    public val sagId: Output<String>? = null,
    public val userMail: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.ClientUserArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.ClientUserArgs =
        com.pulumi.alicloud.rocketmq.ClientUserArgs.builder()
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .clientIp(clientIp?.applyValue({ args0 -> args0 }))
            .kmsEncryptedPassword(kmsEncryptedPassword?.applyValue({ args0 -> args0 }))
            .kmsEncryptionContext(
                kmsEncryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .password(password?.applyValue({ args0 -> args0 }))
            .sagId(sagId?.applyValue({ args0 -> args0 }))
            .userMail(userMail?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientUserArgs].
 */
@PulumiTagMarker
public class ClientUserArgsBuilder internal constructor() {
    private var bandwidth: Output<Int>? = null

    private var clientIp: Output<String>? = null

    private var kmsEncryptedPassword: Output<String>? = null

    private var kmsEncryptionContext: Output<Map<String, String>>? = null

    private var password: Output<String>? = null

    private var sagId: Output<String>? = null

    private var userMail: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The SAG APP bandwidth that the user can use. Unit: Kbit/s. Maximum value: 2000 Kbit/s.
     */
    @JvmName("ayxyjgseppmyeswt")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value The IP address of the SAG APP. If you specify this parameter, the current account always uses the specified IP address.Note The IP address must be in the private CIDR block of the SAG client.If you do not specify this parameter, the system automatically allocates an IP address from the private CIDR block of the SAG client. In this case, each re-connection uses a different IP address.
     */
    @JvmName("gatkdpnjqawkwarf")
    public suspend fun clientIp(`value`: Output<String>) {
        this.clientIp = value
    }

    /**
     * @param value The password of the KMS Encryption.
     */
    @JvmName("bcanmcysfkjtqmhe")
    public suspend fun kmsEncryptedPassword(`value`: Output<String>) {
        this.kmsEncryptedPassword = value
    }

    /**
     * @param value The context of the KMS Encryption.
     */
    @JvmName("rwisahftbprjbaai")
    public suspend fun kmsEncryptionContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionContext = value
    }

    /**
     * @param value The password used to log on to the SAG APP.Both the user name and the password must be specified. If you specify the user name, the password must be specified, too.
     */
    @JvmName("idpnutbrpoljmvlh")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The ID of the SAG instance created for the SAG APP.
     */
    @JvmName("hhlwwoifsnenhddg")
    public suspend fun sagId(`value`: Output<String>) {
        this.sagId = value
    }

    /**
     * @param value The email address of the user. The administrator uses this address to send the account information for logging on to the APP to the user.
     */
    @JvmName("ophpifowhsxkirjr")
    public suspend fun userMail(`value`: Output<String>) {
        this.userMail = value
    }

    /**
     * @param value The user name. User names in the same SAG APP must be unique.Both the user name and the password must be specified. If you specify the user name, the password must be specified, too.
     */
    @JvmName("ccggfawltimcshlc")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The SAG APP bandwidth that the user can use. Unit: Kbit/s. Maximum value: 2000 Kbit/s.
     */
    @JvmName("lrnucltgnydpbdou")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The IP address of the SAG APP. If you specify this parameter, the current account always uses the specified IP address.Note The IP address must be in the private CIDR block of the SAG client.If you do not specify this parameter, the system automatically allocates an IP address from the private CIDR block of the SAG client. In this case, each re-connection uses a different IP address.
     */
    @JvmName("avyegrhfhqebqiym")
    public suspend fun clientIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientIp = mapped
    }

    /**
     * @param value The password of the KMS Encryption.
     */
    @JvmName("rkrjsgrxoulgsues")
    public suspend fun kmsEncryptedPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedPassword = mapped
    }

    /**
     * @param value The context of the KMS Encryption.
     */
    @JvmName("hotdmokcfofkxflk")
    public suspend fun kmsEncryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param values The context of the KMS Encryption.
     */
    @JvmName("fpicrfblyxnedidk")
    public fun kmsEncryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param value The password used to log on to the SAG APP.Both the user name and the password must be specified. If you specify the user name, the password must be specified, too.
     */
    @JvmName("ekjytidtldxhgiam")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The ID of the SAG instance created for the SAG APP.
     */
    @JvmName("ofyuquqnwnkhudut")
    public suspend fun sagId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagId = mapped
    }

    /**
     * @param value The email address of the user. The administrator uses this address to send the account information for logging on to the APP to the user.
     */
    @JvmName("ivjunndmvfxaagkl")
    public suspend fun userMail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userMail = mapped
    }

    /**
     * @param value The user name. User names in the same SAG APP must be unique.Both the user name and the password must be specified. If you specify the user name, the password must be specified, too.
     */
    @JvmName("ptcgedktnrplvien")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): ClientUserArgs = ClientUserArgs(
        bandwidth = bandwidth,
        clientIp = clientIp,
        kmsEncryptedPassword = kmsEncryptedPassword,
        kmsEncryptionContext = kmsEncryptionContext,
        password = password,
        sagId = sagId,
        userMail = userMail,
        userName = userName,
    )
}
