@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.kotlin.outputs.ConsumerGroupConsumeRetryPolicy
import com.pulumi.alicloud.rocketmq.kotlin.outputs.ConsumerGroupConsumeRetryPolicy.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ConsumerGroup].
 */
@PulumiTagMarker
public class ConsumerGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConsumerGroupArgs = ConsumerGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConsumerGroupArgsBuilder.() -> Unit) {
        val builder = ConsumerGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConsumerGroup {
        val builtJavaResource = com.pulumi.alicloud.rocketmq.ConsumerGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConsumerGroup(builtJavaResource)
    }
}

/**
 * Provides a RocketMQ Consumer Group resource.
 * For information about RocketMQ Consumer Group and how to use it, see [What is Consumer Group](https://www.alibabacloud.com/help/en/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/developer-reference/api-rocketmq-2022-08-01-createconsumergroup).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const createVpc = new alicloud.vpc.Network("createVpc", {
 *     description: "example",
 *     cidrBlock: "172.16.0.0/12",
 *     vpcName: name,
 * });
 * const createVswitch = new alicloud.vpc.Switch("createVswitch", {
 *     description: "example",
 *     vpcId: createVpc.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     cidrBlock: "172.16.0.0/24",
 *     vswitchName: name,
 * });
 * const createInstance = new alicloud.rocketmq.RocketMQInstance("createInstance", {
 *     autoRenewPeriod: 1,
 *     productInfo: {
 *         msgProcessSpec: "rmq.p2.4xlarge",
 *         sendReceiveRatio: 0.3,
 *         messageRetentionTime: 70,
 *     },
 *     networkInfo: {
 *         vpcInfo: {
 *             vpcId: createVpc.id,
 *             vswitchId: createVswitch.id,
 *         },
 *         internetInfo: {
 *             internetSpec: "enable",
 *             flowOutType: "payByBandwidth",
 *             flowOutBandwidth: 30,
 *         },
 *     },
 *     period: 1,
 *     subSeriesCode: "cluster_ha",
 *     remark: "example",
 *     instanceName: name,
 *     serviceCode: "rmq",
 *     seriesCode: "professional",
 *     paymentType: "PayAsYouGo",
 *     periodUnit: "Month",
 * });
 * const defaultConsumerGroup = new alicloud.rocketmq.ConsumerGroup("default", {
 *     consumerGroupId: name,
 *     instanceId: createInstance.id,
 *     consumeRetryPolicy: {
 *         retryPolicy: "DefaultRetryPolicy",
 *         maxRetryTimes: 10,
 *     },
 *     deliveryOrderType: "Concurrently",
 *     remark: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * create_vpc = alicloud.vpc.Network("createVpc",
 *     description="example",
 *     cidr_block="172.16.0.0/12",
 *     vpc_name=name)
 * create_vswitch = alicloud.vpc.Switch("createVswitch",
 *     description="example",
 *     vpc_id=create_vpc.id,
 *     zone_id=default.zones[0].id,
 *     cidr_block="172.16.0.0/24",
 *     vswitch_name=name)
 * create_instance = alicloud.rocketmq.RocketMQInstance("createInstance",
 *     auto_renew_period=1,
 *     product_info={
 *         "msg_process_spec": "rmq.p2.4xlarge",
 *         "send_receive_ratio": 0.3,
 *         "message_retention_time": 70,
 *     },
 *     network_info={
 *         "vpc_info": {
 *             "vpc_id": create_vpc.id,
 *             "vswitch_id": create_vswitch.id,
 *         },
 *         "internet_info": {
 *             "internet_spec": "enable",
 *             "flow_out_type": "payByBandwidth",
 *             "flow_out_bandwidth": 30,
 *         },
 *     },
 *     period=1,
 *     sub_series_code="cluster_ha",
 *     remark="example",
 *     instance_name=name,
 *     service_code="rmq",
 *     series_code="professional",
 *     payment_type="PayAsYouGo",
 *     period_unit="Month")
 * default_consumer_group = alicloud.rocketmq.ConsumerGroup("default",
 *     consumer_group_id=name,
 *     instance_id=create_instance.id,
 *     consume_retry_policy={
 *         "retry_policy": "DefaultRetryPolicy",
 *         "max_retry_times": 10,
 *     },
 *     delivery_order_type="Concurrently",
 *     remark="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var createVpc = new AliCloud.Vpc.Network("createVpc", new()
 *     {
 *         Description = "example",
 *         CidrBlock = "172.16.0.0/12",
 *         VpcName = name,
 *     });
 *     var createVswitch = new AliCloud.Vpc.Switch("createVswitch", new()
 *     {
 *         Description = "example",
 *         VpcId = createVpc.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         CidrBlock = "172.16.0.0/24",
 *         VswitchName = name,
 *     });
 *     var createInstance = new AliCloud.RocketMQ.RocketMQInstance("createInstance", new()
 *     {
 *         AutoRenewPeriod = 1,
 *         ProductInfo = new AliCloud.RocketMQ.Inputs.RocketMQInstanceProductInfoArgs
 *         {
 *             MsgProcessSpec = "rmq.p2.4xlarge",
 *             SendReceiveRatio = 0.3,
 *             MessageRetentionTime = 70,
 *         },
 *         NetworkInfo = new AliCloud.RocketMQ.Inputs.RocketMQInstanceNetworkInfoArgs
 *         {
 *             VpcInfo = new AliCloud.RocketMQ.Inputs.RocketMQInstanceNetworkInfoVpcInfoArgs
 *             {
 *                 VpcId = createVpc.Id,
 *                 VswitchId = createVswitch.Id,
 *             },
 *             InternetInfo = new AliCloud.RocketMQ.Inputs.RocketMQInstanceNetworkInfoInternetInfoArgs
 *             {
 *                 InternetSpec = "enable",
 *                 FlowOutType = "payByBandwidth",
 *                 FlowOutBandwidth = 30,
 *             },
 *         },
 *         Period = 1,
 *         SubSeriesCode = "cluster_ha",
 *         Remark = "example",
 *         InstanceName = name,
 *         ServiceCode = "rmq",
 *         SeriesCode = "professional",
 *         PaymentType = "PayAsYouGo",
 *         PeriodUnit = "Month",
 *     });
 *     var defaultConsumerGroup = new AliCloud.RocketMQ.ConsumerGroup("default", new()
 *     {
 *         ConsumerGroupId = name,
 *         InstanceId = createInstance.Id,
 *         ConsumeRetryPolicy = new AliCloud.RocketMQ.Inputs.ConsumerGroupConsumeRetryPolicyArgs
 *         {
 *             RetryPolicy = "DefaultRetryPolicy",
 *             MaxRetryTimes = 10,
 *         },
 *         DeliveryOrderType = "Concurrently",
 *         Remark = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createVpc, err := vpc.NewNetwork(ctx, "createVpc", &vpc.NetworkArgs{
 * 			Description: pulumi.String("example"),
 * 			CidrBlock:   pulumi.String("172.16.0.0/12"),
 * 			VpcName:     pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createVswitch, err := vpc.NewSwitch(ctx, "createVswitch", &vpc.SwitchArgs{
 * 			Description: pulumi.String("example"),
 * 			VpcId:       createVpc.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createInstance, err := rocketmq.NewRocketMQInstance(ctx, "createInstance", &rocketmq.RocketMQInstanceArgs{
 * 			AutoRenewPeriod: pulumi.Int(1),
 * 			ProductInfo: &rocketmq.RocketMQInstanceProductInfoArgs{
 * 				MsgProcessSpec:       pulumi.String("rmq.p2.4xlarge"),
 * 				SendReceiveRatio:     pulumi.Float64(0.3),
 * 				MessageRetentionTime: pulumi.Int(70),
 * 			},
 * 			NetworkInfo: &rocketmq.RocketMQInstanceNetworkInfoArgs{
 * 				VpcInfo: &rocketmq.RocketMQInstanceNetworkInfoVpcInfoArgs{
 * 					VpcId:     createVpc.ID(),
 * 					VswitchId: createVswitch.ID(),
 * 				},
 * 				InternetInfo: &rocketmq.RocketMQInstanceNetworkInfoInternetInfoArgs{
 * 					InternetSpec:     pulumi.String("enable"),
 * 					FlowOutType:      pulumi.String("payByBandwidth"),
 * 					FlowOutBandwidth: pulumi.Int(30),
 * 				},
 * 			},
 * 			Period:        pulumi.Int(1),
 * 			SubSeriesCode: pulumi.String("cluster_ha"),
 * 			Remark:        pulumi.String("example"),
 * 			InstanceName:  pulumi.String(name),
 * 			ServiceCode:   pulumi.String("rmq"),
 * 			SeriesCode:    pulumi.String("professional"),
 * 			PaymentType:   pulumi.String("PayAsYouGo"),
 * 			PeriodUnit:    pulumi.String("Month"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rocketmq.NewConsumerGroup(ctx, "default", &rocketmq.ConsumerGroupArgs{
 * 			ConsumerGroupId: pulumi.String(name),
 * 			InstanceId:      createInstance.ID(),
 * 			ConsumeRetryPolicy: &rocketmq.ConsumerGroupConsumeRetryPolicyArgs{
 * 				RetryPolicy:   pulumi.String("DefaultRetryPolicy"),
 * 				MaxRetryTimes: pulumi.Int(10),
 * 			},
 * 			DeliveryOrderType: pulumi.String("Concurrently"),
 * 			Remark:            pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.rocketmq.RocketMQInstance;
 * import com.pulumi.alicloud.rocketmq.RocketMQInstanceArgs;
 * import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceProductInfoArgs;
 * import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoArgs;
 * import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoVpcInfoArgs;
 * import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoInternetInfoArgs;
 * import com.pulumi.alicloud.rocketmq.ConsumerGroup;
 * import com.pulumi.alicloud.rocketmq.ConsumerGroupArgs;
 * import com.pulumi.alicloud.rocketmq.inputs.ConsumerGroupConsumeRetryPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var createVpc = new Network("createVpc", NetworkArgs.builder()
 *             .description("example")
 *             .cidrBlock("172.16.0.0/12")
 *             .vpcName(name)
 *             .build());
 *         var createVswitch = new Switch("createVswitch", SwitchArgs.builder()
 *             .description("example")
 *             .vpcId(createVpc.id())
 *             .zoneId(default_.zones()[0].id())
 *             .cidrBlock("172.16.0.0/24")
 *             .vswitchName(name)
 *             .build());
 *         var createInstance = new RocketMQInstance("createInstance", RocketMQInstanceArgs.builder()
 *             .autoRenewPeriod("1")
 *             .productInfo(RocketMQInstanceProductInfoArgs.builder()
 *                 .msgProcessSpec("rmq.p2.4xlarge")
 *                 .sendReceiveRatio(0.3)
 *                 .messageRetentionTime("70")
 *                 .build())
 *             .networkInfo(RocketMQInstanceNetworkInfoArgs.builder()
 *                 .vpcInfo(RocketMQInstanceNetworkInfoVpcInfoArgs.builder()
 *                     .vpcId(createVpc.id())
 *                     .vswitchId(createVswitch.id())
 *                     .build())
 *                 .internetInfo(RocketMQInstanceNetworkInfoInternetInfoArgs.builder()
 *                     .internetSpec("enable")
 *                     .flowOutType("payByBandwidth")
 *                     .flowOutBandwidth("30")
 *                     .build())
 *                 .build())
 *             .period("1")
 *             .subSeriesCode("cluster_ha")
 *             .remark("example")
 *             .instanceName(name)
 *             .serviceCode("rmq")
 *             .seriesCode("professional")
 *             .paymentType("PayAsYouGo")
 *             .periodUnit("Month")
 *             .build());
 *         var defaultConsumerGroup = new ConsumerGroup("defaultConsumerGroup", ConsumerGroupArgs.builder()
 *             .consumerGroupId(name)
 *             .instanceId(createInstance.id())
 *             .consumeRetryPolicy(ConsumerGroupConsumeRetryPolicyArgs.builder()
 *                 .retryPolicy("DefaultRetryPolicy")
 *                 .maxRetryTimes("10")
 *                 .build())
 *             .deliveryOrderType("Concurrently")
 *             .remark("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   createVpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       description: example
 *       cidrBlock: 172.16.0.0/12
 *       vpcName: ${name}
 *   createVswitch:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       description: example
 *       vpcId: ${createVpc.id}
 *       zoneId: ${default.zones[0].id}
 *       cidrBlock: 172.16.0.0/24
 *       vswitchName: ${name}
 *   createInstance:
 *     type: alicloud:rocketmq:RocketMQInstance
 *     properties:
 *       autoRenewPeriod: '1'
 *       productInfo:
 *         msgProcessSpec: rmq.p2.4xlarge
 *         sendReceiveRatio: 0.3
 *         messageRetentionTime: '70'
 *       networkInfo:
 *         vpcInfo:
 *           vpcId: ${createVpc.id}
 *           vswitchId: ${createVswitch.id}
 *         internetInfo:
 *           internetSpec: enable
 *           flowOutType: payByBandwidth
 *           flowOutBandwidth: '30'
 *       period: '1'
 *       subSeriesCode: cluster_ha
 *       remark: example
 *       instanceName: ${name}
 *       serviceCode: rmq
 *       seriesCode: professional
 *       paymentType: PayAsYouGo
 *       periodUnit: Month
 *   defaultConsumerGroup:
 *     type: alicloud:rocketmq:ConsumerGroup
 *     name: default
 *     properties:
 *       consumerGroupId: ${name}
 *       instanceId: ${createInstance.id}
 *       consumeRetryPolicy:
 *         retryPolicy: DefaultRetryPolicy
 *         maxRetryTimes: '10'
 *       deliveryOrderType: Concurrently
 *       remark: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RocketMQ Consumer Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/consumerGroup:ConsumerGroup example <instance_id>:<consumer_group_id>
 * ```
 */
public class ConsumerGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.rocketmq.ConsumerGroup,
) : KotlinCustomResource(javaResource, ConsumerGroupMapper) {
    /**
     * Consumption retry strategy. See `consume_retry_policy` below.
     */
    public val consumeRetryPolicy: Output<ConsumerGroupConsumeRetryPolicy>
        get() = javaResource.consumeRetryPolicy().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The first ID of the resource.
     */
    public val consumerGroupId: Output<String>
        get() = javaResource.consumerGroupId().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Delivery order.
     */
    public val deliveryOrderType: Output<String>?
        get() = javaResource.deliveryOrderType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance ID.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Custom remarks.
     */
    public val remark: Output<String>?
        get() = javaResource.remark().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ConsumerGroupMapper : ResourceMapper<ConsumerGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rocketmq.ConsumerGroup::class == javaResource::class

    override fun map(javaResource: Resource): ConsumerGroup = ConsumerGroup(
        javaResource as
            com.pulumi.alicloud.rocketmq.ConsumerGroup,
    )
}

/**
 * @see [ConsumerGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConsumerGroup].
 */
public suspend fun consumerGroup(
    name: String,
    block: suspend ConsumerGroupResourceBuilder.() -> Unit,
): ConsumerGroup {
    val builder = ConsumerGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConsumerGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun consumerGroup(name: String): ConsumerGroup {
    val builder = ConsumerGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
