@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DnatEntry].
 */
@PulumiTagMarker
public class DnatEntryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DnatEntryArgs = DnatEntryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DnatEntryArgsBuilder.() -> Unit) {
        val builder = DnatEntryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DnatEntry {
        val builtJavaResource = com.pulumi.alicloud.rocketmq.DnatEntry(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DnatEntry(builtJavaResource)
    }
}

/**
 * Provides a Sag DnatEntry resource. This topic describes how to add a DNAT entry to a Smart Access Gateway (SAG) instance to enable the DNAT function. By using the DNAT function, you can forward requests received by public IP addresses to Alibaba Cloud instances according to custom mapping rules.
 * For information about Sag DnatEntry and how to use it, see [What is Sag DnatEntry](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/adddnatentry).
 * > **NOTE:** Available since v1.63.0.
 * > **NOTE:** Only the following regions suppor. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const sagId = config.get("sagId") || "sag-9bifkfaz***";
 * const _default = new alicloud.rocketmq.DnatEntry("default", {
 *     sagId: sagId,
 *     type: "Intranet",
 *     ipProtocol: "any",
 *     externalIp: "172.32.0.2",
 *     externalPort: "any",
 *     internalIp: "172.16.0.4",
 *     internalPort: "any",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * sag_id = config.get("sagId")
 * if sag_id is None:
 *     sag_id = "sag-9bifkfaz***"
 * default = alicloud.rocketmq.DnatEntry("default",
 *     sag_id=sag_id,
 *     type="Intranet",
 *     ip_protocol="any",
 *     external_ip="172.32.0.2",
 *     external_port="any",
 *     internal_ip="172.16.0.4",
 *     internal_port="any")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var sagId = config.Get("sagId") ?? "sag-9bifkfaz***";
 *     var @default = new AliCloud.RocketMQ.DnatEntry("default", new()
 *     {
 *         SagId = sagId,
 *         Type = "Intranet",
 *         IpProtocol = "any",
 *         ExternalIp = "172.32.0.2",
 *         ExternalPort = "any",
 *         InternalIp = "172.16.0.4",
 *         InternalPort = "any",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		sagId := "sag-9bifkfaz***"
 * 		if param := cfg.Get("sagId"); param != "" {
 * 			sagId = param
 * 		}
 * 		_, err := rocketmq.NewDnatEntry(ctx, "default", &rocketmq.DnatEntryArgs{
 * 			SagId:        pulumi.String(sagId),
 * 			Type:         pulumi.String("Intranet"),
 * 			IpProtocol:   pulumi.String("any"),
 * 			ExternalIp:   pulumi.String("172.32.0.2"),
 * 			ExternalPort: pulumi.String("any"),
 * 			InternalIp:   pulumi.String("172.16.0.4"),
 * 			InternalPort: pulumi.String("any"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rocketmq.DnatEntry;
 * import com.pulumi.alicloud.rocketmq.DnatEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var sagId = config.get("sagId").orElse("sag-9bifkfaz***");
 *         var default_ = new DnatEntry("default", DnatEntryArgs.builder()
 *             .sagId(sagId)
 *             .type("Intranet")
 *             .ipProtocol("any")
 *             .externalIp("172.32.0.2")
 *             .externalPort("any")
 *             .internalIp("172.16.0.4")
 *             .internalPort("any")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   sagId:
 *     type: string
 *     default: sag-9bifkfaz***
 * resources:
 *   default:
 *     type: alicloud:rocketmq:DnatEntry
 *     properties:
 *       sagId: ${sagId}
 *       type: Intranet
 *       ipProtocol: any
 *       externalIp: 172.32.0.2
 *       externalPort: any
 *       internalIp: 172.16.0.4
 *       internalPort: any
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Sag DnatEntry can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/dnatEntry:DnatEntry example sag-abc123456:dnat-abc123456
 * ```
 */
public class DnatEntry internal constructor(
    override val javaResource: com.pulumi.alicloud.rocketmq.DnatEntry,
) : KotlinCustomResource(javaResource, DnatEntryMapper) {
    /**
     * The external public IP address.when "type" is "Internet",automatically identify the external ip.
     */
    public val externalIp: Output<String>?
        get() = javaResource.externalIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The public port.Value range: 1 to 65535 or "any".
     */
    public val externalPort: Output<String>
        get() = javaResource.externalPort().applyValue({ args0 -> args0 })

    /**
     * The destination private IP address.
     */
    public val internalIp: Output<String>
        get() = javaResource.internalIp().applyValue({ args0 -> args0 })

    /**
     * The destination private port.Value range: 1 to 65535 or "any".
     */
    public val internalPort: Output<String>
        get() = javaResource.internalPort().applyValue({ args0 -> args0 })

    /**
     * The protocol type. Valid values: TCP: Forwards packets of the TCP protocol. UDP: Forwards packets of the UDP protocol. Any: Forwards packets of all protocols.
     */
    public val ipProtocol: Output<String>
        get() = javaResource.ipProtocol().applyValue({ args0 -> args0 })

    /**
     * The ID of the SAG instance.
     */
    public val sagId: Output<String>
        get() = javaResource.sagId().applyValue({ args0 -> args0 })

    /**
     * The DNAT type. Valid values: Intranet: DNAT of private IP addresses. Internet: DNAT of public IP addresses
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DnatEntryMapper : ResourceMapper<DnatEntry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rocketmq.DnatEntry::class == javaResource::class

    override fun map(javaResource: Resource): DnatEntry = DnatEntry(
        javaResource as
            com.pulumi.alicloud.rocketmq.DnatEntry,
    )
}

/**
 * @see [DnatEntry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DnatEntry].
 */
public suspend fun dnatEntry(name: String, block: suspend DnatEntryResourceBuilder.() -> Unit): DnatEntry {
    val builder = DnatEntryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DnatEntry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dnatEntry(name: String): DnatEntry {
    val builder = DnatEntryResourceBuilder()
    builder.name(name)
    return builder.build()
}
