@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.DnatEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Sag DnatEntry resource. This topic describes how to add a DNAT entry to a Smart Access Gateway (SAG) instance to enable the DNAT function. By using the DNAT function, you can forward requests received by public IP addresses to Alibaba Cloud instances according to custom mapping rules.
 * For information about Sag DnatEntry and how to use it, see [What is Sag DnatEntry](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/adddnatentry).
 * > **NOTE:** Available since v1.63.0.
 * > **NOTE:** Only the following regions suppor. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const sagId = config.get("sagId") || "sag-9bifkfaz***";
 * const _default = new alicloud.rocketmq.DnatEntry("default", {
 *     sagId: sagId,
 *     type: "Intranet",
 *     ipProtocol: "any",
 *     externalIp: "172.32.0.2",
 *     externalPort: "any",
 *     internalIp: "172.16.0.4",
 *     internalPort: "any",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * sag_id = config.get("sagId")
 * if sag_id is None:
 *     sag_id = "sag-9bifkfaz***"
 * default = alicloud.rocketmq.DnatEntry("default",
 *     sag_id=sag_id,
 *     type="Intranet",
 *     ip_protocol="any",
 *     external_ip="172.32.0.2",
 *     external_port="any",
 *     internal_ip="172.16.0.4",
 *     internal_port="any")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var sagId = config.Get("sagId") ?? "sag-9bifkfaz***";
 *     var @default = new AliCloud.RocketMQ.DnatEntry("default", new()
 *     {
 *         SagId = sagId,
 *         Type = "Intranet",
 *         IpProtocol = "any",
 *         ExternalIp = "172.32.0.2",
 *         ExternalPort = "any",
 *         InternalIp = "172.16.0.4",
 *         InternalPort = "any",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		sagId := "sag-9bifkfaz***"
 * 		if param := cfg.Get("sagId"); param != "" {
 * 			sagId = param
 * 		}
 * 		_, err := rocketmq.NewDnatEntry(ctx, "default", &rocketmq.DnatEntryArgs{
 * 			SagId:        pulumi.String(sagId),
 * 			Type:         pulumi.String("Intranet"),
 * 			IpProtocol:   pulumi.String("any"),
 * 			ExternalIp:   pulumi.String("172.32.0.2"),
 * 			ExternalPort: pulumi.String("any"),
 * 			InternalIp:   pulumi.String("172.16.0.4"),
 * 			InternalPort: pulumi.String("any"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rocketmq.DnatEntry;
 * import com.pulumi.alicloud.rocketmq.DnatEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var sagId = config.get("sagId").orElse("sag-9bifkfaz***");
 *         var default_ = new DnatEntry("default", DnatEntryArgs.builder()
 *             .sagId(sagId)
 *             .type("Intranet")
 *             .ipProtocol("any")
 *             .externalIp("172.32.0.2")
 *             .externalPort("any")
 *             .internalIp("172.16.0.4")
 *             .internalPort("any")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   sagId:
 *     type: string
 *     default: sag-9bifkfaz***
 * resources:
 *   default:
 *     type: alicloud:rocketmq:DnatEntry
 *     properties:
 *       sagId: ${sagId}
 *       type: Intranet
 *       ipProtocol: any
 *       externalIp: 172.32.0.2
 *       externalPort: any
 *       internalIp: 172.16.0.4
 *       internalPort: any
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Sag DnatEntry can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/dnatEntry:DnatEntry example sag-abc123456:dnat-abc123456
 * ```
 * @property externalIp The external public IP address.when "type" is "Internet",automatically identify the external ip.
 * @property externalPort The public port.Value range: 1 to 65535 or "any".
 * @property internalIp The destination private IP address.
 * @property internalPort The destination private port.Value range: 1 to 65535 or "any".
 * @property ipProtocol The protocol type. Valid values: TCP: Forwards packets of the TCP protocol. UDP: Forwards packets of the UDP protocol. Any: Forwards packets of all protocols.
 * @property sagId The ID of the SAG instance.
 * @property type The DNAT type. Valid values: Intranet: DNAT of private IP addresses. Internet: DNAT of public IP addresses
 */
public data class DnatEntryArgs(
    public val externalIp: Output<String>? = null,
    public val externalPort: Output<String>? = null,
    public val internalIp: Output<String>? = null,
    public val internalPort: Output<String>? = null,
    public val ipProtocol: Output<String>? = null,
    public val sagId: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.DnatEntryArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.DnatEntryArgs =
        com.pulumi.alicloud.rocketmq.DnatEntryArgs.builder()
            .externalIp(externalIp?.applyValue({ args0 -> args0 }))
            .externalPort(externalPort?.applyValue({ args0 -> args0 }))
            .internalIp(internalIp?.applyValue({ args0 -> args0 }))
            .internalPort(internalPort?.applyValue({ args0 -> args0 }))
            .ipProtocol(ipProtocol?.applyValue({ args0 -> args0 }))
            .sagId(sagId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DnatEntryArgs].
 */
@PulumiTagMarker
public class DnatEntryArgsBuilder internal constructor() {
    private var externalIp: Output<String>? = null

    private var externalPort: Output<String>? = null

    private var internalIp: Output<String>? = null

    private var internalPort: Output<String>? = null

    private var ipProtocol: Output<String>? = null

    private var sagId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The external public IP address.when "type" is "Internet",automatically identify the external ip.
     */
    @JvmName("afxeevtifoofphgg")
    public suspend fun externalIp(`value`: Output<String>) {
        this.externalIp = value
    }

    /**
     * @param value The public port.Value range: 1 to 65535 or "any".
     */
    @JvmName("woifuofwtrsjvyio")
    public suspend fun externalPort(`value`: Output<String>) {
        this.externalPort = value
    }

    /**
     * @param value The destination private IP address.
     */
    @JvmName("wncenlgcnmhyvcqk")
    public suspend fun internalIp(`value`: Output<String>) {
        this.internalIp = value
    }

    /**
     * @param value The destination private port.Value range: 1 to 65535 or "any".
     */
    @JvmName("alabxhxrklyhjilh")
    public suspend fun internalPort(`value`: Output<String>) {
        this.internalPort = value
    }

    /**
     * @param value The protocol type. Valid values: TCP: Forwards packets of the TCP protocol. UDP: Forwards packets of the UDP protocol. Any: Forwards packets of all protocols.
     */
    @JvmName("lnbiyaintiidvxxu")
    public suspend fun ipProtocol(`value`: Output<String>) {
        this.ipProtocol = value
    }

    /**
     * @param value The ID of the SAG instance.
     */
    @JvmName("iaysfjpgtfxfknyy")
    public suspend fun sagId(`value`: Output<String>) {
        this.sagId = value
    }

    /**
     * @param value The DNAT type. Valid values: Intranet: DNAT of private IP addresses. Internet: DNAT of public IP addresses
     */
    @JvmName("mnchyqcektdlobvu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The external public IP address.when "type" is "Internet",automatically identify the external ip.
     */
    @JvmName("kthnxwswwvtrcsyp")
    public suspend fun externalIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalIp = mapped
    }

    /**
     * @param value The public port.Value range: 1 to 65535 or "any".
     */
    @JvmName("npnmoenqlfydnnfa")
    public suspend fun externalPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalPort = mapped
    }

    /**
     * @param value The destination private IP address.
     */
    @JvmName("lfruajcuhslxthve")
    public suspend fun internalIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internalIp = mapped
    }

    /**
     * @param value The destination private port.Value range: 1 to 65535 or "any".
     */
    @JvmName("lhwnnqgdneymbykk")
    public suspend fun internalPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internalPort = mapped
    }

    /**
     * @param value The protocol type. Valid values: TCP: Forwards packets of the TCP protocol. UDP: Forwards packets of the UDP protocol. Any: Forwards packets of all protocols.
     */
    @JvmName("iwqmravwrdxedbws")
    public suspend fun ipProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipProtocol = mapped
    }

    /**
     * @param value The ID of the SAG instance.
     */
    @JvmName("qxvxxdnxakgjhhfr")
    public suspend fun sagId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagId = mapped
    }

    /**
     * @param value The DNAT type. Valid values: Intranet: DNAT of private IP addresses. Internet: DNAT of public IP addresses
     */
    @JvmName("tfvlohcsjnaoedqx")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DnatEntryArgs = DnatEntryArgs(
        externalIp = externalIp,
        externalPort = externalPort,
        internalIp = internalIp,
        internalPort = internalPort,
        ipProtocol = ipProtocol,
        sagId = sagId,
        type = type,
    )
}
