@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.GroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ONS group resource.
 * For more information about how to use it, see [RocketMQ Group Management API](https://www.alibabacloud.com/help/doc-detail/29616.html).
 * > **NOTE:** Available in 1.53.0+
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "GID-tf-example";
 * const groupName = config.get("groupName") || "GID-tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultInstance = new alicloud.rocketmq.Instance("default", {name: `${name}-${_default.result}`});
 * const defaultGroup = new alicloud.rocketmq.Group("default", {
 *     groupName: groupName,
 *     instanceId: defaultInstance.id,
 *     remark: "dafault_ons_group_remark",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "GID-tf-example"
 * group_name = config.get("groupName")
 * if group_name is None:
 *     group_name = "GID-tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_instance = alicloud.rocketmq.Instance("default", name=f"{name}-{default['result']}")
 * default_group = alicloud.rocketmq.Group("default",
 *     group_name=group_name,
 *     instance_id=default_instance.id,
 *     remark="dafault_ons_group_remark")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "GID-tf-example";
 *     var groupName = config.Get("groupName") ?? "GID-tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultInstance = new AliCloud.RocketMQ.Instance("default", new()
 *     {
 *         Name = $"{name}-{@default.Result}",
 *     });
 *     var defaultGroup = new AliCloud.RocketMQ.Group("default", new()
 *     {
 *         GroupName = groupName,
 *         InstanceId = defaultInstance.Id,
 *         Remark = "dafault_ons_group_remark",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "GID-tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		groupName := "GID-tf-example"
 * 		if param := cfg.Get("groupName"); param != "" {
 * 			groupName = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := rocketmq.NewInstance(ctx, "default", &rocketmq.InstanceArgs{
 * 			Name: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rocketmq.NewGroup(ctx, "default", &rocketmq.GroupArgs{
 * 			GroupName:  pulumi.String(groupName),
 * 			InstanceId: defaultInstance.ID(),
 * 			Remark:     pulumi.String("dafault_ons_group_remark"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.rocketmq.Instance;
 * import com.pulumi.alicloud.rocketmq.InstanceArgs;
 * import com.pulumi.alicloud.rocketmq.Group;
 * import com.pulumi.alicloud.rocketmq.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("GID-tf-example");
 *         final var groupName = config.get("groupName").orElse("GID-tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .name(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var defaultGroup = new Group("defaultGroup", GroupArgs.builder()
 *             .groupName(groupName)
 *             .instanceId(defaultInstance.id())
 *             .remark("dafault_ons_group_remark")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: GID-tf-example
 *   groupName:
 *     type: string
 *     default: GID-tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultInstance:
 *     type: alicloud:rocketmq:Instance
 *     name: default
 *     properties:
 *       name: ${name}-${default.result}
 *   defaultGroup:
 *     type: alicloud:rocketmq:Group
 *     name: default
 *     properties:
 *       groupName: ${groupName}
 *       instanceId: ${defaultInstance.id}
 *       remark: dafault_ons_group_remark
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ONS GROUP can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/group:Group group MQ_INST_1234567890_Baso1234567:GID-onsGroupDemo
 * ```
 * @property groupId Replaced by `group_name` after version 1.98.0.
 * @property groupName Name of the group. Two groups on a single instance cannot have the same name. A `group_name` starts with "GID_" or "GID-", and contains letters, numbers, hyphens (-), and underscores (_).
 * @property groupType Specify the protocol applicable to the created Group ID. Valid values: `tcp`, `http`. Default to `tcp`.
 * @property instanceId ID of the ONS Instance that owns the groups.
 * @property readEnable This attribute is used to set the message reading enabled or disabled. It can only be set after the group is used by the client.
 * @property remark This attribute is a concise description of group. The length cannot exceed 256.
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 */
public data class GroupArgs(
    @Deprecated(
        message = """
  Field 'group_id' has been deprecated from version 1.98.0. Use 'group_name' instead.
  """,
    )
    public val groupId: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val groupType: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val readEnable: Output<Boolean>? = null,
    public val remark: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.GroupArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.GroupArgs =
        com.pulumi.alicloud.rocketmq.GroupArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .groupType(groupType?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .readEnable(readEnable?.applyValue({ args0 -> args0 }))
            .remark(remark?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var groupName: Output<String>? = null

    private var groupType: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var readEnable: Output<Boolean>? = null

    private var remark: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Replaced by `group_name` after version 1.98.0.
     */
    @Deprecated(
        message = """
  Field 'group_id' has been deprecated from version 1.98.0. Use 'group_name' instead.
  """,
    )
    @JvmName("ilvywydrerytiovj")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value Name of the group. Two groups on a single instance cannot have the same name. A `group_name` starts with "GID_" or "GID-", and contains letters, numbers, hyphens (-), and underscores (_).
     */
    @JvmName("sbghfdyyyfshqaou")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Specify the protocol applicable to the created Group ID. Valid values: `tcp`, `http`. Default to `tcp`.
     */
    @JvmName("pinugahduxonfxqb")
    public suspend fun groupType(`value`: Output<String>) {
        this.groupType = value
    }

    /**
     * @param value ID of the ONS Instance that owns the groups.
     */
    @JvmName("kccbybyvortiqmco")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value This attribute is used to set the message reading enabled or disabled. It can only be set after the group is used by the client.
     */
    @JvmName("rjkmamgeyyxsiolf")
    public suspend fun readEnable(`value`: Output<Boolean>) {
        this.readEnable = value
    }

    /**
     * @param value This attribute is a concise description of group. The length cannot exceed 256.
     */
    @JvmName("dthyoprmrnpgpoie")
    public suspend fun remark(`value`: Output<String>) {
        this.remark = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("njpsrkxkhvrigsfy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Replaced by `group_name` after version 1.98.0.
     */
    @Deprecated(
        message = """
  Field 'group_id' has been deprecated from version 1.98.0. Use 'group_name' instead.
  """,
    )
    @JvmName("rokmxfottruujdst")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Name of the group. Two groups on a single instance cannot have the same name. A `group_name` starts with "GID_" or "GID-", and contains letters, numbers, hyphens (-), and underscores (_).
     */
    @JvmName("iofkyeeurrpkgjqf")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Specify the protocol applicable to the created Group ID. Valid values: `tcp`, `http`. Default to `tcp`.
     */
    @JvmName("stukhpiibvcoywra")
    public suspend fun groupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value ID of the ONS Instance that owns the groups.
     */
    @JvmName("dyxyhqjowhesggop")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value This attribute is used to set the message reading enabled or disabled. It can only be set after the group is used by the client.
     */
    @JvmName("enjpioictbeaeaoe")
    public suspend fun readEnable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readEnable = mapped
    }

    /**
     * @param value This attribute is a concise description of group. The length cannot exceed 256.
     */
    @JvmName("tbjhmvuerplkdasu")
    public suspend fun remark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remark = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("ruitoppufhyapnfu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("sbojdodveqnopafp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        groupId = groupId,
        groupName = groupName,
        groupType = groupType,
        instanceId = instanceId,
        readEnable = readEnable,
        remark = remark,
        tags = tags,
    )
}
