@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.rocketmq.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides an ONS instance resource.
 * For more information about how to use it, see [RocketMQ Instance Management API](https://www.alibabacloud.com/help/doc-detail/106354.html).
 * > **NOTE:** The number of instances in the same region cannot exceed 8. At present, the resource does not support region "mq-internet-access" and "ap-southeast-5".
 * > **NOTE:** Available in 1.51.0+
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.rocketmq.Instance("example", {
 *     instanceName: `${name}-${_default.result}`,
 *     remark: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.rocketmq.Instance("example",
 *     instance_name=f"{name}-{default['result']}",
 *     remark=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.RocketMQ.Instance("example", new()
 *     {
 *         InstanceName = $"{name}-{@default.Result}",
 *         Remark = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rocketmq.NewInstance(ctx, "example", &rocketmq.InstanceArgs{
 * 			InstanceName: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Remark:       pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.rocketmq.Instance;
 * import com.pulumi.alicloud.rocketmq.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .instanceName(String.format("%s-%s", name,default_.result()))
 *             .remark(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:rocketmq:Instance
 *     properties:
 *       instanceName: ${name}-${default.result}
 *       remark: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ONS INSTANCE can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/instance:Instance instance MQ_INST_1234567890_Baso1234567
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.rocketmq.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Two instances on a single account in the same region cannot have the same name. The length must be 3 to 64 characters. Chinese characters, English letters digits and hyphen are allowed.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * The status of instance. 1 represents the platinum edition instance is in deployment. 2 represents the postpaid edition instance are overdue. 5 represents the postpaid or platinum edition instance is in service. 7 represents the platinum version instance is in upgrade and the service is available.
     */
    public val instanceStatus: Output<Int>
        get() = javaResource.instanceStatus().applyValue({ args0 -> args0 })

    /**
     * The edition of instance. 1 represents the postPaid edition, and 2 represents the platinum edition.
     */
    public val instanceType: Output<Int>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Replaced by `instance_name` after version 1.97.0.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.97.0. Use 'instance_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Platinum edition instance expiration time.
     */
    public val releaseTime: Output<String>
        get() = javaResource.releaseTime().applyValue({ args0 -> args0 })

    /**
     * This attribute is a concise description of instance. The length cannot exceed 128.
     */
    public val remark: Output<String>?
        get() = javaResource.remark().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of instance. 1 represents the platinum edition instance is in deployment. 2 represents the postpaid edition instance are overdue. 5 represents the postpaid or platinum edition instance is in service. 7 represents the platinum version instance is in upgrade and the service is available.
     */
    public val status: Output<Int>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rocketmq.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.rocketmq.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
