@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ONS instance resource.
 * For more information about how to use it, see [RocketMQ Instance Management API](https://www.alibabacloud.com/help/doc-detail/106354.html).
 * > **NOTE:** The number of instances in the same region cannot exceed 8. At present, the resource does not support region "mq-internet-access" and "ap-southeast-5".
 * > **NOTE:** Available in 1.51.0+
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.rocketmq.Instance("example", {
 *     instanceName: `${name}-${_default.result}`,
 *     remark: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.rocketmq.Instance("example",
 *     instance_name=f"{name}-{default['result']}",
 *     remark=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.RocketMQ.Instance("example", new()
 *     {
 *         InstanceName = $"{name}-{@default.Result}",
 *         Remark = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rocketmq.NewInstance(ctx, "example", &rocketmq.InstanceArgs{
 * 			InstanceName: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Remark:       pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.rocketmq.Instance;
 * import com.pulumi.alicloud.rocketmq.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .instanceName(String.format("%s-%s", name,default_.result()))
 *             .remark(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:rocketmq:Instance
 *     properties:
 *       instanceName: ${name}-${default.result}
 *       remark: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ONS INSTANCE can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/instance:Instance instance MQ_INST_1234567890_Baso1234567
 * ```
 * @property instanceName Two instances on a single account in the same region cannot have the same name. The length must be 3 to 64 characters. Chinese characters, English letters digits and hyphen are allowed.
 * @property name Replaced by `instance_name` after version 1.97.0.
 * @property remark This attribute is a concise description of instance. The length cannot exceed 128.
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 */
public data class InstanceArgs(
    public val instanceName: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.97.0. Use 'instance_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val remark: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.InstanceArgs =
        com.pulumi.alicloud.rocketmq.InstanceArgs.builder()
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .remark(remark?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var instanceName: Output<String>? = null

    private var name: Output<String>? = null

    private var remark: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Two instances on a single account in the same region cannot have the same name. The length must be 3 to 64 characters. Chinese characters, English letters digits and hyphen are allowed.
     */
    @JvmName("jjtvnhliaahkfvjh")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value Replaced by `instance_name` after version 1.97.0.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.97.0. Use 'instance_name' instead.
  """,
    )
    @JvmName("ybunvkrfwwlqtitc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value This attribute is a concise description of instance. The length cannot exceed 128.
     */
    @JvmName("pwmfaqexrpnesefj")
    public suspend fun remark(`value`: Output<String>) {
        this.remark = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("rclvjrglhcvbnhyt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Two instances on a single account in the same region cannot have the same name. The length must be 3 to 64 characters. Chinese characters, English letters digits and hyphen are allowed.
     */
    @JvmName("malsoxcdvvryplyf")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value Replaced by `instance_name` after version 1.97.0.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.97.0. Use 'instance_name' instead.
  """,
    )
    @JvmName("ejcxpbxwawspbwma")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value This attribute is a concise description of instance. The length cannot exceed 128.
     */
    @JvmName("astefvocdvknowhr")
    public suspend fun remark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remark = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("xjxjblsqoagfgsjr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("npbjvgkqquyhrkfx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        instanceName = instanceName,
        name = name,
        remark = remark,
        tags = tags,
    )
}
