@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Qos].
 */
@PulumiTagMarker
public class QosResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QosArgs = QosArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QosArgsBuilder.() -> Unit) {
        val builder = QosArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Qos {
        val builtJavaResource = com.pulumi.alicloud.rocketmq.Qos(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Qos(builtJavaResource)
    }
}

/**
 * Provides a Sag Qos resource. Smart Access Gateway (SAG) supports quintuple-based QoS functions to differentiate traffic of different services and ensure high-priority traffic bandwidth.
 * For information about Sag Qos and how to use it, see [What is Qos](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createqos).
 * > **NOTE:** Available since v1.60.0.
 * > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.rocketmq.Qos("default", {name: "terraform-example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.rocketmq.Qos("default", name="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.RocketMQ.Qos("default", new()
 *     {
 *         Name = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rocketmq.NewQos(ctx, "default", &rocketmq.QosArgs{
 * 			Name: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rocketmq.Qos;
 * import com.pulumi.alicloud.rocketmq.QosArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Qos("default", QosArgs.builder()
 *             .name("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:rocketmq:Qos
 *     properties:
 *       name: terraform-example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Sag Qos can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/qos:Qos example qos-abc123456
 * ```
 */
public class Qos internal constructor(
    override val javaResource: com.pulumi.alicloud.rocketmq.Qos,
) : KotlinCustomResource(javaResource, QosMapper) {
    /**
     * The name of the QoS policy to be created. The name can contain 2 to 128 characters including a-z, A-Z, 0-9, periods, underlines, and hyphens. The name must start with an English letter, but cannot start with http:// or https://.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object QosMapper : ResourceMapper<Qos> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rocketmq.Qos::class == javaResource::class

    override fun map(javaResource: Resource): Qos = Qos(
        javaResource as
            com.pulumi.alicloud.rocketmq.Qos,
    )
}

/**
 * @see [Qos].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Qos].
 */
public suspend fun qos(name: String, block: suspend QosResourceBuilder.() -> Unit): Qos {
    val builder = QosResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Qos].
 * @param name The _unique_ name of the resulting resource.
 */
public fun qos(name: String): Qos {
    val builder = QosResourceBuilder()
    builder.name(name)
    return builder.build()
}
