@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [QosCar].
 */
@PulumiTagMarker
public class QosCarResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QosCarArgs = QosCarArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QosCarArgsBuilder.() -> Unit) {
        val builder = QosCarArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): QosCar {
        val builtJavaResource = com.pulumi.alicloud.rocketmq.QosCar(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return QosCar(builtJavaResource)
    }
}

/**
 * Provides a Sag Qos Car resource.
 * For information about Sag Qos Car and how to use it, see [What is Qos Car](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createqoscar).
 * > **NOTE:** Available since v1.60.0.
 * > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.rocketmq.Qos("default", {name: name});
 * const defaultQosCar = new alicloud.rocketmq.QosCar("default", {
 *     qosId: _default.id,
 *     name: name,
 *     description: name,
 *     priority: 1,
 *     limitType: "Absolute",
 *     minBandwidthAbs: 10,
 *     maxBandwidthAbs: 20,
 *     percentSourceType: "InternetUpBandwidth",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.rocketmq.Qos("default", name=name)
 * default_qos_car = alicloud.rocketmq.QosCar("default",
 *     qos_id=default.id,
 *     name=name,
 *     description=name,
 *     priority=1,
 *     limit_type="Absolute",
 *     min_bandwidth_abs=10,
 *     max_bandwidth_abs=20,
 *     percent_source_type="InternetUpBandwidth")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.RocketMQ.Qos("default", new()
 *     {
 *         Name = name,
 *     });
 *     var defaultQosCar = new AliCloud.RocketMQ.QosCar("default", new()
 *     {
 *         QosId = @default.Id,
 *         Name = name,
 *         Description = name,
 *         Priority = 1,
 *         LimitType = "Absolute",
 *         MinBandwidthAbs = 10,
 *         MaxBandwidthAbs = 20,
 *         PercentSourceType = "InternetUpBandwidth",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := rocketmq.NewQos(ctx, "default", &rocketmq.QosArgs{
 * 			Name: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rocketmq.NewQosCar(ctx, "default", &rocketmq.QosCarArgs{
 * 			QosId:             _default.ID(),
 * 			Name:              pulumi.String(name),
 * 			Description:       pulumi.String(name),
 * 			Priority:          pulumi.Int(1),
 * 			LimitType:         pulumi.String("Absolute"),
 * 			MinBandwidthAbs:   pulumi.Int(10),
 * 			MaxBandwidthAbs:   pulumi.Int(20),
 * 			PercentSourceType: pulumi.String("InternetUpBandwidth"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rocketmq.Qos;
 * import com.pulumi.alicloud.rocketmq.QosArgs;
 * import com.pulumi.alicloud.rocketmq.QosCar;
 * import com.pulumi.alicloud.rocketmq.QosCarArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Qos("default", QosArgs.builder()
 *             .name(name)
 *             .build());
 *         var defaultQosCar = new QosCar("defaultQosCar", QosCarArgs.builder()
 *             .qosId(default_.id())
 *             .name(name)
 *             .description(name)
 *             .priority("1")
 *             .limitType("Absolute")
 *             .minBandwidthAbs("10")
 *             .maxBandwidthAbs("20")
 *             .percentSourceType("InternetUpBandwidth")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:rocketmq:Qos
 *     properties:
 *       name: ${name}
 *   defaultQosCar:
 *     type: alicloud:rocketmq:QosCar
 *     name: default
 *     properties:
 *       qosId: ${default.id}
 *       name: ${name}
 *       description: ${name}
 *       priority: '1'
 *       limitType: Absolute
 *       minBandwidthAbs: '10'
 *       maxBandwidthAbs: '20'
 *       percentSourceType: InternetUpBandwidth
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Sag Qos Car can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/qosCar:QosCar example <qos_id>:<qos_car_id>
 * ```
 */
public class QosCar internal constructor(
    override val javaResource: com.pulumi.alicloud.rocketmq.QosCar,
) : KotlinCustomResource(javaResource, QosCarMapper) {
    /**
     * The description of the QoS speed limiting rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The speed limiting method. Valid values: `Absolute`, `Percent`.
     */
    public val limitType: Output<String>
        get() = javaResource.limitType().applyValue({ args0 -> args0 })

    /**
     * The maximum bandwidth allowed for the stream specified in the quintuple rule. This parameter is required when the value of the LimitType is Absolute.
     */
    public val maxBandwidthAbs: Output<Int>?
        get() = javaResource.maxBandwidthAbs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum bandwidth percentage allowed for the stream specified in the quintuple rule. It is based on the maximum upstream bandwidth you set for the associated Smart Access Gateway (SAG) instance.This parameter is required when the value of the LimitType parameter is Percent.
     */
    public val maxBandwidthPercent: Output<Int>?
        get() = javaResource.maxBandwidthPercent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The minimum bandwidth allowed for the stream specified in the quintuple rule. This parameter is required when the value of the LimitType parameter is Absolute.
     */
    public val minBandwidthAbs: Output<Int>?
        get() = javaResource.minBandwidthAbs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The minimum bandwidth percentage allowed for the stream specified in the quintuple rule. It is based on the maximum upstream bandwidth you set for the associated SAG instance.This parameter is required when the value of the LimitType parameter is Percent.
     */
    public val minBandwidthPercent: Output<Int>?
        get() = javaResource.minBandwidthPercent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the QoS speed limiting rule..
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The bandwidth type when the speed is limited based on percentage. Valid values: CcnBandwidth, InternetUpBandwidth.The default value is InternetUpBandwidth.
     */
    public val percentSourceType: Output<String>?
        get() = javaResource.percentSourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The priority of the specified stream.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * The instance ID of the QoS.
     */
    public val qosId: Output<String>
        get() = javaResource.qosId().applyValue({ args0 -> args0 })
}

public object QosCarMapper : ResourceMapper<QosCar> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rocketmq.QosCar::class == javaResource::class

    override fun map(javaResource: Resource): QosCar = QosCar(
        javaResource as
            com.pulumi.alicloud.rocketmq.QosCar,
    )
}

/**
 * @see [QosCar].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [QosCar].
 */
public suspend fun qosCar(name: String, block: suspend QosCarResourceBuilder.() -> Unit): QosCar {
    val builder = QosCarResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [QosCar].
 * @param name The _unique_ name of the resulting resource.
 */
public fun qosCar(name: String): QosCar {
    val builder = QosCarResourceBuilder()
    builder.name(name)
    return builder.build()
}
