@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.QosCarArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Sag Qos Car resource.
 * For information about Sag Qos Car and how to use it, see [What is Qos Car](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createqoscar).
 * > **NOTE:** Available since v1.60.0.
 * > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.rocketmq.Qos("default", {name: name});
 * const defaultQosCar = new alicloud.rocketmq.QosCar("default", {
 *     qosId: _default.id,
 *     name: name,
 *     description: name,
 *     priority: 1,
 *     limitType: "Absolute",
 *     minBandwidthAbs: 10,
 *     maxBandwidthAbs: 20,
 *     percentSourceType: "InternetUpBandwidth",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.rocketmq.Qos("default", name=name)
 * default_qos_car = alicloud.rocketmq.QosCar("default",
 *     qos_id=default.id,
 *     name=name,
 *     description=name,
 *     priority=1,
 *     limit_type="Absolute",
 *     min_bandwidth_abs=10,
 *     max_bandwidth_abs=20,
 *     percent_source_type="InternetUpBandwidth")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.RocketMQ.Qos("default", new()
 *     {
 *         Name = name,
 *     });
 *     var defaultQosCar = new AliCloud.RocketMQ.QosCar("default", new()
 *     {
 *         QosId = @default.Id,
 *         Name = name,
 *         Description = name,
 *         Priority = 1,
 *         LimitType = "Absolute",
 *         MinBandwidthAbs = 10,
 *         MaxBandwidthAbs = 20,
 *         PercentSourceType = "InternetUpBandwidth",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := rocketmq.NewQos(ctx, "default", &rocketmq.QosArgs{
 * 			Name: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rocketmq.NewQosCar(ctx, "default", &rocketmq.QosCarArgs{
 * 			QosId:             _default.ID(),
 * 			Name:              pulumi.String(name),
 * 			Description:       pulumi.String(name),
 * 			Priority:          pulumi.Int(1),
 * 			LimitType:         pulumi.String("Absolute"),
 * 			MinBandwidthAbs:   pulumi.Int(10),
 * 			MaxBandwidthAbs:   pulumi.Int(20),
 * 			PercentSourceType: pulumi.String("InternetUpBandwidth"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rocketmq.Qos;
 * import com.pulumi.alicloud.rocketmq.QosArgs;
 * import com.pulumi.alicloud.rocketmq.QosCar;
 * import com.pulumi.alicloud.rocketmq.QosCarArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Qos("default", QosArgs.builder()
 *             .name(name)
 *             .build());
 *         var defaultQosCar = new QosCar("defaultQosCar", QosCarArgs.builder()
 *             .qosId(default_.id())
 *             .name(name)
 *             .description(name)
 *             .priority("1")
 *             .limitType("Absolute")
 *             .minBandwidthAbs("10")
 *             .maxBandwidthAbs("20")
 *             .percentSourceType("InternetUpBandwidth")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:rocketmq:Qos
 *     properties:
 *       name: ${name}
 *   defaultQosCar:
 *     type: alicloud:rocketmq:QosCar
 *     name: default
 *     properties:
 *       qosId: ${default.id}
 *       name: ${name}
 *       description: ${name}
 *       priority: '1'
 *       limitType: Absolute
 *       minBandwidthAbs: '10'
 *       maxBandwidthAbs: '20'
 *       percentSourceType: InternetUpBandwidth
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Sag Qos Car can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/qosCar:QosCar example <qos_id>:<qos_car_id>
 * ```
 * @property description The description of the QoS speed limiting rule.
 * @property limitType The speed limiting method. Valid values: `Absolute`, `Percent`.
 * @property maxBandwidthAbs The maximum bandwidth allowed for the stream specified in the quintuple rule. This parameter is required when the value of the LimitType is Absolute.
 * @property maxBandwidthPercent The maximum bandwidth percentage allowed for the stream specified in the quintuple rule. It is based on the maximum upstream bandwidth you set for the associated Smart Access Gateway (SAG) instance.This parameter is required when the value of the LimitType parameter is Percent.
 * @property minBandwidthAbs The minimum bandwidth allowed for the stream specified in the quintuple rule. This parameter is required when the value of the LimitType parameter is Absolute.
 * @property minBandwidthPercent The minimum bandwidth percentage allowed for the stream specified in the quintuple rule. It is based on the maximum upstream bandwidth you set for the associated SAG instance.This parameter is required when the value of the LimitType parameter is Percent.
 * @property name The name of the QoS speed limiting rule..
 * @property percentSourceType The bandwidth type when the speed is limited based on percentage. Valid values: CcnBandwidth, InternetUpBandwidth.The default value is InternetUpBandwidth.
 * @property priority The priority of the specified stream.
 * @property qosId The instance ID of the QoS.
 */
public data class QosCarArgs(
    public val description: Output<String>? = null,
    public val limitType: Output<String>? = null,
    public val maxBandwidthAbs: Output<Int>? = null,
    public val maxBandwidthPercent: Output<Int>? = null,
    public val minBandwidthAbs: Output<Int>? = null,
    public val minBandwidthPercent: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val percentSourceType: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val qosId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.QosCarArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.QosCarArgs =
        com.pulumi.alicloud.rocketmq.QosCarArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .limitType(limitType?.applyValue({ args0 -> args0 }))
            .maxBandwidthAbs(maxBandwidthAbs?.applyValue({ args0 -> args0 }))
            .maxBandwidthPercent(maxBandwidthPercent?.applyValue({ args0 -> args0 }))
            .minBandwidthAbs(minBandwidthAbs?.applyValue({ args0 -> args0 }))
            .minBandwidthPercent(minBandwidthPercent?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .percentSourceType(percentSourceType?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .qosId(qosId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QosCarArgs].
 */
@PulumiTagMarker
public class QosCarArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var limitType: Output<String>? = null

    private var maxBandwidthAbs: Output<Int>? = null

    private var maxBandwidthPercent: Output<Int>? = null

    private var minBandwidthAbs: Output<Int>? = null

    private var minBandwidthPercent: Output<Int>? = null

    private var name: Output<String>? = null

    private var percentSourceType: Output<String>? = null

    private var priority: Output<Int>? = null

    private var qosId: Output<String>? = null

    /**
     * @param value The description of the QoS speed limiting rule.
     */
    @JvmName("pgpbosfpwclvxtil")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The speed limiting method. Valid values: `Absolute`, `Percent`.
     */
    @JvmName("tlbyddeopjhxwejq")
    public suspend fun limitType(`value`: Output<String>) {
        this.limitType = value
    }

    /**
     * @param value The maximum bandwidth allowed for the stream specified in the quintuple rule. This parameter is required when the value of the LimitType is Absolute.
     */
    @JvmName("rrkkffsqxgnximnr")
    public suspend fun maxBandwidthAbs(`value`: Output<Int>) {
        this.maxBandwidthAbs = value
    }

    /**
     * @param value The maximum bandwidth percentage allowed for the stream specified in the quintuple rule. It is based on the maximum upstream bandwidth you set for the associated Smart Access Gateway (SAG) instance.This parameter is required when the value of the LimitType parameter is Percent.
     */
    @JvmName("emdebpqxgekrejbk")
    public suspend fun maxBandwidthPercent(`value`: Output<Int>) {
        this.maxBandwidthPercent = value
    }

    /**
     * @param value The minimum bandwidth allowed for the stream specified in the quintuple rule. This parameter is required when the value of the LimitType parameter is Absolute.
     */
    @JvmName("uljbnmsxcvdvsuie")
    public suspend fun minBandwidthAbs(`value`: Output<Int>) {
        this.minBandwidthAbs = value
    }

    /**
     * @param value The minimum bandwidth percentage allowed for the stream specified in the quintuple rule. It is based on the maximum upstream bandwidth you set for the associated SAG instance.This parameter is required when the value of the LimitType parameter is Percent.
     */
    @JvmName("jutjgpsccwncylxx")
    public suspend fun minBandwidthPercent(`value`: Output<Int>) {
        this.minBandwidthPercent = value
    }

    /**
     * @param value The name of the QoS speed limiting rule..
     */
    @JvmName("hqxnlgwqqsmcpkwn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The bandwidth type when the speed is limited based on percentage. Valid values: CcnBandwidth, InternetUpBandwidth.The default value is InternetUpBandwidth.
     */
    @JvmName("ripunncocfatxipf")
    public suspend fun percentSourceType(`value`: Output<String>) {
        this.percentSourceType = value
    }

    /**
     * @param value The priority of the specified stream.
     */
    @JvmName("yampingleyguiphj")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The instance ID of the QoS.
     */
    @JvmName("dmoxujxhrocxvebu")
    public suspend fun qosId(`value`: Output<String>) {
        this.qosId = value
    }

    /**
     * @param value The description of the QoS speed limiting rule.
     */
    @JvmName("ujesconkqajxkhbs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The speed limiting method. Valid values: `Absolute`, `Percent`.
     */
    @JvmName("htsewejmtxjapepg")
    public suspend fun limitType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitType = mapped
    }

    /**
     * @param value The maximum bandwidth allowed for the stream specified in the quintuple rule. This parameter is required when the value of the LimitType is Absolute.
     */
    @JvmName("jgyjaexhaenscqph")
    public suspend fun maxBandwidthAbs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBandwidthAbs = mapped
    }

    /**
     * @param value The maximum bandwidth percentage allowed for the stream specified in the quintuple rule. It is based on the maximum upstream bandwidth you set for the associated Smart Access Gateway (SAG) instance.This parameter is required when the value of the LimitType parameter is Percent.
     */
    @JvmName("jmcnwcaoombmqbiu")
    public suspend fun maxBandwidthPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBandwidthPercent = mapped
    }

    /**
     * @param value The minimum bandwidth allowed for the stream specified in the quintuple rule. This parameter is required when the value of the LimitType parameter is Absolute.
     */
    @JvmName("kwsmpfkpcyuavjaj")
    public suspend fun minBandwidthAbs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minBandwidthAbs = mapped
    }

    /**
     * @param value The minimum bandwidth percentage allowed for the stream specified in the quintuple rule. It is based on the maximum upstream bandwidth you set for the associated SAG instance.This parameter is required when the value of the LimitType parameter is Percent.
     */
    @JvmName("qenpdmeuytppqfve")
    public suspend fun minBandwidthPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minBandwidthPercent = mapped
    }

    /**
     * @param value The name of the QoS speed limiting rule..
     */
    @JvmName("qookwdkmejjghfxj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The bandwidth type when the speed is limited based on percentage. Valid values: CcnBandwidth, InternetUpBandwidth.The default value is InternetUpBandwidth.
     */
    @JvmName("fobnvasnwcppwqlf")
    public suspend fun percentSourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentSourceType = mapped
    }

    /**
     * @param value The priority of the specified stream.
     */
    @JvmName("hkyuleikwtalbivm")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The instance ID of the QoS.
     */
    @JvmName("bwqohhhahajcwnuy")
    public suspend fun qosId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qosId = mapped
    }

    internal fun build(): QosCarArgs = QosCarArgs(
        description = description,
        limitType = limitType,
        maxBandwidthAbs = maxBandwidthAbs,
        maxBandwidthPercent = maxBandwidthPercent,
        minBandwidthAbs = minBandwidthAbs,
        minBandwidthPercent = minBandwidthPercent,
        name = name,
        percentSourceType = percentSourceType,
        priority = priority,
        qosId = qosId,
    )
}
