@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [QosPolicy].
 */
@PulumiTagMarker
public class QosPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QosPolicyArgs = QosPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QosPolicyArgsBuilder.() -> Unit) {
        val builder = QosPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): QosPolicy {
        val builtJavaResource = com.pulumi.alicloud.rocketmq.QosPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return QosPolicy(builtJavaResource)
    }
}

/**
 * Provides a Sag qos policy resource.
 * You need to create a QoS policy to set priorities, rate limits, and quintuple rules for different messages.
 * For information about Sag Qos Policy and how to use it, see [What is Qos Policy](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createqospolicy).
 * > **NOTE:** Available since v1.60.0.
 * > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Import
 * The Sag Qos Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/qosPolicy:QosPolicy example qos-abc123456:qospy-abc123456
 * ```
 */
public class QosPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.rocketmq.QosPolicy,
) : KotlinCustomResource(javaResource, QosPolicyMapper) {
    /**
     * The description of the QoS policy.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The destination CIDR block.
     */
    public val destCidr: Output<String>
        get() = javaResource.destCidr().applyValue({ args0 -> args0 })

    /**
     * The destination port range.
     */
    public val destPortRange: Output<String>
        get() = javaResource.destPortRange().applyValue({ args0 -> args0 })

    /**
     * The expiration time of the quintuple rule.
     */
    public val endTime: Output<String>?
        get() = javaResource.endTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The transport layer protocol.
     */
    public val ipProtocol: Output<String>
        get() = javaResource.ipProtocol().applyValue({ args0 -> args0 })

    /**
     * The name of the QoS policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The priority of the quintuple rule. A smaller value indicates a higher priority. If the priorities of two quintuple rules are the same, the rule created earlier is applied first.Value range: 1 to 7.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * The instance ID of the QoS policy to which the quintuple rule is created.
     */
    public val qosId: Output<String>
        get() = javaResource.qosId().applyValue({ args0 -> args0 })

    /**
     * The source CIDR block.
     */
    public val sourceCidr: Output<String>
        get() = javaResource.sourceCidr().applyValue({ args0 -> args0 })

    /**
     * The source port range of the transport layer.
     */
    public val sourcePortRange: Output<String>
        get() = javaResource.sourcePortRange().applyValue({ args0 -> args0 })

    /**
     * The time when the quintuple rule takes effect.
     */
    public val startTime: Output<String>?
        get() = javaResource.startTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object QosPolicyMapper : ResourceMapper<QosPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rocketmq.QosPolicy::class == javaResource::class

    override fun map(javaResource: Resource): QosPolicy = QosPolicy(
        javaResource as
            com.pulumi.alicloud.rocketmq.QosPolicy,
    )
}

/**
 * @see [QosPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [QosPolicy].
 */
public suspend fun qosPolicy(name: String, block: suspend QosPolicyResourceBuilder.() -> Unit): QosPolicy {
    val builder = QosPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [QosPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun qosPolicy(name: String): QosPolicy {
    val builder = QosPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
