@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.QosPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Sag qos policy resource.
 * You need to create a QoS policy to set priorities, rate limits, and quintuple rules for different messages.
 * For information about Sag Qos Policy and how to use it, see [What is Qos Policy](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createqospolicy).
 * > **NOTE:** Available since v1.60.0.
 * > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Import
 * The Sag Qos Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/qosPolicy:QosPolicy example qos-abc123456:qospy-abc123456
 * ```
 * @property description The description of the QoS policy.
 * @property destCidr The destination CIDR block.
 * @property destPortRange The destination port range.
 * @property endTime The expiration time of the quintuple rule.
 * @property ipProtocol The transport layer protocol.
 * @property name The name of the QoS policy.
 * @property priority The priority of the quintuple rule. A smaller value indicates a higher priority. If the priorities of two quintuple rules are the same, the rule created earlier is applied first.Value range: 1 to 7.
 * @property qosId The instance ID of the QoS policy to which the quintuple rule is created.
 * @property sourceCidr The source CIDR block.
 * @property sourcePortRange The source port range of the transport layer.
 * @property startTime The time when the quintuple rule takes effect.
 */
public data class QosPolicyArgs(
    public val description: Output<String>? = null,
    public val destCidr: Output<String>? = null,
    public val destPortRange: Output<String>? = null,
    public val endTime: Output<String>? = null,
    public val ipProtocol: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val qosId: Output<String>? = null,
    public val sourceCidr: Output<String>? = null,
    public val sourcePortRange: Output<String>? = null,
    public val startTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.QosPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.QosPolicyArgs =
        com.pulumi.alicloud.rocketmq.QosPolicyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destCidr(destCidr?.applyValue({ args0 -> args0 }))
            .destPortRange(destPortRange?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .ipProtocol(ipProtocol?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .qosId(qosId?.applyValue({ args0 -> args0 }))
            .sourceCidr(sourceCidr?.applyValue({ args0 -> args0 }))
            .sourcePortRange(sourcePortRange?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QosPolicyArgs].
 */
@PulumiTagMarker
public class QosPolicyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destCidr: Output<String>? = null

    private var destPortRange: Output<String>? = null

    private var endTime: Output<String>? = null

    private var ipProtocol: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var qosId: Output<String>? = null

    private var sourceCidr: Output<String>? = null

    private var sourcePortRange: Output<String>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value The description of the QoS policy.
     */
    @JvmName("vlbsrdjvygpophyn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The destination CIDR block.
     */
    @JvmName("frbiechaymxtwsxk")
    public suspend fun destCidr(`value`: Output<String>) {
        this.destCidr = value
    }

    /**
     * @param value The destination port range.
     */
    @JvmName("pxuxovsunsdqwcau")
    public suspend fun destPortRange(`value`: Output<String>) {
        this.destPortRange = value
    }

    /**
     * @param value The expiration time of the quintuple rule.
     */
    @JvmName("pthnfayvneuyahqg")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value The transport layer protocol.
     */
    @JvmName("jultbmktmcbyjrff")
    public suspend fun ipProtocol(`value`: Output<String>) {
        this.ipProtocol = value
    }

    /**
     * @param value The name of the QoS policy.
     */
    @JvmName("bvqqwevfbwvkbdgj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The priority of the quintuple rule. A smaller value indicates a higher priority. If the priorities of two quintuple rules are the same, the rule created earlier is applied first.Value range: 1 to 7.
     */
    @JvmName("emsearwpawotqgqc")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The instance ID of the QoS policy to which the quintuple rule is created.
     */
    @JvmName("dmwwgyqviixxbafo")
    public suspend fun qosId(`value`: Output<String>) {
        this.qosId = value
    }

    /**
     * @param value The source CIDR block.
     */
    @JvmName("xivytjuypbcnmdsx")
    public suspend fun sourceCidr(`value`: Output<String>) {
        this.sourceCidr = value
    }

    /**
     * @param value The source port range of the transport layer.
     */
    @JvmName("vnxlivhxgaakewse")
    public suspend fun sourcePortRange(`value`: Output<String>) {
        this.sourcePortRange = value
    }

    /**
     * @param value The time when the quintuple rule takes effect.
     */
    @JvmName("hvowsqwfsrkgnfml")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The description of the QoS policy.
     */
    @JvmName("ipgfuaivcdwlakqe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The destination CIDR block.
     */
    @JvmName("fxjnrmqbvqwugpmx")
    public suspend fun destCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destCidr = mapped
    }

    /**
     * @param value The destination port range.
     */
    @JvmName("nkfibyamgtyqckay")
    public suspend fun destPortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destPortRange = mapped
    }

    /**
     * @param value The expiration time of the quintuple rule.
     */
    @JvmName("kqxvypqrhbnmktka")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value The transport layer protocol.
     */
    @JvmName("ucytfyvgvfhryipa")
    public suspend fun ipProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipProtocol = mapped
    }

    /**
     * @param value The name of the QoS policy.
     */
    @JvmName("wmiudanyodpkkfgg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The priority of the quintuple rule. A smaller value indicates a higher priority. If the priorities of two quintuple rules are the same, the rule created earlier is applied first.Value range: 1 to 7.
     */
    @JvmName("htmtenwbosvsbsvr")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The instance ID of the QoS policy to which the quintuple rule is created.
     */
    @JvmName("gqlpixunilqaxvyp")
    public suspend fun qosId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qosId = mapped
    }

    /**
     * @param value The source CIDR block.
     */
    @JvmName("wuseiddwfkqoujpc")
    public suspend fun sourceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceCidr = mapped
    }

    /**
     * @param value The source port range of the transport layer.
     */
    @JvmName("mqliygkaqfhgmtvu")
    public suspend fun sourcePortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRange = mapped
    }

    /**
     * @param value The time when the quintuple rule takes effect.
     */
    @JvmName("yixoojsrcakqcari")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): QosPolicyArgs = QosPolicyArgs(
        description = description,
        destCidr = destCidr,
        destPortRange = destPortRange,
        endTime = endTime,
        ipProtocol = ipProtocol,
        name = name,
        priority = priority,
        qosId = qosId,
        sourceCidr = sourceCidr,
        sourcePortRange = sourcePortRange,
        startTime = startTime,
    )
}
