@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.kotlin.outputs.RocketMQInstanceNetworkInfo
import com.pulumi.alicloud.rocketmq.kotlin.outputs.RocketMQInstanceProductInfo
import com.pulumi.alicloud.rocketmq.kotlin.outputs.RocketMQInstanceSoftware
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.alicloud.rocketmq.kotlin.outputs.RocketMQInstanceNetworkInfo.Companion.toKotlin as rocketMQInstanceNetworkInfoToKotlin
import com.pulumi.alicloud.rocketmq.kotlin.outputs.RocketMQInstanceProductInfo.Companion.toKotlin as rocketMQInstanceProductInfoToKotlin
import com.pulumi.alicloud.rocketmq.kotlin.outputs.RocketMQInstanceSoftware.Companion.toKotlin as rocketMQInstanceSoftwareToKotlin

/**
 * Builder for [RocketMQInstance].
 */
@PulumiTagMarker
public class RocketMQInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RocketMQInstanceArgs = RocketMQInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RocketMQInstanceArgsBuilder.() -> Unit) {
        val builder = RocketMQInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RocketMQInstance {
        val builtJavaResource = com.pulumi.alicloud.rocketmq.RocketMQInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RocketMQInstance(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * RocketMQ Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/rocketMQInstance:RocketMQInstance example <id>
 * ```
 */
public class RocketMQInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.rocketmq.RocketMQInstance,
) : KotlinCustomResource(javaResource, RocketMQInstanceMapper) {
    /**
     * Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
     * - true: Enable auto-renewal
     * - false: Disable auto-renewal.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Auto-renewal period. This parameter is only valid when auto-renewal is enabled. The values can be as follows: 1, 2, 3, 6, 12.
     */
    public val autoRenewPeriod: Output<Int>?
        get() = javaResource.autoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
     */
    public val autoRenewPeriodUnit: Output<String>
        get() = javaResource.autoRenewPeriodUnit().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The name of instance.
     */
    public val instanceName: Output<String>?
        get() = javaResource.instanceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance network configuration information. See `network_info` below.
     */
    public val networkInfo: Output<RocketMQInstanceNetworkInfo>
        get() = javaResource.networkInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                rocketMQInstanceNetworkInfoToKotlin(args0)
            })
        })

    /**
     * The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment. The parameter values are as follows:
     * - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
     * - Subscription: Subscription-based, a pre-payment model where you pay before usage.
     * For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid). The values can be as follows:
     * - Monthly purchase: 1, 2, 3, 4, 5, 6
     * - Annual purchase: 1, 2, 3.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The minimum periodic unit for the duration of purchase. The parameter values are as follows:
     * - Month: Purchase on a monthly basis
     * - Year: Purchase on an annual basis.
     */
    public val periodUnit: Output<String>
        get() = javaResource.periodUnit().applyValue({ args0 -> args0 })

    /**
     * product info. See `product_info` below.
     */
    public val productInfo: Output<RocketMQInstanceProductInfo>?
        get() = javaResource.productInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    rocketMQInstanceProductInfoToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Custom description.
     */
    public val remark: Output<String>?
        get() = javaResource.remark().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
     * - standard: Standard Edition
     * - ultimate: Platinum Edition
     * - professional: Professional Edition.
     */
    public val seriesCode: Output<String>
        get() = javaResource.seriesCode().applyValue({ args0 -> args0 })

    /**
     * The code of the service code instance. The code of the RocketMQ is rmq.
     */
    public val serviceCode: Output<String>
        get() = javaResource.serviceCode().applyValue({ args0 -> args0 })

    /**
     * Instance software information. See `software` below.
     */
    public val software: Output<RocketMQInstanceSoftware>
        get() = javaResource.software().applyValue({ args0 ->
            args0.let({ args0 ->
                rocketMQInstanceSoftwareToKotlin(args0)
            })
        })

    /**
     * The status of the instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
     * - cluster_ha: Cluster High Availability Edition
     * - single_node: Single Node Testing Edition
     * When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
     */
    public val subSeriesCode: Output<String>
        get() = javaResource.subSeriesCode().applyValue({ args0 -> args0 })

    /**
     * The resource label.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object RocketMQInstanceMapper : ResourceMapper<RocketMQInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rocketmq.RocketMQInstance::class == javaResource::class

    override fun map(javaResource: Resource): RocketMQInstance = RocketMQInstance(
        javaResource as
            com.pulumi.alicloud.rocketmq.RocketMQInstance,
    )
}

/**
 * @see [RocketMQInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RocketMQInstance].
 */
public suspend fun rocketMQInstance(
    name: String,
    block: suspend RocketMQInstanceResourceBuilder.() -> Unit,
): RocketMQInstance {
    val builder = RocketMQInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RocketMQInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rocketMQInstance(name: String): RocketMQInstance {
    val builder = RocketMQInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
