@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.RocketMQInstanceArgs.builder
import com.pulumi.alicloud.rocketmq.kotlin.inputs.RocketMQInstanceNetworkInfoArgs
import com.pulumi.alicloud.rocketmq.kotlin.inputs.RocketMQInstanceNetworkInfoArgsBuilder
import com.pulumi.alicloud.rocketmq.kotlin.inputs.RocketMQInstanceProductInfoArgs
import com.pulumi.alicloud.rocketmq.kotlin.inputs.RocketMQInstanceProductInfoArgsBuilder
import com.pulumi.alicloud.rocketmq.kotlin.inputs.RocketMQInstanceSoftwareArgs
import com.pulumi.alicloud.rocketmq.kotlin.inputs.RocketMQInstanceSoftwareArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * RocketMQ Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/rocketMQInstance:RocketMQInstance example <id>
 * ```
 * @property autoRenew Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
 * - true: Enable auto-renewal
 * - false: Disable auto-renewal.
 * @property autoRenewPeriod Auto-renewal period. This parameter is only valid when auto-renewal is enabled. The values can be as follows: 1, 2, 3, 6, 12.
 * @property autoRenewPeriodUnit The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
 * @property instanceName The name of instance.
 * @property networkInfo Instance network configuration information. See `network_info` below.
 * @property paymentType The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment. The parameter values are as follows:
 * - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
 * - Subscription: Subscription-based, a pre-payment model where you pay before usage.
 * For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
 * @property period Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid). The values can be as follows:
 * - Monthly purchase: 1, 2, 3, 4, 5, 6
 * - Annual purchase: 1, 2, 3.
 * @property periodUnit The minimum periodic unit for the duration of purchase. The parameter values are as follows:
 * - Month: Purchase on a monthly basis
 * - Year: Purchase on an annual basis.
 * @property productInfo product info. See `product_info` below.
 * @property remark Custom description.
 * @property resourceGroupId The ID of the resource group.
 * @property seriesCode The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
 * - standard: Standard Edition
 * - ultimate: Platinum Edition
 * - professional: Professional Edition.
 * @property serviceCode The code of the service code instance. The code of the RocketMQ is rmq.
 * @property software Instance software information. See `software` below.
 * @property subSeriesCode The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
 * - cluster_ha: Cluster High Availability Edition
 * - single_node: Single Node Testing Edition
 * When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
 * @property tags The resource label.
 */
public data class RocketMQInstanceArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val autoRenewPeriodUnit: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val networkInfo: Output<RocketMQInstanceNetworkInfoArgs>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val productInfo: Output<RocketMQInstanceProductInfoArgs>? = null,
    public val remark: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val seriesCode: Output<String>? = null,
    public val serviceCode: Output<String>? = null,
    public val software: Output<RocketMQInstanceSoftwareArgs>? = null,
    public val subSeriesCode: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.RocketMQInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.RocketMQInstanceArgs =
        com.pulumi.alicloud.rocketmq.RocketMQInstanceArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .autoRenewPeriodUnit(autoRenewPeriodUnit?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .networkInfo(networkInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .productInfo(productInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .remark(remark?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .seriesCode(seriesCode?.applyValue({ args0 -> args0 }))
            .serviceCode(serviceCode?.applyValue({ args0 -> args0 }))
            .software(software?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subSeriesCode(subSeriesCode?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RocketMQInstanceArgs].
 */
@PulumiTagMarker
public class RocketMQInstanceArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var autoRenewPeriodUnit: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var networkInfo: Output<RocketMQInstanceNetworkInfoArgs>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var productInfo: Output<RocketMQInstanceProductInfoArgs>? = null

    private var remark: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var seriesCode: Output<String>? = null

    private var serviceCode: Output<String>? = null

    private var software: Output<RocketMQInstanceSoftwareArgs>? = null

    private var subSeriesCode: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
     * - true: Enable auto-renewal
     * - false: Disable auto-renewal.
     */
    @JvmName("kmbqikbgprujlsxx")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Auto-renewal period. This parameter is only valid when auto-renewal is enabled. The values can be as follows: 1, 2, 3, 6, 12.
     */
    @JvmName("rehbmfxjlkdsmocy")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
     */
    @JvmName("ixkpbyfunxjkggmn")
    public suspend fun autoRenewPeriodUnit(`value`: Output<String>) {
        this.autoRenewPeriodUnit = value
    }

    /**
     * @param value The name of instance.
     */
    @JvmName("erthwsnawghpueur")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value Instance network configuration information. See `network_info` below.
     */
    @JvmName("xsioflxxdhtfhlec")
    public suspend fun networkInfo(`value`: Output<RocketMQInstanceNetworkInfoArgs>) {
        this.networkInfo = value
    }

    /**
     * @param value The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment. The parameter values are as follows:
     * - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
     * - Subscription: Subscription-based, a pre-payment model where you pay before usage.
     * For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
     */
    @JvmName("mbkpxyboeetjlcnd")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid). The values can be as follows:
     * - Monthly purchase: 1, 2, 3, 4, 5, 6
     * - Annual purchase: 1, 2, 3.
     */
    @JvmName("oaxctkncplselryw")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The minimum periodic unit for the duration of purchase. The parameter values are as follows:
     * - Month: Purchase on a monthly basis
     * - Year: Purchase on an annual basis.
     */
    @JvmName("bgoqjunhvtslvhjo")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value product info. See `product_info` below.
     */
    @JvmName("oriaggssljattkqc")
    public suspend fun productInfo(`value`: Output<RocketMQInstanceProductInfoArgs>) {
        this.productInfo = value
    }

    /**
     * @param value Custom description.
     */
    @JvmName("hhcqvgbnxgvutelq")
    public suspend fun remark(`value`: Output<String>) {
        this.remark = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("ismtygjhahvojbix")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
     * - standard: Standard Edition
     * - ultimate: Platinum Edition
     * - professional: Professional Edition.
     */
    @JvmName("dejseqjssltsssjh")
    public suspend fun seriesCode(`value`: Output<String>) {
        this.seriesCode = value
    }

    /**
     * @param value The code of the service code instance. The code of the RocketMQ is rmq.
     */
    @JvmName("hnmfagiufldqgxvu")
    public suspend fun serviceCode(`value`: Output<String>) {
        this.serviceCode = value
    }

    /**
     * @param value Instance software information. See `software` below.
     */
    @JvmName("fuwvpssvurwgiych")
    public suspend fun software(`value`: Output<RocketMQInstanceSoftwareArgs>) {
        this.software = value
    }

    /**
     * @param value The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
     * - cluster_ha: Cluster High Availability Edition
     * - single_node: Single Node Testing Edition
     * When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
     */
    @JvmName("hiywonsnqfydfuui")
    public suspend fun subSeriesCode(`value`: Output<String>) {
        this.subSeriesCode = value
    }

    /**
     * @param value The resource label.
     */
    @JvmName("fwstjtvtnsfdrxtv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
     * - true: Enable auto-renewal
     * - false: Disable auto-renewal.
     */
    @JvmName("itvskargfenmwmds")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Auto-renewal period. This parameter is only valid when auto-renewal is enabled. The values can be as follows: 1, 2, 3, 6, 12.
     */
    @JvmName("ljnjdpuqarkvplxv")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
     */
    @JvmName("gyqpsmeneavrniyt")
    public suspend fun autoRenewPeriodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriodUnit = mapped
    }

    /**
     * @param value The name of instance.
     */
    @JvmName("ramoerowppowujkv")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value Instance network configuration information. See `network_info` below.
     */
    @JvmName("flxwjpcthmgjguhn")
    public suspend fun networkInfo(`value`: RocketMQInstanceNetworkInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInfo = mapped
    }

    /**
     * @param argument Instance network configuration information. See `network_info` below.
     */
    @JvmName("tirjwesmgpmimwpq")
    public suspend fun networkInfo(argument: suspend RocketMQInstanceNetworkInfoArgsBuilder.() -> Unit) {
        val toBeMapped = RocketMQInstanceNetworkInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkInfo = mapped
    }

    /**
     * @param value The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment. The parameter values are as follows:
     * - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
     * - Subscription: Subscription-based, a pre-payment model where you pay before usage.
     * For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
     */
    @JvmName("jchbqtsefvlrpqoy")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid). The values can be as follows:
     * - Monthly purchase: 1, 2, 3, 4, 5, 6
     * - Annual purchase: 1, 2, 3.
     */
    @JvmName("wwylxglpvxyrbwdm")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The minimum periodic unit for the duration of purchase. The parameter values are as follows:
     * - Month: Purchase on a monthly basis
     * - Year: Purchase on an annual basis.
     */
    @JvmName("cvmkvwrgbxkslxek")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value product info. See `product_info` below.
     */
    @JvmName("hfxmasfjipchhgnk")
    public suspend fun productInfo(`value`: RocketMQInstanceProductInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productInfo = mapped
    }

    /**
     * @param argument product info. See `product_info` below.
     */
    @JvmName("evbwifsyncvmpnke")
    public suspend fun productInfo(argument: suspend RocketMQInstanceProductInfoArgsBuilder.() -> Unit) {
        val toBeMapped = RocketMQInstanceProductInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.productInfo = mapped
    }

    /**
     * @param value Custom description.
     */
    @JvmName("ublhbsoextimfuic")
    public suspend fun remark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remark = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("chpxbtlurekaunrb")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
     * - standard: Standard Edition
     * - ultimate: Platinum Edition
     * - professional: Professional Edition.
     */
    @JvmName("pirmlrrqguvdllbc")
    public suspend fun seriesCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.seriesCode = mapped
    }

    /**
     * @param value The code of the service code instance. The code of the RocketMQ is rmq.
     */
    @JvmName("iajcnumvjcajvebg")
    public suspend fun serviceCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCode = mapped
    }

    /**
     * @param value Instance software information. See `software` below.
     */
    @JvmName("hjonahjqflytklvs")
    public suspend fun software(`value`: RocketMQInstanceSoftwareArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.software = mapped
    }

    /**
     * @param argument Instance software information. See `software` below.
     */
    @JvmName("wokbxgevxvihdegj")
    public suspend fun software(argument: suspend RocketMQInstanceSoftwareArgsBuilder.() -> Unit) {
        val toBeMapped = RocketMQInstanceSoftwareArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.software = mapped
    }

    /**
     * @param value The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
     * - cluster_ha: Cluster High Availability Edition
     * - single_node: Single Node Testing Edition
     * When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
     */
    @JvmName("nvuklkwesiofjhmb")
    public suspend fun subSeriesCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subSeriesCode = mapped
    }

    /**
     * @param value The resource label.
     */
    @JvmName("nekjouefevyxmfdq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource label.
     */
    @JvmName("yvkpmyfnqorortyy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RocketMQInstanceArgs = RocketMQInstanceArgs(
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        autoRenewPeriodUnit = autoRenewPeriodUnit,
        instanceName = instanceName,
        networkInfo = networkInfo,
        paymentType = paymentType,
        period = period,
        periodUnit = periodUnit,
        productInfo = productInfo,
        remark = remark,
        resourceGroupId = resourceGroupId,
        seriesCode = seriesCode,
        serviceCode = serviceCode,
        software = software,
        subSeriesCode = subSeriesCode,
        tags = tags,
    )
}
