@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.RocketMQTopicArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a RocketMQ Topic resource.
 * For information about RocketMQ Topic and how to use it, see [What is Topic](https://www.alibabacloud.com/help/en/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/developer-reference/api-rocketmq-2022-08-01-createtopic).
 * > **NOTE:** Available since v1.211.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const createVpc = new alicloud.vpc.Network("createVpc", {
 *     description: "example",
 *     cidrBlock: "172.16.0.0/12",
 *     vpcName: name,
 * });
 * const createVswitch = new alicloud.vpc.Switch("createVswitch", {
 *     description: "example",
 *     vpcId: createVpc.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     cidrBlock: "172.16.0.0/24",
 *     vswitchName: name,
 * });
 * const createInstance = new alicloud.rocketmq.RocketMQInstance("createInstance", {
 *     autoRenewPeriod: 1,
 *     productInfo: {
 *         msgProcessSpec: "rmq.p2.4xlarge",
 *         sendReceiveRatio: 0.3,
 *         messageRetentionTime: 70,
 *     },
 *     networkInfo: {
 *         vpcInfo: {
 *             vpcId: createVpc.id,
 *             vswitchId: createVswitch.id,
 *         },
 *         internetInfo: {
 *             internetSpec: "enable",
 *             flowOutType: "payByBandwidth",
 *             flowOutBandwidth: 30,
 *         },
 *     },
 *     period: 1,
 *     subSeriesCode: "cluster_ha",
 *     remark: "example",
 *     instanceName: name,
 *     serviceCode: "rmq",
 *     seriesCode: "professional",
 *     paymentType: "PayAsYouGo",
 *     periodUnit: "Month",
 * });
 * const defaultRocketMQTopic = new alicloud.rocketmq.RocketMQTopic("default", {
 *     remark: "example",
 *     instanceId: createInstance.id,
 *     messageType: "NORMAL",
 *     topicName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * create_vpc = alicloud.vpc.Network("createVpc",
 *     description="example",
 *     cidr_block="172.16.0.0/12",
 *     vpc_name=name)
 * create_vswitch = alicloud.vpc.Switch("createVswitch",
 *     description="example",
 *     vpc_id=create_vpc.id,
 *     zone_id=default.zones[0].id,
 *     cidr_block="172.16.0.0/24",
 *     vswitch_name=name)
 * create_instance = alicloud.rocketmq.RocketMQInstance("createInstance",
 *     auto_renew_period=1,
 *     product_info={
 *         "msg_process_spec": "rmq.p2.4xlarge",
 *         "send_receive_ratio": 0.3,
 *         "message_retention_time": 70,
 *     },
 *     network_info={
 *         "vpc_info": {
 *             "vpc_id": create_vpc.id,
 *             "vswitch_id": create_vswitch.id,
 *         },
 *         "internet_info": {
 *             "internet_spec": "enable",
 *             "flow_out_type": "payByBandwidth",
 *             "flow_out_bandwidth": 30,
 *         },
 *     },
 *     period=1,
 *     sub_series_code="cluster_ha",
 *     remark="example",
 *     instance_name=name,
 *     service_code="rmq",
 *     series_code="professional",
 *     payment_type="PayAsYouGo",
 *     period_unit="Month")
 * default_rocket_mq_topic = alicloud.rocketmq.RocketMQTopic("default",
 *     remark="example",
 *     instance_id=create_instance.id,
 *     message_type="NORMAL",
 *     topic_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var createVpc = new AliCloud.Vpc.Network("createVpc", new()
 *     {
 *         Description = "example",
 *         CidrBlock = "172.16.0.0/12",
 *         VpcName = name,
 *     });
 *     var createVswitch = new AliCloud.Vpc.Switch("createVswitch", new()
 *     {
 *         Description = "example",
 *         VpcId = createVpc.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         CidrBlock = "172.16.0.0/24",
 *         VswitchName = name,
 *     });
 *     var createInstance = new AliCloud.RocketMQ.RocketMQInstance("createInstance", new()
 *     {
 *         AutoRenewPeriod = 1,
 *         ProductInfo = new AliCloud.RocketMQ.Inputs.RocketMQInstanceProductInfoArgs
 *         {
 *             MsgProcessSpec = "rmq.p2.4xlarge",
 *             SendReceiveRatio = 0.3,
 *             MessageRetentionTime = 70,
 *         },
 *         NetworkInfo = new AliCloud.RocketMQ.Inputs.RocketMQInstanceNetworkInfoArgs
 *         {
 *             VpcInfo = new AliCloud.RocketMQ.Inputs.RocketMQInstanceNetworkInfoVpcInfoArgs
 *             {
 *                 VpcId = createVpc.Id,
 *                 VswitchId = createVswitch.Id,
 *             },
 *             InternetInfo = new AliCloud.RocketMQ.Inputs.RocketMQInstanceNetworkInfoInternetInfoArgs
 *             {
 *                 InternetSpec = "enable",
 *                 FlowOutType = "payByBandwidth",
 *                 FlowOutBandwidth = 30,
 *             },
 *         },
 *         Period = 1,
 *         SubSeriesCode = "cluster_ha",
 *         Remark = "example",
 *         InstanceName = name,
 *         ServiceCode = "rmq",
 *         SeriesCode = "professional",
 *         PaymentType = "PayAsYouGo",
 *         PeriodUnit = "Month",
 *     });
 *     var defaultRocketMQTopic = new AliCloud.RocketMQ.RocketMQTopic("default", new()
 *     {
 *         Remark = "example",
 *         InstanceId = createInstance.Id,
 *         MessageType = "NORMAL",
 *         TopicName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createVpc, err := vpc.NewNetwork(ctx, "createVpc", &vpc.NetworkArgs{
 * 			Description: pulumi.String("example"),
 * 			CidrBlock:   pulumi.String("172.16.0.0/12"),
 * 			VpcName:     pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createVswitch, err := vpc.NewSwitch(ctx, "createVswitch", &vpc.SwitchArgs{
 * 			Description: pulumi.String("example"),
 * 			VpcId:       createVpc.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createInstance, err := rocketmq.NewRocketMQInstance(ctx, "createInstance", &rocketmq.RocketMQInstanceArgs{
 * 			AutoRenewPeriod: pulumi.Int(1),
 * 			ProductInfo: &rocketmq.RocketMQInstanceProductInfoArgs{
 * 				MsgProcessSpec:       pulumi.String("rmq.p2.4xlarge"),
 * 				SendReceiveRatio:     pulumi.Float64(0.3),
 * 				MessageRetentionTime: pulumi.Int(70),
 * 			},
 * 			NetworkInfo: &rocketmq.RocketMQInstanceNetworkInfoArgs{
 * 				VpcInfo: &rocketmq.RocketMQInstanceNetworkInfoVpcInfoArgs{
 * 					VpcId:     createVpc.ID(),
 * 					VswitchId: createVswitch.ID(),
 * 				},
 * 				InternetInfo: &rocketmq.RocketMQInstanceNetworkInfoInternetInfoArgs{
 * 					InternetSpec:     pulumi.String("enable"),
 * 					FlowOutType:      pulumi.String("payByBandwidth"),
 * 					FlowOutBandwidth: pulumi.Int(30),
 * 				},
 * 			},
 * 			Period:        pulumi.Int(1),
 * 			SubSeriesCode: pulumi.String("cluster_ha"),
 * 			Remark:        pulumi.String("example"),
 * 			InstanceName:  pulumi.String(name),
 * 			ServiceCode:   pulumi.String("rmq"),
 * 			SeriesCode:    pulumi.String("professional"),
 * 			PaymentType:   pulumi.String("PayAsYouGo"),
 * 			PeriodUnit:    pulumi.String("Month"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rocketmq.NewRocketMQTopic(ctx, "default", &rocketmq.RocketMQTopicArgs{
 * 			Remark:      pulumi.String("example"),
 * 			InstanceId:  createInstance.ID(),
 * 			MessageType: pulumi.String("NORMAL"),
 * 			TopicName:   pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.rocketmq.RocketMQInstance;
 * import com.pulumi.alicloud.rocketmq.RocketMQInstanceArgs;
 * import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceProductInfoArgs;
 * import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoArgs;
 * import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoVpcInfoArgs;
 * import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoInternetInfoArgs;
 * import com.pulumi.alicloud.rocketmq.RocketMQTopic;
 * import com.pulumi.alicloud.rocketmq.RocketMQTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var createVpc = new Network("createVpc", NetworkArgs.builder()
 *             .description("example")
 *             .cidrBlock("172.16.0.0/12")
 *             .vpcName(name)
 *             .build());
 *         var createVswitch = new Switch("createVswitch", SwitchArgs.builder()
 *             .description("example")
 *             .vpcId(createVpc.id())
 *             .zoneId(default_.zones()[0].id())
 *             .cidrBlock("172.16.0.0/24")
 *             .vswitchName(name)
 *             .build());
 *         var createInstance = new RocketMQInstance("createInstance", RocketMQInstanceArgs.builder()
 *             .autoRenewPeriod("1")
 *             .productInfo(RocketMQInstanceProductInfoArgs.builder()
 *                 .msgProcessSpec("rmq.p2.4xlarge")
 *                 .sendReceiveRatio(0.3)
 *                 .messageRetentionTime("70")
 *                 .build())
 *             .networkInfo(RocketMQInstanceNetworkInfoArgs.builder()
 *                 .vpcInfo(RocketMQInstanceNetworkInfoVpcInfoArgs.builder()
 *                     .vpcId(createVpc.id())
 *                     .vswitchId(createVswitch.id())
 *                     .build())
 *                 .internetInfo(RocketMQInstanceNetworkInfoInternetInfoArgs.builder()
 *                     .internetSpec("enable")
 *                     .flowOutType("payByBandwidth")
 *                     .flowOutBandwidth("30")
 *                     .build())
 *                 .build())
 *             .period("1")
 *             .subSeriesCode("cluster_ha")
 *             .remark("example")
 *             .instanceName(name)
 *             .serviceCode("rmq")
 *             .seriesCode("professional")
 *             .paymentType("PayAsYouGo")
 *             .periodUnit("Month")
 *             .build());
 *         var defaultRocketMQTopic = new RocketMQTopic("defaultRocketMQTopic", RocketMQTopicArgs.builder()
 *             .remark("example")
 *             .instanceId(createInstance.id())
 *             .messageType("NORMAL")
 *             .topicName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   createVpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       description: example
 *       cidrBlock: 172.16.0.0/12
 *       vpcName: ${name}
 *   createVswitch:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       description: example
 *       vpcId: ${createVpc.id}
 *       zoneId: ${default.zones[0].id}
 *       cidrBlock: 172.16.0.0/24
 *       vswitchName: ${name}
 *   createInstance:
 *     type: alicloud:rocketmq:RocketMQInstance
 *     properties:
 *       autoRenewPeriod: '1'
 *       productInfo:
 *         msgProcessSpec: rmq.p2.4xlarge
 *         sendReceiveRatio: 0.3
 *         messageRetentionTime: '70'
 *       networkInfo:
 *         vpcInfo:
 *           vpcId: ${createVpc.id}
 *           vswitchId: ${createVswitch.id}
 *         internetInfo:
 *           internetSpec: enable
 *           flowOutType: payByBandwidth
 *           flowOutBandwidth: '30'
 *       period: '1'
 *       subSeriesCode: cluster_ha
 *       remark: example
 *       instanceName: ${name}
 *       serviceCode: rmq
 *       seriesCode: professional
 *       paymentType: PayAsYouGo
 *       periodUnit: Month
 *   defaultRocketMQTopic:
 *     type: alicloud:rocketmq:RocketMQTopic
 *     name: default
 *     properties:
 *       remark: example
 *       instanceId: ${createInstance.id}
 *       messageType: NORMAL
 *       topicName: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RocketMQ Topic can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/rocketMQTopic:RocketMQTopic example <instance_id>:<topic_name>
 * ```
 * @property instanceId Instance ID.
 * @property messageType Message type.
 * @property remark Custom remarks.
 * @property topicName Topic name and identification.
 */
public data class RocketMQTopicArgs(
    public val instanceId: Output<String>? = null,
    public val messageType: Output<String>? = null,
    public val remark: Output<String>? = null,
    public val topicName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.RocketMQTopicArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.RocketMQTopicArgs =
        com.pulumi.alicloud.rocketmq.RocketMQTopicArgs.builder()
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .messageType(messageType?.applyValue({ args0 -> args0 }))
            .remark(remark?.applyValue({ args0 -> args0 }))
            .topicName(topicName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RocketMQTopicArgs].
 */
@PulumiTagMarker
public class RocketMQTopicArgsBuilder internal constructor() {
    private var instanceId: Output<String>? = null

    private var messageType: Output<String>? = null

    private var remark: Output<String>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value Instance ID.
     */
    @JvmName("jelrnmhlajuogdpy")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Message type.
     */
    @JvmName("jyagunbbmvcikoqs")
    public suspend fun messageType(`value`: Output<String>) {
        this.messageType = value
    }

    /**
     * @param value Custom remarks.
     */
    @JvmName("qfsmqlmiqfydqbqm")
    public suspend fun remark(`value`: Output<String>) {
        this.remark = value
    }

    /**
     * @param value Topic name and identification.
     */
    @JvmName("gxnlylqhygocelyn")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value Instance ID.
     */
    @JvmName("wltsvhetbxiejwde")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Message type.
     */
    @JvmName("ifqvqhkslfxfekxy")
    public suspend fun messageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageType = mapped
    }

    /**
     * @param value Custom remarks.
     */
    @JvmName("eyjoidsqumhdyywa")
    public suspend fun remark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remark = mapped
    }

    /**
     * @param value Topic name and identification.
     */
    @JvmName("bdcwaryxyhcummtm")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): RocketMQTopicArgs = RocketMQTopicArgs(
        instanceId = instanceId,
        messageType = messageType,
        remark = remark,
        topicName = topicName,
    )
}
