@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.RocketmqFunctions.getGroupsPlain
import com.pulumi.alicloud.rocketmq.RocketmqFunctions.getInstancesPlain
import com.pulumi.alicloud.rocketmq.RocketmqFunctions.getServicePlain
import com.pulumi.alicloud.rocketmq.RocketmqFunctions.getTopicsPlain
import com.pulumi.alicloud.rocketmq.kotlin.inputs.GetGroupsPlainArgs
import com.pulumi.alicloud.rocketmq.kotlin.inputs.GetGroupsPlainArgsBuilder
import com.pulumi.alicloud.rocketmq.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.rocketmq.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.rocketmq.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.rocketmq.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.rocketmq.kotlin.inputs.GetTopicsPlainArgs
import com.pulumi.alicloud.rocketmq.kotlin.inputs.GetTopicsPlainArgsBuilder
import com.pulumi.alicloud.rocketmq.kotlin.outputs.GetGroupsResult
import com.pulumi.alicloud.rocketmq.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.rocketmq.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.rocketmq.kotlin.outputs.GetTopicsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.rocketmq.kotlin.outputs.GetGroupsResult.Companion.toKotlin as getGroupsResultToKotlin
import com.pulumi.alicloud.rocketmq.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.rocketmq.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.rocketmq.kotlin.outputs.GetTopicsResult.Companion.toKotlin as getTopicsResultToKotlin

public object RocketmqFunctions {
    /**
     * This data source provides a list of ONS Groups in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.53.0+
     * ## Example Usage
     * ```terraform
     * variable "name" {
     *   default = "onsInstanceName"
     * }
     * variable "group_name" {
     *   default = "GID-onsGroupDatasourceName"
     * }
     * resource "alicloud_ons_instance" "default" {
     *   instance_name = var.name
     *   remark        = "default_ons_instance_remark"
     * }
     * resource "alicloud_ons_group" "default" {
     *   group_name  = var.group_name
     *   instance_id = alicloud_ons_instance.default.id
     *   remark      = "dafault_ons_group_remark"
     * }
     * data "alicloud_ons_groups" "groups_ds" {
     *   instance_id = alicloud_ons_group.default.instance_id
     *   name_regex  = var.group_id
     *   output_file = "groups.txt"
     * }
     * output "first_group_name" {
     *   value = data.alicloud_ons_groups.groups_ds.groups.0.group_name
     * }
     * ```
     * @param argument A collection of arguments for invoking getGroups.
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: GetGroupsPlainArgs): GetGroupsResult =
        getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())

    /**
     * @see [getGroups].
     * @param groupIdRegex A regex string to filter results by the group name.
     * @param groupType Specify the protocol applicable to the created Group ID. Valid values: `tcp`, `http`. Default to `tcp`.
     * @param ids A list of group names.
     * @param instanceId ID of the ONS Instance that owns the groups.
     * @param nameRegex
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param tags A map of tags assigned to the Ons instance.
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(
        groupIdRegex: String? = null,
        groupType: String? = null,
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetGroupsResult {
        val argument = GetGroupsPlainArgs(
            groupIdRegex = groupIdRegex,
            groupType = groupType,
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tags = tags,
        )
        return getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rocketmq&#46;kotlin&#46;inputs&#46;GetGroupsPlainArgs].
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: suspend GetGroupsPlainArgsBuilder.() -> Unit): GetGroupsResult {
        val builder = GetGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupsResultToKotlin(getGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of ONS Instances in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.52.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "onsInstanceDatasourceName";
     * const _default = new alicloud.rocketmq.Instance("default", {
     *     name: name,
     *     remark: "default_ons_instance_remark",
     * });
     * const instancesDs = alicloud.rocketmq.getInstancesOutput({
     *     ids: [_default&#46;id],
     *     nameRegex: _default.name,
     *     outputFile: "instances.txt",
     * });
     * export const firstInstanceId = instancesDs.apply(instancesDs => instancesDs.instances?.[0]?.instanceId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "onsInstanceDatasourceName"
     * default = alicloud.rocketmq.Instance("default",
     *     name=name,
     *     remark="default_ons_instance_remark")
     * instances_ds = alicloud.rocketmq.get_instances_output(ids=[default&#46;id],
     *     name_regex=default.name,
     *     output_file="instances.txt")
     * pulumi.export("firstInstanceId", instances_ds.instances[0].instance_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "onsInstanceDatasourceName";
     *     var @default = new AliCloud.RocketMQ.Instance("default", new()
     *     {
     *         Name = name,
     *         Remark = "default_ons_instance_remark",
     *     });
     *     var instancesDs = AliCloud.RocketMQ.GetInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             @default.Id,
     *         },
     *         NameRegex = @default.Name,
     *         OutputFile = "instances.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstInstanceId"] = instancesDs&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.InstanceId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "onsInstanceDatasourceName"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_, err := rocketmq.NewInstance(ctx, "default", &rocketmq.InstanceArgs{
     * 			Name:   pulumi.String(name),
     * 			Remark: pulumi.String("default_ons_instance_remark"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		instancesDs := rocketmq.GetInstancesOutput(ctx, rocketmq.GetInstancesOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				_default.ID(),
     * 			},
     * 			NameRegex:  _default.Name,
     * 			OutputFile: pulumi.String("instances.txt"),
     * 		}, nil)
     * 		ctx.Export("firstInstanceId", instancesDs.ApplyT(func(instancesDs rocketmq.GetInstancesResult) (*string, error) {
     * 			return &instancesDs.Instances[0].InstanceId, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rocketmq.Instance;
     * import com.pulumi.alicloud.rocketmq.InstanceArgs;
     * import com.pulumi.alicloud.rocketmq.RocketmqFunctions;
     * import com.pulumi.alicloud.rocketmq.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("onsInstanceDatasourceName");
     *         var default_ = new Instance("default", InstanceArgs.builder()
     *             .name(name)
     *             .remark("default_ons_instance_remark")
     *             .build());
     *         final var instancesDs = RocketmqFunctions.getInstances(GetInstancesArgs.builder()
     *             .ids(default_.id())
     *             .nameRegex(default_.name())
     *             .outputFile("instances.txt")
     *             .build());
     *         ctx.export("firstInstanceId", instancesDs.applyValue(getInstancesResult -> getInstancesResult).applyValue(instancesDs -> instancesDs.applyValue(getInstancesResult -> getInstancesResult.instances()[0].instanceId())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: onsInstanceDatasourceName
     * resources:
     *   default:
     *     type: alicloud:rocketmq:Instance
     *     properties:
     *       name: ${name}
     *       remark: default_ons_instance_remark
     * variables:
     *   instancesDs:
     *     fn::invoke:
     *       Function: alicloud:rocketmq:getInstances
     *       Arguments:
     *         ids:
     *           - ${default.id}
     *         nameRegex: ${default.name}
     *         outputFile: instances.txt
     * outputs:
     *   firstInstanceId: ${instancesDs.instances[0].instanceId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param enableDetails Default to `false`. Set it to true can output more details.
     * @param ids A list of instance IDs to filter results.
     * @param nameRegex A regex string to filter results by the instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of Ons instance. Valid values: `0` deploying, `2` arrears, `5` running, `7` upgrading.
     * @param tags A map of tags assigned to the Ons instance.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: Int? = null,
        tags: Map<String, String>? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            tags = tags,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rocketmq&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open ONS service automatically. If the service has been opened, it will return opened.
     * For information about ONS and how to use it, see [What is ONS](https://help.aliyun.com/product/29530.html).
     * > **NOTE:** Available in v1.111.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.rocketmq.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.rocketmq.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.RocketMQ.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rocketmq.GetService(ctx, &rocketmq.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rocketmq.RocketmqFunctions;
     * import com.pulumi.alicloud.rocketmq.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = RocketmqFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:rocketmq:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the ONS service that means you have read and agreed the [ONS Terms of Service](https://help.aliyun.com/document_detail/39113.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rocketmq&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of ONS Topics in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.53.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "onsInstanceName";
     * const topic = config.get("topic") || "onsTopicDatasourceName";
     * const _default = new alicloud.rocketmq.Instance("default", {
     *     instanceName: name,
     *     remark: "default_ons_instance_remark",
     * });
     * const defaultTopic = new alicloud.rocketmq.Topic("default", {
     *     topicName: topic,
     *     instanceId: _default.id,
     *     messageType: 0,
     *     remark: "dafault_ons_topic_remark",
     * });
     * const topicsDs = alicloud.rocketmq.getTopicsOutput({
     *     instanceId: defaultTopic.instanceId,
     *     nameRegex: topic,
     *     outputFile: "topics.txt",
     * });
     * export const firstTopicName = topicsDs.apply(topicsDs => topicsDs.topics?.[0]?.topicName);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "onsInstanceName"
     * topic = config.get("topic")
     * if topic is None:
     *     topic = "onsTopicDatasourceName"
     * default = alicloud.rocketmq.Instance("default",
     *     instance_name=name,
     *     remark="default_ons_instance_remark")
     * default_topic = alicloud.rocketmq.Topic("default",
     *     topic_name=topic,
     *     instance_id=default.id,
     *     message_type=0,
     *     remark="dafault_ons_topic_remark")
     * topics_ds = alicloud.rocketmq.get_topics_output(instance_id=default_topic.instance_id,
     *     name_regex=topic,
     *     output_file="topics.txt")
     * pulumi.export("firstTopicName", topics_ds.topics[0].topic_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "onsInstanceName";
     *     var topic = config.Get("topic") ?? "onsTopicDatasourceName";
     *     var @default = new AliCloud.RocketMQ.Instance("default", new()
     *     {
     *         InstanceName = name,
     *         Remark = "default_ons_instance_remark",
     *     });
     *     var defaultTopic = new AliCloud.RocketMQ.Topic("default", new()
     *     {
     *         TopicName = topic,
     *         InstanceId = @default.Id,
     *         MessageType = 0,
     *         Remark = "dafault_ons_topic_remark",
     *     });
     *     var topicsDs = AliCloud.RocketMQ.GetTopics.Invoke(new()
     *     {
     *         InstanceId = defaultTopic.InstanceId,
     *         NameRegex = topic,
     *         OutputFile = "topics.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstTopicName"] = topicsDs&#46;Apply(getTopicsResult => getTopicsResult&#46;Topics[0]?.TopicName),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "onsInstanceName"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		topic := "onsTopicDatasourceName"
     * 		if param := cfg.Get("topic"); param != "" {
     * 			topic = param
     * 		}
     * 		_, err := rocketmq.NewInstance(ctx, "default", &rocketmq.InstanceArgs{
     * 			InstanceName: pulumi.String(name),
     * 			Remark:       pulumi.String("default_ons_instance_remark"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultTopic, err := rocketmq.NewTopic(ctx, "default", &rocketmq.TopicArgs{
     * 			TopicName:   pulumi.String(topic),
     * 			InstanceId:  _default.ID(),
     * 			MessageType: pulumi.Int(0),
     * 			Remark:      pulumi.String("dafault_ons_topic_remark"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		topicsDs := rocketmq.GetTopicsOutput(ctx, rocketmq.GetTopicsOutputArgs{
     * 			InstanceId: defaultTopic.InstanceId,
     * 			NameRegex:  pulumi.String(topic),
     * 			OutputFile: pulumi.String("topics.txt"),
     * 		}, nil)
     * 		ctx.Export("firstTopicName", topicsDs.ApplyT(func(topicsDs rocketmq.GetTopicsResult) (*string, error) {
     * 			return &topicsDs.Topics[0].TopicName, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.rocketmq.Instance;
     * import com.pulumi.alicloud.rocketmq.InstanceArgs;
     * import com.pulumi.alicloud.rocketmq.Topic;
     * import com.pulumi.alicloud.rocketmq.TopicArgs;
     * import com.pulumi.alicloud.rocketmq.RocketmqFunctions;
     * import com.pulumi.alicloud.rocketmq.inputs.GetTopicsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("onsInstanceName");
     *         final var topic = config.get("topic").orElse("onsTopicDatasourceName");
     *         var default_ = new Instance("default", InstanceArgs.builder()
     *             .instanceName(name)
     *             .remark("default_ons_instance_remark")
     *             .build());
     *         var defaultTopic = new Topic("defaultTopic", TopicArgs.builder()
     *             .topicName(topic)
     *             .instanceId(default_.id())
     *             .messageType(0)
     *             .remark("dafault_ons_topic_remark")
     *             .build());
     *         final var topicsDs = RocketmqFunctions.getTopics(GetTopicsArgs.builder()
     *             .instanceId(defaultTopic.instanceId())
     *             .nameRegex(topic)
     *             .outputFile("topics.txt")
     *             .build());
     *         ctx.export("firstTopicName", topicsDs.applyValue(getTopicsResult -> getTopicsResult).applyValue(topicsDs -> topicsDs.applyValue(getTopicsResult -> getTopicsResult.topics()[0].topicName())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: onsInstanceName
     *   topic:
     *     type: string
     *     default: onsTopicDatasourceName
     * resources:
     *   default:
     *     type: alicloud:rocketmq:Instance
     *     properties:
     *       instanceName: ${name}
     *       remark: default_ons_instance_remark
     *   defaultTopic:
     *     type: alicloud:rocketmq:Topic
     *     name: default
     *     properties:
     *       topicName: ${topic}
     *       instanceId: ${default.id}
     *       messageType: 0
     *       remark: dafault_ons_topic_remark
     * variables:
     *   topicsDs:
     *     fn::invoke:
     *       Function: alicloud:rocketmq:getTopics
     *       Arguments:
     *         instanceId: ${defaultTopic.instanceId}
     *         nameRegex: ${topic}
     *         outputFile: topics.txt
     * outputs:
     *   firstTopicName: ${topicsDs.topics[0].topicName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTopics.
     * @return A collection of values returned by getTopics.
     */
    public suspend fun getTopics(argument: GetTopicsPlainArgs): GetTopicsResult =
        getTopicsResultToKotlin(getTopicsPlain(argument.toJava()).await())

    /**
     * @see [getTopics].
     * @param enableDetails
     * @param ids A list of topic IDs to filter results.
     * @param instanceId ID of the ONS Instance that owns the topics.
     * @param nameRegex A regex string to filter results by the topic name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param tags A map of tags assigned to the Ons instance.
     * @return A collection of values returned by getTopics.
     */
    public suspend fun getTopics(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetTopicsResult {
        val argument = GetTopicsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tags = tags,
        )
        return getTopicsResultToKotlin(getTopicsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTopics].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;rocketmq&#46;kotlin&#46;inputs&#46;GetTopicsPlainArgs].
     * @return A collection of values returned by getTopics.
     */
    public suspend fun getTopics(argument: suspend GetTopicsPlainArgsBuilder.() -> Unit): GetTopicsResult {
        val builder = GetTopicsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTopicsResultToKotlin(getTopicsPlain(builtArgument.toJava()).await())
    }
}
