@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SnatEntry].
 */
@PulumiTagMarker
public class SnatEntryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnatEntryArgs = SnatEntryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnatEntryArgsBuilder.() -> Unit) {
        val builder = SnatEntryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SnatEntry {
        val builtJavaResource = com.pulumi.alicloud.rocketmq.SnatEntry(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SnatEntry(builtJavaResource)
    }
}

/**
 * Provides a Sag SnatEntry resource. This topic describes how to add a SNAT entry to enable the SNAT function. The SNAT function can hide internal IP addresses and resolve private IP address conflicts. With this function, on-premises sites can access internal IP addresses, but cannot be accessed by internal IP addresses. If you do not add a SNAT entry, on-premises sites can access each other only when all related IP addresses do not conflict.
 * For information about Sag SnatEntry and how to use it, see [What is Sag SnatEntry](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/addsnatentry).
 * > **NOTE:** Available since v1.61.0.
 * > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const sagId = config.get("sagId") || "sag-9bifk***";
 * const _default = new alicloud.rocketmq.SnatEntry("default", {
 *     sagId: sagId,
 *     cidrBlock: "192.168.7.0/24",
 *     snatIp: "192.0.0.2",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * sag_id = config.get("sagId")
 * if sag_id is None:
 *     sag_id = "sag-9bifk***"
 * default = alicloud.rocketmq.SnatEntry("default",
 *     sag_id=sag_id,
 *     cidr_block="192.168.7.0/24",
 *     snat_ip="192.0.0.2")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var sagId = config.Get("sagId") ?? "sag-9bifk***";
 *     var @default = new AliCloud.RocketMQ.SnatEntry("default", new()
 *     {
 *         SagId = sagId,
 *         CidrBlock = "192.168.7.0/24",
 *         SnatIp = "192.0.0.2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		sagId := "sag-9bifk***"
 * 		if param := cfg.Get("sagId"); param != "" {
 * 			sagId = param
 * 		}
 * 		_, err := rocketmq.NewSnatEntry(ctx, "default", &rocketmq.SnatEntryArgs{
 * 			SagId:     pulumi.String(sagId),
 * 			CidrBlock: pulumi.String("192.168.7.0/24"),
 * 			SnatIp:    pulumi.String("192.0.0.2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rocketmq.SnatEntry;
 * import com.pulumi.alicloud.rocketmq.SnatEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var sagId = config.get("sagId").orElse("sag-9bifk***");
 *         var default_ = new SnatEntry("default", SnatEntryArgs.builder()
 *             .sagId(sagId)
 *             .cidrBlock("192.168.7.0/24")
 *             .snatIp("192.0.0.2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   sagId:
 *     type: string
 *     default: sag-9bifk***
 * resources:
 *   default:
 *     type: alicloud:rocketmq:SnatEntry
 *     properties:
 *       sagId: ${sagId}
 *       cidrBlock: 192.168.7.0/24
 *       snatIp: 192.0.0.2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Sag SnatEntry can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/snatEntry:SnatEntry example sag-abc123456:snat-abc123456
 * ```
 */
public class SnatEntry internal constructor(
    override val javaResource: com.pulumi.alicloud.rocketmq.SnatEntry,
) : KotlinCustomResource(javaResource, SnatEntryMapper) {
    /**
     * The destination CIDR block.
     */
    public val cidrBlock: Output<String>
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0 })

    /**
     * The ID of the SAG instance.
     */
    public val sagId: Output<String>
        get() = javaResource.sagId().applyValue({ args0 -> args0 })

    /**
     * The public IP address.
     */
    public val snatIp: Output<String>
        get() = javaResource.snatIp().applyValue({ args0 -> args0 })
}

public object SnatEntryMapper : ResourceMapper<SnatEntry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.rocketmq.SnatEntry::class == javaResource::class

    override fun map(javaResource: Resource): SnatEntry = SnatEntry(
        javaResource as
            com.pulumi.alicloud.rocketmq.SnatEntry,
    )
}

/**
 * @see [SnatEntry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SnatEntry].
 */
public suspend fun snatEntry(name: String, block: suspend SnatEntryResourceBuilder.() -> Unit): SnatEntry {
    val builder = SnatEntryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SnatEntry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snatEntry(name: String): SnatEntry {
    val builder = SnatEntryResourceBuilder()
    builder.name(name)
    return builder.build()
}
