@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.SnatEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Sag SnatEntry resource. This topic describes how to add a SNAT entry to enable the SNAT function. The SNAT function can hide internal IP addresses and resolve private IP address conflicts. With this function, on-premises sites can access internal IP addresses, but cannot be accessed by internal IP addresses. If you do not add a SNAT entry, on-premises sites can access each other only when all related IP addresses do not conflict.
 * For information about Sag SnatEntry and how to use it, see [What is Sag SnatEntry](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/addsnatentry).
 * > **NOTE:** Available since v1.61.0.
 * > **NOTE:** Only the following regions support. [`cn-shanghai`, `cn-shanghai-finance-1`, `cn-hongkong`, `ap-southeast-1`, `ap-southeast-3`, `ap-southeast-5`, `ap-northeast-1`, `eu-central-1`]
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const sagId = config.get("sagId") || "sag-9bifk***";
 * const _default = new alicloud.rocketmq.SnatEntry("default", {
 *     sagId: sagId,
 *     cidrBlock: "192.168.7.0/24",
 *     snatIp: "192.0.0.2",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * sag_id = config.get("sagId")
 * if sag_id is None:
 *     sag_id = "sag-9bifk***"
 * default = alicloud.rocketmq.SnatEntry("default",
 *     sag_id=sag_id,
 *     cidr_block="192.168.7.0/24",
 *     snat_ip="192.0.0.2")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var sagId = config.Get("sagId") ?? "sag-9bifk***";
 *     var @default = new AliCloud.RocketMQ.SnatEntry("default", new()
 *     {
 *         SagId = sagId,
 *         CidrBlock = "192.168.7.0/24",
 *         SnatIp = "192.0.0.2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		sagId := "sag-9bifk***"
 * 		if param := cfg.Get("sagId"); param != "" {
 * 			sagId = param
 * 		}
 * 		_, err := rocketmq.NewSnatEntry(ctx, "default", &rocketmq.SnatEntryArgs{
 * 			SagId:     pulumi.String(sagId),
 * 			CidrBlock: pulumi.String("192.168.7.0/24"),
 * 			SnatIp:    pulumi.String("192.0.0.2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.rocketmq.SnatEntry;
 * import com.pulumi.alicloud.rocketmq.SnatEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var sagId = config.get("sagId").orElse("sag-9bifk***");
 *         var default_ = new SnatEntry("default", SnatEntryArgs.builder()
 *             .sagId(sagId)
 *             .cidrBlock("192.168.7.0/24")
 *             .snatIp("192.0.0.2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   sagId:
 *     type: string
 *     default: sag-9bifk***
 * resources:
 *   default:
 *     type: alicloud:rocketmq:SnatEntry
 *     properties:
 *       sagId: ${sagId}
 *       cidrBlock: 192.168.7.0/24
 *       snatIp: 192.0.0.2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The Sag SnatEntry can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/snatEntry:SnatEntry example sag-abc123456:snat-abc123456
 * ```
 * @property cidrBlock The destination CIDR block.
 * @property sagId The ID of the SAG instance.
 * @property snatIp The public IP address.
 */
public data class SnatEntryArgs(
    public val cidrBlock: Output<String>? = null,
    public val sagId: Output<String>? = null,
    public val snatIp: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.SnatEntryArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.SnatEntryArgs =
        com.pulumi.alicloud.rocketmq.SnatEntryArgs.builder()
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .sagId(sagId?.applyValue({ args0 -> args0 }))
            .snatIp(snatIp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnatEntryArgs].
 */
@PulumiTagMarker
public class SnatEntryArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var sagId: Output<String>? = null

    private var snatIp: Output<String>? = null

    /**
     * @param value The destination CIDR block.
     */
    @JvmName("cfanrbfpxlvvfdds")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value The ID of the SAG instance.
     */
    @JvmName("tdbrpjohwnmgogqc")
    public suspend fun sagId(`value`: Output<String>) {
        this.sagId = value
    }

    /**
     * @param value The public IP address.
     */
    @JvmName("ewnedxnimmclganv")
    public suspend fun snatIp(`value`: Output<String>) {
        this.snatIp = value
    }

    /**
     * @param value The destination CIDR block.
     */
    @JvmName("dswklvxumvrbhequ")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value The ID of the SAG instance.
     */
    @JvmName("vpupyedbhfjonnnl")
    public suspend fun sagId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagId = mapped
    }

    /**
     * @param value The public IP address.
     */
    @JvmName("preshqnxeelbolxv")
    public suspend fun snatIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snatIp = mapped
    }

    internal fun build(): SnatEntryArgs = SnatEntryArgs(
        cidrBlock = cidrBlock,
        sagId = sagId,
        snatIp = snatIp,
    )
}
