@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin

import com.pulumi.alicloud.rocketmq.TopicArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ONS topic resource.
 * For more information about how to use it, see [RocketMQ Topic Management API](https://www.alibabacloud.com/help/doc-detail/29591.html).
 * > **NOTE:** Available in 1.53.0+
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "onsInstanceName";
 * const topic = config.get("topic") || "onsTopicName";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultInstance = new alicloud.rocketmq.Instance("default", {
 *     name: `${name}-${_default.result}`,
 *     remark: "default_ons_instance_remark",
 * });
 * const defaultTopic = new alicloud.rocketmq.Topic("default", {
 *     topicName: topic,
 *     instanceId: defaultInstance.id,
 *     messageType: 0,
 *     remark: "dafault_ons_topic_remark",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "onsInstanceName"
 * topic = config.get("topic")
 * if topic is None:
 *     topic = "onsTopicName"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_instance = alicloud.rocketmq.Instance("default",
 *     name=f"{name}-{default['result']}",
 *     remark="default_ons_instance_remark")
 * default_topic = alicloud.rocketmq.Topic("default",
 *     topic_name=topic,
 *     instance_id=default_instance.id,
 *     message_type=0,
 *     remark="dafault_ons_topic_remark")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "onsInstanceName";
 *     var topic = config.Get("topic") ?? "onsTopicName";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultInstance = new AliCloud.RocketMQ.Instance("default", new()
 *     {
 *         Name = $"{name}-{@default.Result}",
 *         Remark = "default_ons_instance_remark",
 *     });
 *     var defaultTopic = new AliCloud.RocketMQ.Topic("default", new()
 *     {
 *         TopicName = topic,
 *         InstanceId = defaultInstance.Id,
 *         MessageType = 0,
 *         Remark = "dafault_ons_topic_remark",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/rocketmq"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "onsInstanceName"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		topic := "onsTopicName"
 * 		if param := cfg.Get("topic"); param != "" {
 * 			topic = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := rocketmq.NewInstance(ctx, "default", &rocketmq.InstanceArgs{
 * 			Name:   pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Remark: pulumi.String("default_ons_instance_remark"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rocketmq.NewTopic(ctx, "default", &rocketmq.TopicArgs{
 * 			TopicName:   pulumi.String(topic),
 * 			InstanceId:  defaultInstance.ID(),
 * 			MessageType: pulumi.Int(0),
 * 			Remark:      pulumi.String("dafault_ons_topic_remark"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.rocketmq.Instance;
 * import com.pulumi.alicloud.rocketmq.InstanceArgs;
 * import com.pulumi.alicloud.rocketmq.Topic;
 * import com.pulumi.alicloud.rocketmq.TopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("onsInstanceName");
 *         final var topic = config.get("topic").orElse("onsTopicName");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .name(String.format("%s-%s", name,default_.result()))
 *             .remark("default_ons_instance_remark")
 *             .build());
 *         var defaultTopic = new Topic("defaultTopic", TopicArgs.builder()
 *             .topicName(topic)
 *             .instanceId(defaultInstance.id())
 *             .messageType(0)
 *             .remark("dafault_ons_topic_remark")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: onsInstanceName
 *   topic:
 *     type: string
 *     default: onsTopicName
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultInstance:
 *     type: alicloud:rocketmq:Instance
 *     name: default
 *     properties:
 *       name: ${name}-${default.result}
 *       remark: default_ons_instance_remark
 *   defaultTopic:
 *     type: alicloud:rocketmq:Topic
 *     name: default
 *     properties:
 *       topicName: ${topic}
 *       instanceId: ${defaultInstance.id}
 *       messageType: 0
 *       remark: dafault_ons_topic_remark
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ONS TOPIC can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:rocketmq/topic:Topic topic MQ_INST_1234567890_Baso1234567:onsTopicDemo
 * ```
 * @property instanceId ID of the ONS Instance that owns the topics.
 * @property messageType The type of the message. Read [Ons Topic Create](https://www.alibabacloud.com/help/doc-detail/29591.html) for further details.
 * @property perm This attribute has been deprecated.
 * @property remark This attribute is a concise description of topic. The length cannot exceed 128.
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * > **NOTE:** At least one of `topic_name` and `topic` should be set.
 * @property topic Replaced by `topic_name` after version 1.97.0.
 * @property topicName Name of the topic. Two topics on a single instance cannot have the same name and the name cannot start with 'GID' or 'CID'. The length cannot exceed 64 characters.
 */
public data class TopicArgs(
    public val instanceId: Output<String>? = null,
    public val messageType: Output<Int>? = null,
    @Deprecated(
        message = """
  Attribute perm has been deprecated and suggest removing it from your template.
  """,
    )
    public val perm: Output<Int>? = null,
    public val remark: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    @Deprecated(
        message = """
  Field 'topic' has been deprecated from version 1.97.0. Use 'topic_name' instead.
  """,
    )
    public val topic: Output<String>? = null,
    public val topicName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.TopicArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.TopicArgs =
        com.pulumi.alicloud.rocketmq.TopicArgs.builder()
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .messageType(messageType?.applyValue({ args0 -> args0 }))
            .perm(perm?.applyValue({ args0 -> args0 }))
            .remark(remark?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topic(topic?.applyValue({ args0 -> args0 }))
            .topicName(topicName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicArgs].
 */
@PulumiTagMarker
public class TopicArgsBuilder internal constructor() {
    private var instanceId: Output<String>? = null

    private var messageType: Output<Int>? = null

    private var perm: Output<Int>? = null

    private var remark: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topic: Output<String>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value ID of the ONS Instance that owns the topics.
     */
    @JvmName("kuotlafitgiuaqgb")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The type of the message. Read [Ons Topic Create](https://www.alibabacloud.com/help/doc-detail/29591.html) for further details.
     */
    @JvmName("qjembidlconsotnc")
    public suspend fun messageType(`value`: Output<Int>) {
        this.messageType = value
    }

    /**
     * @param value This attribute has been deprecated.
     */
    @Deprecated(
        message = """
  Attribute perm has been deprecated and suggest removing it from your template.
  """,
    )
    @JvmName("bnqliccnrawjdbix")
    public suspend fun perm(`value`: Output<Int>) {
        this.perm = value
    }

    /**
     * @param value This attribute is a concise description of topic. The length cannot exceed 128.
     */
    @JvmName("haguemtsolejkduq")
    public suspend fun remark(`value`: Output<String>) {
        this.remark = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * > **NOTE:** At least one of `topic_name` and `topic` should be set.
     */
    @JvmName("hpglfltsgfpqnrkl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Replaced by `topic_name` after version 1.97.0.
     */
    @Deprecated(
        message = """
  Field 'topic' has been deprecated from version 1.97.0. Use 'topic_name' instead.
  """,
    )
    @JvmName("asxjxkjbumkawqow")
    public suspend fun topic(`value`: Output<String>) {
        this.topic = value
    }

    /**
     * @param value Name of the topic. Two topics on a single instance cannot have the same name and the name cannot start with 'GID' or 'CID'. The length cannot exceed 64 characters.
     */
    @JvmName("iamdvngeyedfgwqb")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value ID of the ONS Instance that owns the topics.
     */
    @JvmName("ydmgvxtoajmmytxt")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The type of the message. Read [Ons Topic Create](https://www.alibabacloud.com/help/doc-detail/29591.html) for further details.
     */
    @JvmName("nxdslefigtwnbhil")
    public suspend fun messageType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageType = mapped
    }

    /**
     * @param value This attribute has been deprecated.
     */
    @Deprecated(
        message = """
  Attribute perm has been deprecated and suggest removing it from your template.
  """,
    )
    @JvmName("chnecaykwlohvqld")
    public suspend fun perm(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perm = mapped
    }

    /**
     * @param value This attribute is a concise description of topic. The length cannot exceed 128.
     */
    @JvmName("qoyvmjtonlxilkbw")
    public suspend fun remark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remark = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * > **NOTE:** At least one of `topic_name` and `topic` should be set.
     */
    @JvmName("jciosumilnardjun")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * > **NOTE:** At least one of `topic_name` and `topic` should be set.
     */
    @JvmName("jckyaxktoaspwjqj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Replaced by `topic_name` after version 1.97.0.
     */
    @Deprecated(
        message = """
  Field 'topic' has been deprecated from version 1.97.0. Use 'topic_name' instead.
  """,
    )
    @JvmName("kwwcslhvuqeroold")
    public suspend fun topic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    /**
     * @param value Name of the topic. Two topics on a single instance cannot have the same name and the name cannot start with 'GID' or 'CID'. The length cannot exceed 64 characters.
     */
    @JvmName("jjwwbxnbgmklyyre")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): TopicArgs = TopicArgs(
        instanceId = instanceId,
        messageType = messageType,
        perm = perm,
        remark = remark,
        tags = tags,
        topic = topic,
        topicName = topicName,
    )
}
