@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.inputs

import com.pulumi.alicloud.rocketmq.inputs.ConsumerGroupConsumeRetryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxRetryTimes Maximum number of retries.
 * @property retryPolicy Consume retry policy.
 */
public data class ConsumerGroupConsumeRetryPolicyArgs(
    public val maxRetryTimes: Output<Int>? = null,
    public val retryPolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.inputs.ConsumerGroupConsumeRetryPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.inputs.ConsumerGroupConsumeRetryPolicyArgs =
        com.pulumi.alicloud.rocketmq.inputs.ConsumerGroupConsumeRetryPolicyArgs.builder()
            .maxRetryTimes(maxRetryTimes?.applyValue({ args0 -> args0 }))
            .retryPolicy(retryPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConsumerGroupConsumeRetryPolicyArgs].
 */
@PulumiTagMarker
public class ConsumerGroupConsumeRetryPolicyArgsBuilder internal constructor() {
    private var maxRetryTimes: Output<Int>? = null

    private var retryPolicy: Output<String>? = null

    /**
     * @param value Maximum number of retries.
     */
    @JvmName("vvnfayusnobodgkq")
    public suspend fun maxRetryTimes(`value`: Output<Int>) {
        this.maxRetryTimes = value
    }

    /**
     * @param value Consume retry policy.
     */
    @JvmName("wgqmnasuuchdkrem")
    public suspend fun retryPolicy(`value`: Output<String>) {
        this.retryPolicy = value
    }

    /**
     * @param value Maximum number of retries.
     */
    @JvmName("osyxsqncrieftenw")
    public suspend fun maxRetryTimes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRetryTimes = mapped
    }

    /**
     * @param value Consume retry policy.
     */
    @JvmName("qmulosigvtbjkiep")
    public suspend fun retryPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryPolicy = mapped
    }

    internal fun build(): ConsumerGroupConsumeRetryPolicyArgs = ConsumerGroupConsumeRetryPolicyArgs(
        maxRetryTimes = maxRetryTimes,
        retryPolicy = retryPolicy,
    )
}
