@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.inputs

import com.pulumi.alicloud.rocketmq.inputs.GetGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroups.
 * @property groupIdRegex A regex string to filter results by the group name.
 * @property groupType Specify the protocol applicable to the created Group ID. Valid values: `tcp`, `http`. Default to `tcp`.
 * @property ids A list of group names.
 * @property instanceId ID of the ONS Instance that owns the groups.
 * @property nameRegex
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property tags A map of tags assigned to the Ons instance.
 */
public data class GetGroupsPlainArgs(
    public val groupIdRegex: String? = null,
    public val groupType: String? = null,
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.inputs.GetGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.inputs.GetGroupsPlainArgs =
        com.pulumi.alicloud.rocketmq.inputs.GetGroupsPlainArgs.builder()
            .groupIdRegex(groupIdRegex?.let({ args0 -> args0 }))
            .groupType(groupType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetGroupsPlainArgsBuilder internal constructor() {
    private var groupIdRegex: String? = null

    private var groupType: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value A regex string to filter results by the group name.
     */
    @JvmName("jcgxuxhmbctgfdvu")
    public suspend fun groupIdRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupIdRegex = mapped
    }

    /**
     * @param value Specify the protocol applicable to the created Group ID. Valid values: `tcp`, `http`. Default to `tcp`.
     */
    @JvmName("papdcnsjgllbxfgj")
    public suspend fun groupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupType = mapped
    }

    /**
     * @param value A list of group names.
     */
    @JvmName("poolhonkxiyjaffw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of group names.
     */
    @JvmName("sytyrvlgidobisdy")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value ID of the ONS Instance that owns the groups.
     */
    @JvmName("chvpuplxmxscmuvg")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("fmhlqvekgqqjefrg")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jmiphhcuhbisilmy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value A map of tags assigned to the Ons instance.
     */
    @JvmName("gxynujfdyaefvwox")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the Ons instance.
     */
    @JvmName("ylskdtmviflwujve")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetGroupsPlainArgs = GetGroupsPlainArgs(
        groupIdRegex = groupIdRegex,
        groupType = groupType,
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
        tags = tags,
    )
}
