@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.inputs

import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property endpoints Access point list.
 * @property internetInfo instance internet info. See `internet_info` below.
 * @property vpcInfo Proprietary network information. See `vpc_info` below.
 */
public data class RocketMQInstanceNetworkInfoArgs(
    public val endpoints: Output<List<RocketMQInstanceNetworkInfoEndpointArgs>>? = null,
    public val internetInfo: Output<RocketMQInstanceNetworkInfoInternetInfoArgs>,
    public val vpcInfo: Output<RocketMQInstanceNetworkInfoVpcInfoArgs>,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoArgs =
        com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoArgs.builder()
            .endpoints(
                endpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .internetInfo(internetInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpcInfo(vpcInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RocketMQInstanceNetworkInfoArgs].
 */
@PulumiTagMarker
public class RocketMQInstanceNetworkInfoArgsBuilder internal constructor() {
    private var endpoints: Output<List<RocketMQInstanceNetworkInfoEndpointArgs>>? = null

    private var internetInfo: Output<RocketMQInstanceNetworkInfoInternetInfoArgs>? = null

    private var vpcInfo: Output<RocketMQInstanceNetworkInfoVpcInfoArgs>? = null

    /**
     * @param value Access point list.
     */
    @JvmName("pstndkjyyhkgmsdy")
    public suspend fun endpoints(`value`: Output<List<RocketMQInstanceNetworkInfoEndpointArgs>>) {
        this.endpoints = value
    }

    @JvmName("avokfhovxgumjkxq")
    public suspend fun endpoints(vararg values: Output<RocketMQInstanceNetworkInfoEndpointArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values Access point list.
     */
    @JvmName("qhdfypfosfbeebqt")
    public suspend fun endpoints(values: List<Output<RocketMQInstanceNetworkInfoEndpointArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value instance internet info. See `internet_info` below.
     */
    @JvmName("ijcvspqmbmqtbjbr")
    public suspend fun internetInfo(`value`: Output<RocketMQInstanceNetworkInfoInternetInfoArgs>) {
        this.internetInfo = value
    }

    /**
     * @param value Proprietary network information. See `vpc_info` below.
     */
    @JvmName("smwvqmxhdbjagywk")
    public suspend fun vpcInfo(`value`: Output<RocketMQInstanceNetworkInfoVpcInfoArgs>) {
        this.vpcInfo = value
    }

    /**
     * @param value Access point list.
     */
    @JvmName("lieksiyjbmjmxofe")
    public suspend fun endpoints(`value`: List<RocketMQInstanceNetworkInfoEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument Access point list.
     */
    @JvmName("qokrnxshohjnuemi")
    public suspend fun endpoints(argument: List<suspend RocketMQInstanceNetworkInfoEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RocketMQInstanceNetworkInfoEndpointArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument Access point list.
     */
    @JvmName("mrbfgndbkwtadsod")
    public suspend fun endpoints(vararg argument: suspend RocketMQInstanceNetworkInfoEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RocketMQInstanceNetworkInfoEndpointArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument Access point list.
     */
    @JvmName("ltdpfvppwksldioj")
    public suspend fun endpoints(argument: suspend RocketMQInstanceNetworkInfoEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RocketMQInstanceNetworkInfoEndpointArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values Access point list.
     */
    @JvmName("itkhgrpcrkkyriov")
    public suspend fun endpoints(vararg values: RocketMQInstanceNetworkInfoEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param value instance internet info. See `internet_info` below.
     */
    @JvmName("gjgnumtymnqlfqam")
    public suspend fun internetInfo(`value`: RocketMQInstanceNetworkInfoInternetInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.internetInfo = mapped
    }

    /**
     * @param argument instance internet info. See `internet_info` below.
     */
    @JvmName("onywsrwlgvvimnbc")
    public suspend fun internetInfo(argument: suspend RocketMQInstanceNetworkInfoInternetInfoArgsBuilder.() -> Unit) {
        val toBeMapped = RocketMQInstanceNetworkInfoInternetInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.internetInfo = mapped
    }

    /**
     * @param value Proprietary network information. See `vpc_info` below.
     */
    @JvmName("ojcnilludhrxqves")
    public suspend fun vpcInfo(`value`: RocketMQInstanceNetworkInfoVpcInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcInfo = mapped
    }

    /**
     * @param argument Proprietary network information. See `vpc_info` below.
     */
    @JvmName("xloyfrmxdiapxssd")
    public suspend fun vpcInfo(argument: suspend RocketMQInstanceNetworkInfoVpcInfoArgsBuilder.() -> Unit) {
        val toBeMapped = RocketMQInstanceNetworkInfoVpcInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vpcInfo = mapped
    }

    internal fun build(): RocketMQInstanceNetworkInfoArgs = RocketMQInstanceNetworkInfoArgs(
        endpoints = endpoints,
        internetInfo = internetInfo ?: throw PulumiNullFieldException("internetInfo"),
        vpcInfo = vpcInfo ?: throw PulumiNullFieldException("vpcInfo"),
    )
}
