@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.inputs

import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property endpointType Access point type.
 * @property endpointUrl Access point address.
 * @property ipWhiteLists White list of access addresses.
 */
public data class RocketMQInstanceNetworkInfoEndpointArgs(
    public val endpointType: Output<String>? = null,
    public val endpointUrl: Output<String>? = null,
    public val ipWhiteLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoEndpointArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoEndpointArgs = com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoEndpointArgs.builder()
        .endpointType(endpointType?.applyValue({ args0 -> args0 }))
        .endpointUrl(endpointUrl?.applyValue({ args0 -> args0 }))
        .ipWhiteLists(ipWhiteLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RocketMQInstanceNetworkInfoEndpointArgs].
 */
@PulumiTagMarker
public class RocketMQInstanceNetworkInfoEndpointArgsBuilder internal constructor() {
    private var endpointType: Output<String>? = null

    private var endpointUrl: Output<String>? = null

    private var ipWhiteLists: Output<List<String>>? = null

    /**
     * @param value Access point type.
     */
    @JvmName("isivbqiohyuflcjv")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value Access point address.
     */
    @JvmName("ohpytjbtjgbvyytn")
    public suspend fun endpointUrl(`value`: Output<String>) {
        this.endpointUrl = value
    }

    /**
     * @param value White list of access addresses.
     */
    @JvmName("ddbdwvwhggvlpvux")
    public suspend fun ipWhiteLists(`value`: Output<List<String>>) {
        this.ipWhiteLists = value
    }

    @JvmName("ayjaalqerpkjeshq")
    public suspend fun ipWhiteLists(vararg values: Output<String>) {
        this.ipWhiteLists = Output.all(values.asList())
    }

    /**
     * @param values White list of access addresses.
     */
    @JvmName("dsnomuaflwsalwdm")
    public suspend fun ipWhiteLists(values: List<Output<String>>) {
        this.ipWhiteLists = Output.all(values)
    }

    /**
     * @param value Access point type.
     */
    @JvmName("vwyxadvnqebwlfen")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value Access point address.
     */
    @JvmName("dqaljlnlcyqacssk")
    public suspend fun endpointUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointUrl = mapped
    }

    /**
     * @param value White list of access addresses.
     */
    @JvmName("ohofbkwtvheuwlyh")
    public suspend fun ipWhiteLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipWhiteLists = mapped
    }

    /**
     * @param values White list of access addresses.
     */
    @JvmName("wxoqoqkfjxuotyll")
    public suspend fun ipWhiteLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipWhiteLists = mapped
    }

    internal fun build(): RocketMQInstanceNetworkInfoEndpointArgs =
        RocketMQInstanceNetworkInfoEndpointArgs(
            endpointType = endpointType,
            endpointUrl = endpointUrl,
            ipWhiteLists = ipWhiteLists,
        )
}
