@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.inputs

import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoInternetInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property flowOutBandwidth Public network bandwidth specification. Unit: Mb/s.This field should only be filled when the public network billing type is set to payByBandwidth.The value range is [1 - 1000].
 * @property flowOutType Public network billing type. The parameter values are as follows:
 * - payByBandwidth: Fixed bandwidth billing. Set this value when enabling public network access.
 * - uninvolved: Not involved. Set this value when disabling public network access.
 * @property internetSpec Whether to enable public network access. Instances by default support VPC access. If public network access is enabled, Alibaba Cloud Message Queue RocketMQ version will incur charges for public network outbound bandwidth. For specific billing information, please refer to [Public Network Access Fees](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/internet-access-fee). The parameter values are as follows:
 * - enable: Enable public network access
 * - disable: Disable public network access
 * @property ipWhitelists internet ip whitelist.
 */
public data class RocketMQInstanceNetworkInfoInternetInfoArgs(
    public val flowOutBandwidth: Output<Int>? = null,
    public val flowOutType: Output<String>,
    public val internetSpec: Output<String>,
    public val ipWhitelists: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoInternetInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoInternetInfoArgs =
        com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoInternetInfoArgs.builder()
            .flowOutBandwidth(flowOutBandwidth?.applyValue({ args0 -> args0 }))
            .flowOutType(flowOutType.applyValue({ args0 -> args0 }))
            .internetSpec(internetSpec.applyValue({ args0 -> args0 }))
            .ipWhitelists(ipWhitelists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RocketMQInstanceNetworkInfoInternetInfoArgs].
 */
@PulumiTagMarker
public class RocketMQInstanceNetworkInfoInternetInfoArgsBuilder internal constructor() {
    private var flowOutBandwidth: Output<Int>? = null

    private var flowOutType: Output<String>? = null

    private var internetSpec: Output<String>? = null

    private var ipWhitelists: Output<List<String>>? = null

    /**
     * @param value Public network bandwidth specification. Unit: Mb/s.This field should only be filled when the public network billing type is set to payByBandwidth.The value range is [1 - 1000].
     */
    @JvmName("hkvocepnkhnfnely")
    public suspend fun flowOutBandwidth(`value`: Output<Int>) {
        this.flowOutBandwidth = value
    }

    /**
     * @param value Public network billing type. The parameter values are as follows:
     * - payByBandwidth: Fixed bandwidth billing. Set this value when enabling public network access.
     * - uninvolved: Not involved. Set this value when disabling public network access.
     */
    @JvmName("iqiiorflbyvtrjok")
    public suspend fun flowOutType(`value`: Output<String>) {
        this.flowOutType = value
    }

    /**
     * @param value Whether to enable public network access. Instances by default support VPC access. If public network access is enabled, Alibaba Cloud Message Queue RocketMQ version will incur charges for public network outbound bandwidth. For specific billing information, please refer to [Public Network Access Fees](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/internet-access-fee). The parameter values are as follows:
     * - enable: Enable public network access
     * - disable: Disable public network access
     */
    @JvmName("tlwgxjhxnxhrjqum")
    public suspend fun internetSpec(`value`: Output<String>) {
        this.internetSpec = value
    }

    /**
     * @param value internet ip whitelist.
     */
    @JvmName("utpoboyhjlfhakce")
    public suspend fun ipWhitelists(`value`: Output<List<String>>) {
        this.ipWhitelists = value
    }

    @JvmName("bohvdipcqjcloyoa")
    public suspend fun ipWhitelists(vararg values: Output<String>) {
        this.ipWhitelists = Output.all(values.asList())
    }

    /**
     * @param values internet ip whitelist.
     */
    @JvmName("dsswtrkumgruyrlb")
    public suspend fun ipWhitelists(values: List<Output<String>>) {
        this.ipWhitelists = Output.all(values)
    }

    /**
     * @param value Public network bandwidth specification. Unit: Mb/s.This field should only be filled when the public network billing type is set to payByBandwidth.The value range is [1 - 1000].
     */
    @JvmName("kxoqdfxdqrltvwin")
    public suspend fun flowOutBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowOutBandwidth = mapped
    }

    /**
     * @param value Public network billing type. The parameter values are as follows:
     * - payByBandwidth: Fixed bandwidth billing. Set this value when enabling public network access.
     * - uninvolved: Not involved. Set this value when disabling public network access.
     */
    @JvmName("vpffxanvtihgvupf")
    public suspend fun flowOutType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flowOutType = mapped
    }

    /**
     * @param value Whether to enable public network access. Instances by default support VPC access. If public network access is enabled, Alibaba Cloud Message Queue RocketMQ version will incur charges for public network outbound bandwidth. For specific billing information, please refer to [Public Network Access Fees](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/internet-access-fee). The parameter values are as follows:
     * - enable: Enable public network access
     * - disable: Disable public network access
     */
    @JvmName("xeqaxlsvuroxafvx")
    public suspend fun internetSpec(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.internetSpec = mapped
    }

    /**
     * @param value internet ip whitelist.
     */
    @JvmName("errxnhgsnefdqwpn")
    public suspend fun ipWhitelists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipWhitelists = mapped
    }

    /**
     * @param values internet ip whitelist.
     */
    @JvmName("bohmgvqwindignwy")
    public suspend fun ipWhitelists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipWhitelists = mapped
    }

    internal fun build(): RocketMQInstanceNetworkInfoInternetInfoArgs =
        RocketMQInstanceNetworkInfoInternetInfoArgs(
            flowOutBandwidth = flowOutBandwidth,
            flowOutType = flowOutType ?: throw PulumiNullFieldException("flowOutType"),
            internetSpec = internetSpec ?: throw PulumiNullFieldException("internetSpec"),
            ipWhitelists = ipWhitelists,
        )
}
