@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.inputs

import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoVpcInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property vpcId Proprietary Network.
 * @property vswitchId VPC network switch.
 */
public data class RocketMQInstanceNetworkInfoVpcInfoArgs(
    public val vpcId: Output<String>,
    public val vswitchId: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoVpcInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoVpcInfoArgs = com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceNetworkInfoVpcInfoArgs.builder()
        .vpcId(vpcId.applyValue({ args0 -> args0 }))
        .vswitchId(vswitchId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RocketMQInstanceNetworkInfoVpcInfoArgs].
 */
@PulumiTagMarker
public class RocketMQInstanceNetworkInfoVpcInfoArgsBuilder internal constructor() {
    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value Proprietary Network.
     */
    @JvmName("twukyimbqdefwaxq")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value VPC network switch.
     */
    @JvmName("ykjatnpjmspudawa")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Proprietary Network.
     */
    @JvmName("ktmwtcqtcvgosiiq")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value VPC network switch.
     */
    @JvmName("mstvvlbogdqbhfec")
    public suspend fun vswitchId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): RocketMQInstanceNetworkInfoVpcInfoArgs =
        RocketMQInstanceNetworkInfoVpcInfoArgs(
            vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
            vswitchId = vswitchId ?: throw PulumiNullFieldException("vswitchId"),
        )
}
