@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.inputs

import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceProductInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoScaling is open auto scaling.
 * @property messageRetentionTime Duration of message retention. Unit: hours.For the range of values, please refer to [Usage Limits](https://help&#46;aliyun&#46;com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/usage-limits)>Resource Quotas>Limitations on Message Retention&#46;The message storage in AlibabaCloud RocketMQ is fully implemented in a serverless and elastic manner, with charges based on the actual storage space&#46; You can control the storage capacity of messages by adjusting the duration of message retention&#46; For more information, please see [Storage Fees](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/storage-fees).
 * @property msgProcessSpec Message sending and receiving calculation specifications. For details about the upper limit for sending and receiving messages, see [Instance Specifications](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-specifications).
 * @property sendReceiveRatio message send receive ratio.Value range: [0&#46;2, 0&#46;5].
 * @property supportAutoScaling is support auto scaling.
 */
public data class RocketMQInstanceProductInfoArgs(
    public val autoScaling: Output<Boolean>? = null,
    public val messageRetentionTime: Output<Int>? = null,
    public val msgProcessSpec: Output<String>,
    public val sendReceiveRatio: Output<Double>? = null,
    public val supportAutoScaling: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceProductInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceProductInfoArgs =
        com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceProductInfoArgs.builder()
            .autoScaling(autoScaling?.applyValue({ args0 -> args0 }))
            .messageRetentionTime(messageRetentionTime?.applyValue({ args0 -> args0 }))
            .msgProcessSpec(msgProcessSpec.applyValue({ args0 -> args0 }))
            .sendReceiveRatio(sendReceiveRatio?.applyValue({ args0 -> args0 }))
            .supportAutoScaling(supportAutoScaling?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RocketMQInstanceProductInfoArgs].
 */
@PulumiTagMarker
public class RocketMQInstanceProductInfoArgsBuilder internal constructor() {
    private var autoScaling: Output<Boolean>? = null

    private var messageRetentionTime: Output<Int>? = null

    private var msgProcessSpec: Output<String>? = null

    private var sendReceiveRatio: Output<Double>? = null

    private var supportAutoScaling: Output<Boolean>? = null

    /**
     * @param value is open auto scaling.
     */
    @JvmName("lxeynkwwytmuulcl")
    public suspend fun autoScaling(`value`: Output<Boolean>) {
        this.autoScaling = value
    }

    /**
     * @param value Duration of message retention. Unit: hours.For the range of values, please refer to [Usage Limits](https://help&#46;aliyun&#46;com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/usage-limits)>Resource Quotas>Limitations on Message Retention&#46;The message storage in AlibabaCloud RocketMQ is fully implemented in a serverless and elastic manner, with charges based on the actual storage space&#46; You can control the storage capacity of messages by adjusting the duration of message retention&#46; For more information, please see [Storage Fees](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/storage-fees).
     */
    @JvmName("danrgeubflelvkii")
    public suspend fun messageRetentionTime(`value`: Output<Int>) {
        this.messageRetentionTime = value
    }

    /**
     * @param value Message sending and receiving calculation specifications. For details about the upper limit for sending and receiving messages, see [Instance Specifications](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-specifications).
     */
    @JvmName("icblihjnqdumwjmq")
    public suspend fun msgProcessSpec(`value`: Output<String>) {
        this.msgProcessSpec = value
    }

    /**
     * @param value message send receive ratio.Value range: [0&#46;2, 0&#46;5].
     */
    @JvmName("fdjooiwhjvinowey")
    public suspend fun sendReceiveRatio(`value`: Output<Double>) {
        this.sendReceiveRatio = value
    }

    /**
     * @param value is support auto scaling.
     */
    @JvmName("vuksrkddsnxkxpsq")
    public suspend fun supportAutoScaling(`value`: Output<Boolean>) {
        this.supportAutoScaling = value
    }

    /**
     * @param value is open auto scaling.
     */
    @JvmName("dhnlisrynbounabd")
    public suspend fun autoScaling(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScaling = mapped
    }

    /**
     * @param value Duration of message retention. Unit: hours.For the range of values, please refer to [Usage Limits](https://help&#46;aliyun&#46;com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/usage-limits)>Resource Quotas>Limitations on Message Retention&#46;The message storage in AlibabaCloud RocketMQ is fully implemented in a serverless and elastic manner, with charges based on the actual storage space&#46; You can control the storage capacity of messages by adjusting the duration of message retention&#46; For more information, please see [Storage Fees](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/storage-fees).
     */
    @JvmName("jibaymqgkgkhlhto")
    public suspend fun messageRetentionTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageRetentionTime = mapped
    }

    /**
     * @param value Message sending and receiving calculation specifications. For details about the upper limit for sending and receiving messages, see [Instance Specifications](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-specifications).
     */
    @JvmName("tnqvyphkmpoadbpx")
    public suspend fun msgProcessSpec(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.msgProcessSpec = mapped
    }

    /**
     * @param value message send receive ratio.Value range: [0&#46;2, 0&#46;5].
     */
    @JvmName("ltlftbmqcwitrgtl")
    public suspend fun sendReceiveRatio(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendReceiveRatio = mapped
    }

    /**
     * @param value is support auto scaling.
     */
    @JvmName("wimoqjerymcvqscs")
    public suspend fun supportAutoScaling(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportAutoScaling = mapped
    }

    internal fun build(): RocketMQInstanceProductInfoArgs = RocketMQInstanceProductInfoArgs(
        autoScaling = autoScaling,
        messageRetentionTime = messageRetentionTime,
        msgProcessSpec = msgProcessSpec ?: throw PulumiNullFieldException("msgProcessSpec"),
        sendReceiveRatio = sendReceiveRatio,
        supportAutoScaling = supportAutoScaling,
    )
}
