@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.inputs

import com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceSoftwareArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maintainTime Upgrade time period.
 * @property softwareVersion Software version.
 * @property upgradeMethod Upgrade method.
 */
public data class RocketMQInstanceSoftwareArgs(
    public val maintainTime: Output<String>? = null,
    public val softwareVersion: Output<String>? = null,
    public val upgradeMethod: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceSoftwareArgs> {
    override fun toJava(): com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceSoftwareArgs =
        com.pulumi.alicloud.rocketmq.inputs.RocketMQInstanceSoftwareArgs.builder()
            .maintainTime(maintainTime?.applyValue({ args0 -> args0 }))
            .softwareVersion(softwareVersion?.applyValue({ args0 -> args0 }))
            .upgradeMethod(upgradeMethod?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RocketMQInstanceSoftwareArgs].
 */
@PulumiTagMarker
public class RocketMQInstanceSoftwareArgsBuilder internal constructor() {
    private var maintainTime: Output<String>? = null

    private var softwareVersion: Output<String>? = null

    private var upgradeMethod: Output<String>? = null

    /**
     * @param value Upgrade time period.
     */
    @JvmName("gxlixxwjysvctigr")
    public suspend fun maintainTime(`value`: Output<String>) {
        this.maintainTime = value
    }

    /**
     * @param value Software version.
     */
    @JvmName("evjsaxvoloudgnpm")
    public suspend fun softwareVersion(`value`: Output<String>) {
        this.softwareVersion = value
    }

    /**
     * @param value Upgrade method.
     */
    @JvmName("biaxmcjmlfpyojjo")
    public suspend fun upgradeMethod(`value`: Output<String>) {
        this.upgradeMethod = value
    }

    /**
     * @param value Upgrade time period.
     */
    @JvmName("jlptftjjtagsuxqc")
    public suspend fun maintainTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainTime = mapped
    }

    /**
     * @param value Software version.
     */
    @JvmName("nhjyadiffvkfugft")
    public suspend fun softwareVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softwareVersion = mapped
    }

    /**
     * @param value Upgrade method.
     */
    @JvmName("rwjobeauvejfjibr")
    public suspend fun upgradeMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeMethod = mapped
    }

    internal fun build(): RocketMQInstanceSoftwareArgs = RocketMQInstanceSoftwareArgs(
        maintainTime = maintainTime,
        softwareVersion = softwareVersion,
        upgradeMethod = upgradeMethod,
    )
}
