@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property groupName The name of the group.
 * @property groupType Specify the protocol applicable to the created Group ID. Valid values: `tcp`, `http`. Default to `tcp`.
 * @property id The name of the group.
 * @property independentNaming Indicates whether namespaces are available. Read [Fields in SubscribeInfoDo](https://www.alibabacloud.com/help/doc-detail/29619.html) for further details.
 * @property instanceId ID of the ONS Instance that owns the groups.
 * @property owner The ID of the group owner, which is the Alibaba Cloud UID.
 * @property remark Remark of the group.
 * @property tags A map of tags assigned to the Ons instance.
 */
public data class GetGroupsGroup(
    public val groupName: String,
    public val groupType: String,
    public val id: String,
    public val independentNaming: Boolean,
    public val instanceId: String,
    public val owner: String,
    public val remark: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rocketmq.outputs.GetGroupsGroup): GetGroupsGroup = GetGroupsGroup(
            groupName = javaType.groupName(),
            groupType = javaType.groupType(),
            id = javaType.id(),
            independentNaming = javaType.independentNaming(),
            instanceId = javaType.instanceId(),
            owner = javaType.owner(),
            remark = javaType.remark(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
