@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getGroups.
 * @property groupIdRegex
 * @property groupType Specify the protocol applicable to the created Group ID.
 * @property groups A list of groups. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of group names.
 * @property instanceId
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property tags A map of tags assigned to the Ons group.
 */
public data class GetGroupsResult(
    public val groupIdRegex: String? = null,
    public val groupType: String? = null,
    public val groups: List<GetGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rocketmq.outputs.GetGroupsResult): GetGroupsResult = GetGroupsResult(
            groupIdRegex = javaType.groupIdRegex().map({ args0 -> args0 }).orElse(null),
            groupType = javaType.groupType().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rocketmq.kotlin.outputs.GetGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
