@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property httpInternalEndpoint The internal HTTP endpoint for the Message Queue for Apache RocketMQ instance.
 * @property httpInternetEndpoint The public HTTP endpoint for the Message Queue for Apache RocketMQ instance.
 * @property httpInternetSecureEndpoint The public HTTPS endpoint for the Message Queue for Apache RocketMQ instance.
 * @property id ID of the instance.
 * @property independentNaming Indicates whether any namespace is configured for the Message Queue for Apache RocketMQ instance.
 * @property instanceId ID of the instance.
 * @property instanceName Name of the instance.
 * @property instanceStatus The status of the instance. Read [Fields in InstanceVO](https://www.alibabacloud.com/help/doc-detail/106351.html) for further details.
 * @property instanceType The type of the instance. Read [Fields in InstanceVO](https://www.alibabacloud.com/help/doc-detail/106351.html) for further details.
 * @property releaseTime The automatic release time of an Enterprise Platinum Edition instance.
 * @property remark This attribute is a concise description of instance.
 * @property status The status of Ons instance. Valid values: `0` deploying, `2` arrears, `5` running, `7` upgrading.
 * @property tags A map of tags assigned to the Ons instance.
 * @property tcpEndpoint The TCP endpoint for the Message Queue for Apache RocketMQ instance.
 */
public data class GetInstancesInstance(
    public val httpInternalEndpoint: String,
    public val httpInternetEndpoint: String,
    public val httpInternetSecureEndpoint: String,
    public val id: String,
    public val independentNaming: Boolean,
    public val instanceId: String,
    public val instanceName: String,
    public val instanceStatus: Int,
    public val instanceType: Int,
    public val releaseTime: String,
    public val remark: String,
    public val status: Int,
    public val tags: Map<String, String>,
    public val tcpEndpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rocketmq.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            httpInternalEndpoint = javaType.httpInternalEndpoint(),
            httpInternetEndpoint = javaType.httpInternetEndpoint(),
            httpInternetSecureEndpoint = javaType.httpInternetSecureEndpoint(),
            id = javaType.id(),
            independentNaming = javaType.independentNaming(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            instanceStatus = javaType.instanceStatus(),
            instanceType = javaType.instanceType(),
            releaseTime = javaType.releaseTime(),
            remark = javaType.remark(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tcpEndpoint = javaType.tcpEndpoint(),
        )
    }
}
