@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property id The id of the topic.
 * @property independentNaming Indicates whether namespaces are available. Read [Fields in PublishInfoDo](https://www.alibabacloud.com/help/doc-detail/29590.html) for further details.
 * @property instanceId ID of the ONS Instance that owns the topics.
 * @property messageType The type of the message. Read [Fields in PublishInfoDo](https://www.alibabacloud.com/help/doc-detail/29590.html) for further details.
 * @property owner The ID of the topic owner, which is the Alibaba Cloud UID.
 * @property perm This attribute is used to set the read-write mode for the topic.
 * @property relation The relation ID. Read [Fields in PublishInfoDo](https://www.alibabacloud.com/help/doc-detail/29590.html) for further details.
 * @property relationName The name of the relation, for example, owner, publishable, subscribable, and publishable and subscribable.
 * @property remark Remark of the topic.
 * @property tags A map of tags assigned to the Ons instance.
 * @property topic The name of the topic.
 * @property topicName The name of the topic.
 */
public data class GetTopicsTopic(
    public val id: String,
    public val independentNaming: Boolean,
    public val instanceId: String,
    public val messageType: Int,
    public val owner: String,
    public val perm: Int,
    public val relation: Int,
    public val relationName: String,
    public val remark: String,
    public val tags: Map<String, String>,
    public val topic: String,
    public val topicName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rocketmq.outputs.GetTopicsTopic): GetTopicsTopic = GetTopicsTopic(
            id = javaType.id(),
            independentNaming = javaType.independentNaming(),
            instanceId = javaType.instanceId(),
            messageType = javaType.messageType(),
            owner = javaType.owner(),
            perm = javaType.perm(),
            relation = javaType.relation(),
            relationName = javaType.relationName(),
            remark = javaType.remark(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            topic = javaType.topic(),
            topicName = javaType.topicName(),
        )
    }
}
