@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property endpoints Access point list.
 * @property internetInfo instance internet info. See `internet_info` below.
 * @property vpcInfo Proprietary network information. See `vpc_info` below.
 */
public data class RocketMQInstanceNetworkInfo(
    public val endpoints: List<RocketMQInstanceNetworkInfoEndpoint>? = null,
    public val internetInfo: RocketMQInstanceNetworkInfoInternetInfo,
    public val vpcInfo: RocketMQInstanceNetworkInfoVpcInfo,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rocketmq.outputs.RocketMQInstanceNetworkInfo): RocketMQInstanceNetworkInfo = RocketMQInstanceNetworkInfo(
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rocketmq.kotlin.outputs.RocketMQInstanceNetworkInfoEndpoint.Companion.toKotlin(args0)
                })
            }),
            internetInfo = javaType.internetInfo().let({ args0 ->
                com.pulumi.alicloud.rocketmq.kotlin.outputs.RocketMQInstanceNetworkInfoInternetInfo.Companion.toKotlin(args0)
            }),
            vpcInfo = javaType.vpcInfo().let({ args0 ->
                com.pulumi.alicloud.rocketmq.kotlin.outputs.RocketMQInstanceNetworkInfoVpcInfo.Companion.toKotlin(args0)
            }),
        )
    }
}
