@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property endpointType Access point type.
 * @property endpointUrl Access point address.
 * @property ipWhiteLists White list of access addresses.
 */
public data class RocketMQInstanceNetworkInfoEndpoint(
    public val endpointType: String? = null,
    public val endpointUrl: String? = null,
    public val ipWhiteLists: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rocketmq.outputs.RocketMQInstanceNetworkInfoEndpoint): RocketMQInstanceNetworkInfoEndpoint = RocketMQInstanceNetworkInfoEndpoint(
            endpointType = javaType.endpointType().map({ args0 -> args0 }).orElse(null),
            endpointUrl = javaType.endpointUrl().map({ args0 -> args0 }).orElse(null),
            ipWhiteLists = javaType.ipWhiteLists().map({ args0 -> args0 }),
        )
    }
}
