@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property flowOutBandwidth Public network bandwidth specification. Unit: Mb/s.This field should only be filled when the public network billing type is set to payByBandwidth.The value range is [1 - 1000].
 * @property flowOutType Public network billing type. The parameter values are as follows:
 * - payByBandwidth: Fixed bandwidth billing. Set this value when enabling public network access.
 * - uninvolved: Not involved. Set this value when disabling public network access.
 * @property internetSpec Whether to enable public network access. Instances by default support VPC access. If public network access is enabled, Alibaba Cloud Message Queue RocketMQ version will incur charges for public network outbound bandwidth. For specific billing information, please refer to [Public Network Access Fees](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/internet-access-fee). The parameter values are as follows:
 * - enable: Enable public network access
 * - disable: Disable public network access
 * @property ipWhitelists internet ip whitelist.
 */
public data class RocketMQInstanceNetworkInfoInternetInfo(
    public val flowOutBandwidth: Int? = null,
    public val flowOutType: String,
    public val internetSpec: String,
    public val ipWhitelists: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rocketmq.outputs.RocketMQInstanceNetworkInfoInternetInfo): RocketMQInstanceNetworkInfoInternetInfo = RocketMQInstanceNetworkInfoInternetInfo(
            flowOutBandwidth = javaType.flowOutBandwidth().map({ args0 -> args0 }).orElse(null),
            flowOutType = javaType.flowOutType(),
            internetSpec = javaType.internetSpec(),
            ipWhitelists = javaType.ipWhitelists().map({ args0 -> args0 }),
        )
    }
}
