@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoScaling is open auto scaling.
 * @property messageRetentionTime Duration of message retention. Unit: hours.For the range of values, please refer to [Usage Limits](https://help&#46;aliyun&#46;com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/usage-limits)>Resource Quotas>Limitations on Message Retention&#46;The message storage in AlibabaCloud RocketMQ is fully implemented in a serverless and elastic manner, with charges based on the actual storage space&#46; You can control the storage capacity of messages by adjusting the duration of message retention&#46; For more information, please see [Storage Fees](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/storage-fees).
 * @property msgProcessSpec Message sending and receiving calculation specifications. For details about the upper limit for sending and receiving messages, see [Instance Specifications](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-specifications).
 * @property sendReceiveRatio message send receive ratio.Value range: [0&#46;2, 0&#46;5].
 * @property supportAutoScaling is support auto scaling.
 */
public data class RocketMQInstanceProductInfo(
    public val autoScaling: Boolean? = null,
    public val messageRetentionTime: Int? = null,
    public val msgProcessSpec: String,
    public val sendReceiveRatio: Double? = null,
    public val supportAutoScaling: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rocketmq.outputs.RocketMQInstanceProductInfo): RocketMQInstanceProductInfo = RocketMQInstanceProductInfo(
            autoScaling = javaType.autoScaling().map({ args0 -> args0 }).orElse(null),
            messageRetentionTime = javaType.messageRetentionTime().map({ args0 -> args0 }).orElse(null),
            msgProcessSpec = javaType.msgProcessSpec(),
            sendReceiveRatio = javaType.sendReceiveRatio().map({ args0 -> args0 }).orElse(null),
            supportAutoScaling = javaType.supportAutoScaling().map({ args0 -> args0 }).orElse(null),
        )
    }
}
