@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rocketmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property maintainTime Upgrade time period.
 * @property softwareVersion Software version.
 * @property upgradeMethod Upgrade method.
 */
public data class RocketMQInstanceSoftware(
    public val maintainTime: String? = null,
    public val softwareVersion: String? = null,
    public val upgradeMethod: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rocketmq.outputs.RocketMQInstanceSoftware): RocketMQInstanceSoftware = RocketMQInstanceSoftware(
            maintainTime = javaType.maintainTime().map({ args0 -> args0 }).orElse(null),
            softwareVersion = javaType.softwareVersion().map({ args0 -> args0 }).orElse(null),
            upgradeMethod = javaType.upgradeMethod().map({ args0 -> args0 }).orElse(null),
        )
    }
}
