@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin

import com.pulumi.alicloud.ros.kotlin.outputs.ChangeSetParameter
import com.pulumi.alicloud.ros.kotlin.outputs.ChangeSetParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ChangeSet].
 */
@PulumiTagMarker
public class ChangeSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ChangeSetArgs = ChangeSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ChangeSetArgsBuilder.() -> Unit) {
        val builder = ChangeSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ChangeSet {
        val builtJavaResource = com.pulumi.alicloud.ros.ChangeSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ChangeSet(builtJavaResource)
    }
}

/**
 * Provides a ROS Change Set resource.
 * For information about ROS Change Set and how to use it, see [What is Change Set](https://www.alibabacloud.com/help/doc-detail/131051.htm).
 * > **NOTE:** Available in v1.105.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.ros.ChangeSet("example", {
 *     changeSetName: "example_value",
 *     stackName: `tf-example-${_default.result}`,
 *     changeSetType: "CREATE",
 *     description: "Test From Terraform",
 *     templateBody: "{\"ROSTemplateFormatVersion\":\"2015-09-01\"}",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.ros.ChangeSet("example",
 *     change_set_name="example_value",
 *     stack_name=f"tf-example-{default['result']}",
 *     change_set_type="CREATE",
 *     description="Test From Terraform",
 *     template_body="{\"ROSTemplateFormatVersion\":\"2015-09-01\"}")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.Ros.ChangeSet("example", new()
 *     {
 *         ChangeSetName = "example_value",
 *         StackName = $"tf-example-{@default.Result}",
 *         ChangeSetType = "CREATE",
 *         Description = "Test From Terraform",
 *         TemplateBody = "{\"ROSTemplateFormatVersion\":\"2015-09-01\"}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ros.NewChangeSet(ctx, "example", &ros.ChangeSetArgs{
 * 			ChangeSetName: pulumi.String("example_value"),
 * 			StackName:     pulumi.Sprintf("tf-example-%v", _default.Result),
 * 			ChangeSetType: pulumi.String("CREATE"),
 * 			Description:   pulumi.String("Test From Terraform"),
 * 			TemplateBody:  pulumi.String("{\"ROSTemplateFormatVersion\":\"2015-09-01\"}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.ros.ChangeSet;
 * import com.pulumi.alicloud.ros.ChangeSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new ChangeSet("example", ChangeSetArgs.builder()
 *             .changeSetName("example_value")
 *             .stackName(String.format("tf-example-%s", default_.result()))
 *             .changeSetType("CREATE")
 *             .description("Test From Terraform")
 *             .templateBody("{\"ROSTemplateFormatVersion\":\"2015-09-01\"}")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:ros:ChangeSet
 *     properties:
 *       changeSetName: example_value
 *       stackName: tf-example-${default.result}
 *       changeSetType: CREATE
 *       description: Test From Terraform
 *       templateBody: '{"ROSTemplateFormatVersion":"2015-09-01"}'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ROS Change Set can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ros/changeSet:ChangeSet example <change_set_id>
 * ```
 */
public class ChangeSet internal constructor(
    override val javaResource: com.pulumi.alicloud.ros.ChangeSet,
) : KotlinCustomResource(javaResource, ChangeSetMapper) {
    /**
     * The name of the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
     */
    public val changeSetName: Output<String>
        get() = javaResource.changeSetName().applyValue({ args0 -> args0 })

    /**
     * The type of the change set. Valid values:  CREATE: creates a change set for a new stack. UPDATE: creates a change set for an existing stack. IMPORT: creates a change set for a new stack or an existing stack to import non-ROS-managed resources. If you create a change set for a new stack, ROS creates a stack that has a unique stack ID. The stack is in the REVIEW_IN_PROGRESS state until you execute the change set.  You cannot use the UPDATE type to create a change set for a new stack or the CREATE type to create a change set for an existing stack.
     */
    public val changeSetType: Output<String>?
        get() = javaResource.changeSetType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the change set. The description can be up to 1,024 bytes in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to disable rollback on stack creation failure. Default value: false.  Valid values:  true: disables rollback on stack creation failure. false: enables rollback on stack creation failure. Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
     */
    public val disableRollback: Output<Boolean>?
        get() = javaResource.disableRollback().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The notification urls.
     */
    public val notificationUrls: Output<List<String>>?
        get() = javaResource.notificationUrls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Parameters.
     */
    public val parameters: Output<List<ChangeSetParameter>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The ram role name.
     */
    public val ramRoleName: Output<String>?
        get() = javaResource.ramRoleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The replacement option.
     */
    public val replacementOption: Output<String>?
        get() = javaResource.replacementOption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the stack for which you want to create the change set. ROS generates the change set by comparing the stack information with the information that you submit, such as a modified template or different inputs.
     */
    public val stackId: Output<String>
        get() = javaResource.stackId().applyValue({ args0 -> args0 })

    /**
     * The name of the stack for which you want to create the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.  Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
     */
    public val stackName: Output<String>?
        get() = javaResource.stackName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The stack policy body.
     */
    public val stackPolicyBody: Output<String>?
        get() = javaResource.stackPolicyBody().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The stack policy during update body.
     */
    public val stackPolicyDuringUpdateBody: Output<String>?
        get() = javaResource.stackPolicyDuringUpdateBody().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The stack policy during update url.
     */
    public val stackPolicyDuringUpdateUrl: Output<String>?
        get() = javaResource.stackPolicyDuringUpdateUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The stack policy url.
     */
    public val stackPolicyUrl: Output<String>?
        get() = javaResource.stackPolicyUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the change set.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You can specify one of TemplateBody or TemplateURL parameters, but you cannot specify both of them.
     */
    public val templateBody: Output<String>?
        get() = javaResource.templateBody().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The template url.
     */
    public val templateUrl: Output<String>?
        get() = javaResource.templateUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Timeout In Minutes.
     */
    public val timeoutInMinutes: Output<Int>
        get() = javaResource.timeoutInMinutes().applyValue({ args0 -> args0 })

    /**
     * The use previous parameters.
     */
    public val usePreviousParameters: Output<Boolean>?
        get() = javaResource.usePreviousParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ChangeSetMapper : ResourceMapper<ChangeSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ros.ChangeSet::class == javaResource::class

    override fun map(javaResource: Resource): ChangeSet = ChangeSet(
        javaResource as
            com.pulumi.alicloud.ros.ChangeSet,
    )
}

/**
 * @see [ChangeSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ChangeSet].
 */
public suspend fun changeSet(name: String, block: suspend ChangeSetResourceBuilder.() -> Unit): ChangeSet {
    val builder = ChangeSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ChangeSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun changeSet(name: String): ChangeSet {
    val builder = ChangeSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
