@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin

import com.pulumi.alicloud.ros.ChangeSetArgs.builder
import com.pulumi.alicloud.ros.kotlin.inputs.ChangeSetParameterArgs
import com.pulumi.alicloud.ros.kotlin.inputs.ChangeSetParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a ROS Change Set resource.
 * For information about ROS Change Set and how to use it, see [What is Change Set](https://www.alibabacloud.com/help/doc-detail/131051.htm).
 * > **NOTE:** Available in v1.105.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.ros.ChangeSet("example", {
 *     changeSetName: "example_value",
 *     stackName: `tf-example-${_default.result}`,
 *     changeSetType: "CREATE",
 *     description: "Test From Terraform",
 *     templateBody: "{\"ROSTemplateFormatVersion\":\"2015-09-01\"}",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.ros.ChangeSet("example",
 *     change_set_name="example_value",
 *     stack_name=f"tf-example-{default['result']}",
 *     change_set_type="CREATE",
 *     description="Test From Terraform",
 *     template_body="{\"ROSTemplateFormatVersion\":\"2015-09-01\"}")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.Ros.ChangeSet("example", new()
 *     {
 *         ChangeSetName = "example_value",
 *         StackName = $"tf-example-{@default.Result}",
 *         ChangeSetType = "CREATE",
 *         Description = "Test From Terraform",
 *         TemplateBody = "{\"ROSTemplateFormatVersion\":\"2015-09-01\"}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ros.NewChangeSet(ctx, "example", &ros.ChangeSetArgs{
 * 			ChangeSetName: pulumi.String("example_value"),
 * 			StackName:     pulumi.Sprintf("tf-example-%v", _default.Result),
 * 			ChangeSetType: pulumi.String("CREATE"),
 * 			Description:   pulumi.String("Test From Terraform"),
 * 			TemplateBody:  pulumi.String("{\"ROSTemplateFormatVersion\":\"2015-09-01\"}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.ros.ChangeSet;
 * import com.pulumi.alicloud.ros.ChangeSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new ChangeSet("example", ChangeSetArgs.builder()
 *             .changeSetName("example_value")
 *             .stackName(String.format("tf-example-%s", default_.result()))
 *             .changeSetType("CREATE")
 *             .description("Test From Terraform")
 *             .templateBody("{\"ROSTemplateFormatVersion\":\"2015-09-01\"}")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:ros:ChangeSet
 *     properties:
 *       changeSetName: example_value
 *       stackName: tf-example-${default.result}
 *       changeSetType: CREATE
 *       description: Test From Terraform
 *       templateBody: '{"ROSTemplateFormatVersion":"2015-09-01"}'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ROS Change Set can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ros/changeSet:ChangeSet example <change_set_id>
 * ```
 * @property changeSetName The name of the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
 * @property changeSetType The type of the change set. Valid values:  CREATE: creates a change set for a new stack. UPDATE: creates a change set for an existing stack. IMPORT: creates a change set for a new stack or an existing stack to import non-ROS-managed resources. If you create a change set for a new stack, ROS creates a stack that has a unique stack ID. The stack is in the REVIEW_IN_PROGRESS state until you execute the change set.  You cannot use the UPDATE type to create a change set for a new stack or the CREATE type to create a change set for an existing stack.
 * @property description The description of the change set. The description can be up to 1,024 bytes in length.
 * @property disableRollback Specifies whether to disable rollback on stack creation failure. Default value: false.  Valid values:  true: disables rollback on stack creation failure. false: enables rollback on stack creation failure. Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
 * @property notificationUrls The notification urls.
 * @property parameters Parameters.
 * @property ramRoleName The ram role name.
 * @property replacementOption The replacement option.
 * @property stackId The ID of the stack for which you want to create the change set. ROS generates the change set by comparing the stack information with the information that you submit, such as a modified template or different inputs.
 * @property stackName The name of the stack for which you want to create the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.  Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
 * @property stackPolicyBody The stack policy body.
 * @property stackPolicyDuringUpdateBody The stack policy during update body.
 * @property stackPolicyDuringUpdateUrl The stack policy during update url.
 * @property stackPolicyUrl The stack policy url.
 * @property templateBody The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You can specify one of TemplateBody or TemplateURL parameters, but you cannot specify both of them.
 * @property templateUrl The template url.
 * @property timeoutInMinutes Timeout In Minutes.
 * @property usePreviousParameters The use previous parameters.
 */
public data class ChangeSetArgs(
    public val changeSetName: Output<String>? = null,
    public val changeSetType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val disableRollback: Output<Boolean>? = null,
    public val notificationUrls: Output<List<String>>? = null,
    public val parameters: Output<List<ChangeSetParameterArgs>>? = null,
    public val ramRoleName: Output<String>? = null,
    public val replacementOption: Output<String>? = null,
    public val stackId: Output<String>? = null,
    public val stackName: Output<String>? = null,
    public val stackPolicyBody: Output<String>? = null,
    public val stackPolicyDuringUpdateBody: Output<String>? = null,
    public val stackPolicyDuringUpdateUrl: Output<String>? = null,
    public val stackPolicyUrl: Output<String>? = null,
    public val templateBody: Output<String>? = null,
    public val templateUrl: Output<String>? = null,
    public val timeoutInMinutes: Output<Int>? = null,
    public val usePreviousParameters: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.ChangeSetArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.ChangeSetArgs =
        com.pulumi.alicloud.ros.ChangeSetArgs.builder()
            .changeSetName(changeSetName?.applyValue({ args0 -> args0 }))
            .changeSetType(changeSetType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .disableRollback(disableRollback?.applyValue({ args0 -> args0 }))
            .notificationUrls(notificationUrls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ramRoleName(ramRoleName?.applyValue({ args0 -> args0 }))
            .replacementOption(replacementOption?.applyValue({ args0 -> args0 }))
            .stackId(stackId?.applyValue({ args0 -> args0 }))
            .stackName(stackName?.applyValue({ args0 -> args0 }))
            .stackPolicyBody(stackPolicyBody?.applyValue({ args0 -> args0 }))
            .stackPolicyDuringUpdateBody(stackPolicyDuringUpdateBody?.applyValue({ args0 -> args0 }))
            .stackPolicyDuringUpdateUrl(stackPolicyDuringUpdateUrl?.applyValue({ args0 -> args0 }))
            .stackPolicyUrl(stackPolicyUrl?.applyValue({ args0 -> args0 }))
            .templateBody(templateBody?.applyValue({ args0 -> args0 }))
            .templateUrl(templateUrl?.applyValue({ args0 -> args0 }))
            .timeoutInMinutes(timeoutInMinutes?.applyValue({ args0 -> args0 }))
            .usePreviousParameters(usePreviousParameters?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChangeSetArgs].
 */
@PulumiTagMarker
public class ChangeSetArgsBuilder internal constructor() {
    private var changeSetName: Output<String>? = null

    private var changeSetType: Output<String>? = null

    private var description: Output<String>? = null

    private var disableRollback: Output<Boolean>? = null

    private var notificationUrls: Output<List<String>>? = null

    private var parameters: Output<List<ChangeSetParameterArgs>>? = null

    private var ramRoleName: Output<String>? = null

    private var replacementOption: Output<String>? = null

    private var stackId: Output<String>? = null

    private var stackName: Output<String>? = null

    private var stackPolicyBody: Output<String>? = null

    private var stackPolicyDuringUpdateBody: Output<String>? = null

    private var stackPolicyDuringUpdateUrl: Output<String>? = null

    private var stackPolicyUrl: Output<String>? = null

    private var templateBody: Output<String>? = null

    private var templateUrl: Output<String>? = null

    private var timeoutInMinutes: Output<Int>? = null

    private var usePreviousParameters: Output<Boolean>? = null

    /**
     * @param value The name of the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
     */
    @JvmName("qgutkialtkarlwev")
    public suspend fun changeSetName(`value`: Output<String>) {
        this.changeSetName = value
    }

    /**
     * @param value The type of the change set. Valid values:  CREATE: creates a change set for a new stack. UPDATE: creates a change set for an existing stack. IMPORT: creates a change set for a new stack or an existing stack to import non-ROS-managed resources. If you create a change set for a new stack, ROS creates a stack that has a unique stack ID. The stack is in the REVIEW_IN_PROGRESS state until you execute the change set.  You cannot use the UPDATE type to create a change set for a new stack or the CREATE type to create a change set for an existing stack.
     */
    @JvmName("tdtaydfxtxodbgxq")
    public suspend fun changeSetType(`value`: Output<String>) {
        this.changeSetType = value
    }

    /**
     * @param value The description of the change set. The description can be up to 1,024 bytes in length.
     */
    @JvmName("ddnrnfaqriackfoe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether to disable rollback on stack creation failure. Default value: false.  Valid values:  true: disables rollback on stack creation failure. false: enables rollback on stack creation failure. Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
     */
    @JvmName("tkojhxqkrfltrpom")
    public suspend fun disableRollback(`value`: Output<Boolean>) {
        this.disableRollback = value
    }

    /**
     * @param value The notification urls.
     */
    @JvmName("mqyinkakppuggboq")
    public suspend fun notificationUrls(`value`: Output<List<String>>) {
        this.notificationUrls = value
    }

    @JvmName("cfwqyqiinfefebij")
    public suspend fun notificationUrls(vararg values: Output<String>) {
        this.notificationUrls = Output.all(values.asList())
    }

    /**
     * @param values The notification urls.
     */
    @JvmName("lxnnoaslnfqlikdd")
    public suspend fun notificationUrls(values: List<Output<String>>) {
        this.notificationUrls = Output.all(values)
    }

    /**
     * @param value Parameters.
     */
    @JvmName("jjfmypnemcujsbxw")
    public suspend fun parameters(`value`: Output<List<ChangeSetParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("isonpmbwlkxpdrsq")
    public suspend fun parameters(vararg values: Output<ChangeSetParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Parameters.
     */
    @JvmName("cucvomquesegeycd")
    public suspend fun parameters(values: List<Output<ChangeSetParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The ram role name.
     */
    @JvmName("tykalnotlhpyljtn")
    public suspend fun ramRoleName(`value`: Output<String>) {
        this.ramRoleName = value
    }

    /**
     * @param value The replacement option.
     */
    @JvmName("sfcxdbwmiiemgpsv")
    public suspend fun replacementOption(`value`: Output<String>) {
        this.replacementOption = value
    }

    /**
     * @param value The ID of the stack for which you want to create the change set. ROS generates the change set by comparing the stack information with the information that you submit, such as a modified template or different inputs.
     */
    @JvmName("cclfcpcplgtylrdd")
    public suspend fun stackId(`value`: Output<String>) {
        this.stackId = value
    }

    /**
     * @param value The name of the stack for which you want to create the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.  Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
     */
    @JvmName("sijvkqainlvegono")
    public suspend fun stackName(`value`: Output<String>) {
        this.stackName = value
    }

    /**
     * @param value The stack policy body.
     */
    @JvmName("mintueqxnurvuhrs")
    public suspend fun stackPolicyBody(`value`: Output<String>) {
        this.stackPolicyBody = value
    }

    /**
     * @param value The stack policy during update body.
     */
    @JvmName("bkoxibryoqrqwirg")
    public suspend fun stackPolicyDuringUpdateBody(`value`: Output<String>) {
        this.stackPolicyDuringUpdateBody = value
    }

    /**
     * @param value The stack policy during update url.
     */
    @JvmName("cnqaosappconamux")
    public suspend fun stackPolicyDuringUpdateUrl(`value`: Output<String>) {
        this.stackPolicyDuringUpdateUrl = value
    }

    /**
     * @param value The stack policy url.
     */
    @JvmName("xnpogkhcbelxdwci")
    public suspend fun stackPolicyUrl(`value`: Output<String>) {
        this.stackPolicyUrl = value
    }

    /**
     * @param value The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You can specify one of TemplateBody or TemplateURL parameters, but you cannot specify both of them.
     */
    @JvmName("uxbaxpigcurvkski")
    public suspend fun templateBody(`value`: Output<String>) {
        this.templateBody = value
    }

    /**
     * @param value The template url.
     */
    @JvmName("sjlqckdokbnhdpxm")
    public suspend fun templateUrl(`value`: Output<String>) {
        this.templateUrl = value
    }

    /**
     * @param value Timeout In Minutes.
     */
    @JvmName("atkjrwwnsivkxhsb")
    public suspend fun timeoutInMinutes(`value`: Output<Int>) {
        this.timeoutInMinutes = value
    }

    /**
     * @param value The use previous parameters.
     */
    @JvmName("jrdottgyrmsthran")
    public suspend fun usePreviousParameters(`value`: Output<Boolean>) {
        this.usePreviousParameters = value
    }

    /**
     * @param value The name of the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
     */
    @JvmName("lpekfmnkuylujwwv")
    public suspend fun changeSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeSetName = mapped
    }

    /**
     * @param value The type of the change set. Valid values:  CREATE: creates a change set for a new stack. UPDATE: creates a change set for an existing stack. IMPORT: creates a change set for a new stack or an existing stack to import non-ROS-managed resources. If you create a change set for a new stack, ROS creates a stack that has a unique stack ID. The stack is in the REVIEW_IN_PROGRESS state until you execute the change set.  You cannot use the UPDATE type to create a change set for a new stack or the CREATE type to create a change set for an existing stack.
     */
    @JvmName("sduerkbbaojolghq")
    public suspend fun changeSetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeSetType = mapped
    }

    /**
     * @param value The description of the change set. The description can be up to 1,024 bytes in length.
     */
    @JvmName("pgjrxikphgcykvul")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether to disable rollback on stack creation failure. Default value: false.  Valid values:  true: disables rollback on stack creation failure. false: enables rollback on stack creation failure. Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
     */
    @JvmName("xkofufawogsjrvee")
    public suspend fun disableRollback(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableRollback = mapped
    }

    /**
     * @param value The notification urls.
     */
    @JvmName("lcqpkymjjqyafnis")
    public suspend fun notificationUrls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationUrls = mapped
    }

    /**
     * @param values The notification urls.
     */
    @JvmName("gutjvufywhkvafsa")
    public suspend fun notificationUrls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationUrls = mapped
    }

    /**
     * @param value Parameters.
     */
    @JvmName("raibtebvxendciqx")
    public suspend fun parameters(`value`: List<ChangeSetParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters.
     */
    @JvmName("ibrfgbodefaripwb")
    public suspend fun parameters(argument: List<suspend ChangeSetParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChangeSetParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Parameters.
     */
    @JvmName("iguyjbetdmqyyrne")
    public suspend fun parameters(vararg argument: suspend ChangeSetParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChangeSetParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Parameters.
     */
    @JvmName("hxoedohamnjquwkh")
    public suspend fun parameters(argument: suspend ChangeSetParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ChangeSetParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters.
     */
    @JvmName("wxvqyhvtmdlsjmtn")
    public suspend fun parameters(vararg values: ChangeSetParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The ram role name.
     */
    @JvmName("papnahbrchilbijy")
    public suspend fun ramRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramRoleName = mapped
    }

    /**
     * @param value The replacement option.
     */
    @JvmName("pxbryjnffylqwqfu")
    public suspend fun replacementOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replacementOption = mapped
    }

    /**
     * @param value The ID of the stack for which you want to create the change set. ROS generates the change set by comparing the stack information with the information that you submit, such as a modified template or different inputs.
     */
    @JvmName("jxaqvbfuerqkrobu")
    public suspend fun stackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackId = mapped
    }

    /**
     * @param value The name of the stack for which you want to create the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.  Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
     */
    @JvmName("kkeqmrsltmxoworg")
    public suspend fun stackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackName = mapped
    }

    /**
     * @param value The stack policy body.
     */
    @JvmName("hlkbhqrnfuhopuqb")
    public suspend fun stackPolicyBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackPolicyBody = mapped
    }

    /**
     * @param value The stack policy during update body.
     */
    @JvmName("ltmyonmxfcuwxpfe")
    public suspend fun stackPolicyDuringUpdateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackPolicyDuringUpdateBody = mapped
    }

    /**
     * @param value The stack policy during update url.
     */
    @JvmName("fhifewbljaiunyja")
    public suspend fun stackPolicyDuringUpdateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackPolicyDuringUpdateUrl = mapped
    }

    /**
     * @param value The stack policy url.
     */
    @JvmName("xfwmisoeokeabxwi")
    public suspend fun stackPolicyUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackPolicyUrl = mapped
    }

    /**
     * @param value The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You can specify one of TemplateBody or TemplateURL parameters, but you cannot specify both of them.
     */
    @JvmName("xewabkpveubqcnmj")
    public suspend fun templateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateBody = mapped
    }

    /**
     * @param value The template url.
     */
    @JvmName("ybgleireeswcmaxj")
    public suspend fun templateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateUrl = mapped
    }

    /**
     * @param value Timeout In Minutes.
     */
    @JvmName("lgtcspcruckljdll")
    public suspend fun timeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInMinutes = mapped
    }

    /**
     * @param value The use previous parameters.
     */
    @JvmName("bhiogloifjwuwvxe")
    public suspend fun usePreviousParameters(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePreviousParameters = mapped
    }

    internal fun build(): ChangeSetArgs = ChangeSetArgs(
        changeSetName = changeSetName,
        changeSetType = changeSetType,
        description = description,
        disableRollback = disableRollback,
        notificationUrls = notificationUrls,
        parameters = parameters,
        ramRoleName = ramRoleName,
        replacementOption = replacementOption,
        stackId = stackId,
        stackName = stackName,
        stackPolicyBody = stackPolicyBody,
        stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody,
        stackPolicyDuringUpdateUrl = stackPolicyDuringUpdateUrl,
        stackPolicyUrl = stackPolicyUrl,
        templateBody = templateBody,
        templateUrl = templateUrl,
        timeoutInMinutes = timeoutInMinutes,
        usePreviousParameters = usePreviousParameters,
    )
}
