@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin

import com.pulumi.alicloud.ros.RosFunctions.getChangeSetsPlain
import com.pulumi.alicloud.ros.RosFunctions.getRegionsPlain
import com.pulumi.alicloud.ros.RosFunctions.getStackGroupsPlain
import com.pulumi.alicloud.ros.RosFunctions.getStackInstancesPlain
import com.pulumi.alicloud.ros.RosFunctions.getStacksPlain
import com.pulumi.alicloud.ros.RosFunctions.getTemplateScratchesPlain
import com.pulumi.alicloud.ros.RosFunctions.getTemplatesPlain
import com.pulumi.alicloud.ros.kotlin.inputs.GetChangeSetsPlainArgs
import com.pulumi.alicloud.ros.kotlin.inputs.GetChangeSetsPlainArgsBuilder
import com.pulumi.alicloud.ros.kotlin.inputs.GetRegionsPlainArgs
import com.pulumi.alicloud.ros.kotlin.inputs.GetRegionsPlainArgsBuilder
import com.pulumi.alicloud.ros.kotlin.inputs.GetStackGroupsPlainArgs
import com.pulumi.alicloud.ros.kotlin.inputs.GetStackGroupsPlainArgsBuilder
import com.pulumi.alicloud.ros.kotlin.inputs.GetStackInstancesPlainArgs
import com.pulumi.alicloud.ros.kotlin.inputs.GetStackInstancesPlainArgsBuilder
import com.pulumi.alicloud.ros.kotlin.inputs.GetStacksPlainArgs
import com.pulumi.alicloud.ros.kotlin.inputs.GetStacksPlainArgsBuilder
import com.pulumi.alicloud.ros.kotlin.inputs.GetTemplateScratchesPlainArgs
import com.pulumi.alicloud.ros.kotlin.inputs.GetTemplateScratchesPlainArgsBuilder
import com.pulumi.alicloud.ros.kotlin.inputs.GetTemplatesPlainArgs
import com.pulumi.alicloud.ros.kotlin.inputs.GetTemplatesPlainArgsBuilder
import com.pulumi.alicloud.ros.kotlin.outputs.GetChangeSetsResult
import com.pulumi.alicloud.ros.kotlin.outputs.GetRegionsResult
import com.pulumi.alicloud.ros.kotlin.outputs.GetStackGroupsResult
import com.pulumi.alicloud.ros.kotlin.outputs.GetStackInstancesResult
import com.pulumi.alicloud.ros.kotlin.outputs.GetStacksResult
import com.pulumi.alicloud.ros.kotlin.outputs.GetTemplateScratchesResult
import com.pulumi.alicloud.ros.kotlin.outputs.GetTemplatesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.ros.kotlin.outputs.GetChangeSetsResult.Companion.toKotlin as getChangeSetsResultToKotlin
import com.pulumi.alicloud.ros.kotlin.outputs.GetRegionsResult.Companion.toKotlin as getRegionsResultToKotlin
import com.pulumi.alicloud.ros.kotlin.outputs.GetStackGroupsResult.Companion.toKotlin as getStackGroupsResultToKotlin
import com.pulumi.alicloud.ros.kotlin.outputs.GetStackInstancesResult.Companion.toKotlin as getStackInstancesResultToKotlin
import com.pulumi.alicloud.ros.kotlin.outputs.GetStacksResult.Companion.toKotlin as getStacksResultToKotlin
import com.pulumi.alicloud.ros.kotlin.outputs.GetTemplateScratchesResult.Companion.toKotlin as getTemplateScratchesResultToKotlin
import com.pulumi.alicloud.ros.kotlin.outputs.GetTemplatesResult.Companion.toKotlin as getTemplatesResultToKotlin

public object RosFunctions {
    /**
     * This data source provides the Ros Change Sets of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.105.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ros.getChangeSets({
     *     stackId: "example_value",
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstRosChangeSetId = example.then(example => example.sets?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ros.get_change_sets(stack_id="example_value",
     *     ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstRosChangeSetId", example.sets[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ros.GetChangeSets.Invoke(new()
     *     {
     *         StackId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRosChangeSetId"] = example&#46;Apply(getChangeSetsResult => getChangeSetsResult&#46;Sets[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ros.GetChangeSets(ctx, &ros.GetChangeSetsArgs{
     * 			StackId: "example_value",
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRosChangeSetId", example.Sets[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ros.RosFunctions;
     * import com.pulumi.alicloud.ros.inputs.GetChangeSetsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RosFunctions.getChangeSets(GetChangeSetsArgs.builder()
     *             .stackId("example_value")
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstRosChangeSetId", example.applyValue(getChangeSetsResult -> getChangeSetsResult.sets()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ros:getChangeSets
     *       Arguments:
     *         stackId: example_value
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstRosChangeSetId: ${example.sets[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getChangeSets.
     * @return A collection of values returned by getChangeSets.
     */
    public suspend fun getChangeSets(argument: GetChangeSetsPlainArgs): GetChangeSetsResult =
        getChangeSetsResultToKotlin(getChangeSetsPlain(argument.toJava()).await())

    /**
     * @see [getChangeSets].
     * @param changeSetName The name of the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Change Set IDs.
     * @param nameRegex A regex string to filter results by Change Set name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param stackId The ID of the stack for which you want to create the change set. ROS generates the change set by comparing the stack information with the information that you submit, such as a modified template or different inputs.
     * @param status The status of the change set. Valid Value: `CREATE_COMPLETE`, `CREATE_FAILED`, `CREATE_IN_PROGRESS`, `CREATE_PENDING`, `DELETE_COMPLETE` and `DELETE_FAILED`.
     * @return A collection of values returned by getChangeSets.
     */
    public suspend fun getChangeSets(
        changeSetName: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        stackId: String,
        status: String? = null,
    ): GetChangeSetsResult {
        val argument = GetChangeSetsPlainArgs(
            changeSetName = changeSetName,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            stackId = stackId,
            status = status,
        )
        return getChangeSetsResultToKotlin(getChangeSetsPlain(argument.toJava()).await())
    }

    /**
     * @see [getChangeSets].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ros&#46;kotlin&#46;inputs&#46;GetChangeSetsPlainArgs].
     * @return A collection of values returned by getChangeSets.
     */
    public suspend fun getChangeSets(argument: suspend GetChangeSetsPlainArgsBuilder.() -> Unit): GetChangeSetsResult {
        val builder = GetChangeSetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getChangeSetsResultToKotlin(getChangeSetsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ros Regions of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.145.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const all = alicloud.ros.getRegions({});
     * export const rosRegionRegionId1 = all.then(all => all.regions?.[0]?.regionId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * all = alicloud.ros.get_regions()
     * pulumi.export("rosRegionRegionId1", all.regions[0].region_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var all = AliCloud.Ros.GetRegions.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["rosRegionRegionId1"] = all&#46;Apply(getRegionsResult => getRegionsResult&#46;Regions[0]?.RegionId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		all, err := ros.GetRegions(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("rosRegionRegionId1", all.Regions[0].RegionId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ros.RosFunctions;
     * import com.pulumi.alicloud.ros.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var all = RosFunctions.getRegions();
     *         ctx.export("rosRegionRegionId1", all.applyValue(getRegionsResult -> getRegionsResult.regions()[0].regionId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   all:
     *     fn::invoke:
     *       Function: alicloud:ros:getRegions
     *       Arguments: {}
     * outputs:
     *   rosRegionRegionId1: ${all.regions[0].regionId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRegions.
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(argument: GetRegionsPlainArgs): GetRegionsResult =
        getRegionsResultToKotlin(getRegionsPlain(argument.toJava()).await())

    /**
     * @see [getRegions].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(outputFile: String? = null): GetRegionsResult {
        val argument = GetRegionsPlainArgs(
            outputFile = outputFile,
        )
        return getRegionsResultToKotlin(getRegionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ros&#46;kotlin&#46;inputs&#46;GetRegionsPlainArgs].
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(argument: suspend GetRegionsPlainArgsBuilder.() -> Unit): GetRegionsResult {
        val builder = GetRegionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegionsResultToKotlin(getRegionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ros Stack Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.107.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ros.getStackGroups({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstRosStackGroupId = example.then(example => example.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ros.get_stack_groups(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstRosStackGroupId", example.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ros.GetStackGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRosStackGroupId"] = example&#46;Apply(getStackGroupsResult => getStackGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ros.GetStackGroups(ctx, &ros.GetStackGroupsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRosStackGroupId", example.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ros.RosFunctions;
     * import com.pulumi.alicloud.ros.inputs.GetStackGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RosFunctions.getStackGroups(GetStackGroupsArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstRosStackGroupId", example.applyValue(getStackGroupsResult -> getStackGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ros:getStackGroups
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstRosStackGroupId: ${example.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getStackGroups.
     * @return A collection of values returned by getStackGroups.
     */
    public suspend fun getStackGroups(argument: GetStackGroupsPlainArgs): GetStackGroupsResult =
        getStackGroupsResultToKotlin(getStackGroupsPlain(argument.toJava()).await())

    /**
     * @see [getStackGroups].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Stack Group IDs.
     * @param nameRegex A regex string to filter results by Stack Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of Stack Group. Valid Values: `ACTIVE`, `DELETED`.
     * @return A collection of values returned by getStackGroups.
     */
    public suspend fun getStackGroups(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetStackGroupsResult {
        val argument = GetStackGroupsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getStackGroupsResultToKotlin(getStackGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getStackGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ros&#46;kotlin&#46;inputs&#46;GetStackGroupsPlainArgs].
     * @return A collection of values returned by getStackGroups.
     */
    public suspend fun getStackGroups(argument: suspend GetStackGroupsPlainArgsBuilder.() -> Unit): GetStackGroupsResult {
        val builder = GetStackGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStackGroupsResultToKotlin(getStackGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ros Stack Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.145.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ros.getStackInstances({
     *     stackGroupName: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     enableDetails: true,
     * });
     * export const rosStackInstanceId1 = ids.then(ids => ids.instances?.[0]?.id);
     * const status = alicloud.ros.getStackInstances({
     *     stackGroupName: "example_value",
     *     status: "CURRENT",
     *     enableDetails: true,
     * });
     * export const rosStackInstanceId2 = status.then(status => status.instances?.[0]?.id);
     * const regionId = alicloud.ros.getStackInstances({
     *     stackGroupName: "example_value",
     *     stackInstanceRegionId: "example_value",
     *     enableDetails: true,
     * });
     * export const rosStackInstanceId3 = regionId.then(regionId => regionId.instances?.[0]?.id);
     * const accountId = alicloud.ros.getStackInstances({
     *     stackGroupName: "example_value",
     *     stackInstanceAccountId: "example_value",
     *     enableDetails: true,
     * });
     * export const rosStackInstanceId4 = accountId.then(accountId => accountId.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ros.get_stack_instances(stack_group_name="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     enable_details=True)
     * pulumi.export("rosStackInstanceId1", ids.instances[0].id)
     * status = alicloud.ros.get_stack_instances(stack_group_name="example_value",
     *     status="CURRENT",
     *     enable_details=True)
     * pulumi.export("rosStackInstanceId2", status.instances[0].id)
     * region_id = alicloud.ros.get_stack_instances(stack_group_name="example_value",
     *     stack_instance_region_id="example_value",
     *     enable_details=True)
     * pulumi.export("rosStackInstanceId3", region_id.instances[0].id)
     * account_id = alicloud.ros.get_stack_instances(stack_group_name="example_value",
     *     stack_instance_account_id="example_value",
     *     enable_details=True)
     * pulumi.export("rosStackInstanceId4", account_id.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ros.GetStackInstances.Invoke(new()
     *     {
     *         StackGroupName = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *         EnableDetails = true,
     *     });
     *     var status = AliCloud.Ros.GetStackInstances.Invoke(new()
     *     {
     *         StackGroupName = "example_value",
     *         Status = "CURRENT",
     *         EnableDetails = true,
     *     });
     *     var regionId = AliCloud.Ros.GetStackInstances.Invoke(new()
     *     {
     *         StackGroupName = "example_value",
     *         StackInstanceRegionId = "example_value",
     *         EnableDetails = true,
     *     });
     *     var accountId = AliCloud.Ros.GetStackInstances.Invoke(new()
     *     {
     *         StackGroupName = "example_value",
     *         StackInstanceAccountId = "example_value",
     *         EnableDetails = true,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["rosStackInstanceId1"] = ids&#46;Apply(getStackInstancesResult => getStackInstancesResult&#46;Instances[0]?.Id),
     *         ["rosStackInstanceId2"] = status&#46;Apply(getStackInstancesResult => getStackInstancesResult&#46;Instances[0]?.Id),
     *         ["rosStackInstanceId3"] = regionId&#46;Apply(getStackInstancesResult => getStackInstancesResult&#46;Instances[0]?.Id),
     *         ["rosStackInstanceId4"] = accountId&#46;Apply(getStackInstancesResult => getStackInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ros.GetStackInstances(ctx, &ros.GetStackInstancesArgs{
     * 			StackGroupName: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 			EnableDetails: pulumi.BoolRef(true),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("rosStackInstanceId1", ids.Instances[0].Id)
     * 		status, err := ros.GetStackInstances(ctx, &ros.GetStackInstancesArgs{
     * 			StackGroupName: "example_value",
     * 			Status:         pulumi.StringRef("CURRENT"),
     * 			EnableDetails:  pulumi.BoolRef(true),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("rosStackInstanceId2", status.Instances[0].Id)
     * 		regionId, err := ros.GetStackInstances(ctx, &ros.GetStackInstancesArgs{
     * 			StackGroupName:        "example_value",
     * 			StackInstanceRegionId: pulumi.StringRef("example_value"),
     * 			EnableDetails:         pulumi.BoolRef(true),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("rosStackInstanceId3", regionId.Instances[0].Id)
     * 		accountId, err := ros.GetStackInstances(ctx, &ros.GetStackInstancesArgs{
     * 			StackGroupName:         "example_value",
     * 			StackInstanceAccountId: pulumi.StringRef("example_value"),
     * 			EnableDetails:          pulumi.BoolRef(true),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("rosStackInstanceId4", accountId.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ros.RosFunctions;
     * import com.pulumi.alicloud.ros.inputs.GetStackInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = RosFunctions.getStackInstances(GetStackInstancesArgs.builder()
     *             .stackGroupName("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .enableDetails(true)
     *             .build());
     *         ctx.export("rosStackInstanceId1", ids.applyValue(getStackInstancesResult -> getStackInstancesResult.instances()[0].id()));
     *         final var status = RosFunctions.getStackInstances(GetStackInstancesArgs.builder()
     *             .stackGroupName("example_value")
     *             .status("CURRENT")
     *             .enableDetails(true)
     *             .build());
     *         ctx.export("rosStackInstanceId2", status.applyValue(getStackInstancesResult -> getStackInstancesResult.instances()[0].id()));
     *         final var regionId = RosFunctions.getStackInstances(GetStackInstancesArgs.builder()
     *             .stackGroupName("example_value")
     *             .stackInstanceRegionId("example_value")
     *             .enableDetails(true)
     *             .build());
     *         ctx.export("rosStackInstanceId3", regionId.applyValue(getStackInstancesResult -> getStackInstancesResult.instances()[0].id()));
     *         final var accountId = RosFunctions.getStackInstances(GetStackInstancesArgs.builder()
     *             .stackGroupName("example_value")
     *             .stackInstanceAccountId("example_value")
     *             .enableDetails(true)
     *             .build());
     *         ctx.export("rosStackInstanceId4", accountId.applyValue(getStackInstancesResult -> getStackInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ros:getStackInstances
     *       Arguments:
     *         stackGroupName: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *         enableDetails: true
     *   status:
     *     fn::invoke:
     *       Function: alicloud:ros:getStackInstances
     *       Arguments:
     *         stackGroupName: example_value
     *         status: CURRENT
     *         enableDetails: true
     *   regionId:
     *     fn::invoke:
     *       Function: alicloud:ros:getStackInstances
     *       Arguments:
     *         stackGroupName: example_value
     *         stackInstanceRegionId: example_value
     *         enableDetails: true
     *   accountId:
     *     fn::invoke:
     *       Function: alicloud:ros:getStackInstances
     *       Arguments:
     *         stackGroupName: example_value
     *         stackInstanceAccountId: example_value
     *         enableDetails: true
     * outputs:
     *   rosStackInstanceId1: ${ids.instances[0].id}
     *   rosStackInstanceId2: ${status.instances[0].id}
     *   rosStackInstanceId3: ${regionId.instances[0].id}
     *   rosStackInstanceId4: ${accountId.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getStackInstances.
     * @return A collection of values returned by getStackInstances.
     */
    public suspend fun getStackInstances(argument: GetStackInstancesPlainArgs): GetStackInstancesResult =
        getStackInstancesResultToKotlin(getStackInstancesPlain(argument.toJava()).await())

    /**
     * @see [getStackInstances].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Stack Instance IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param stackGroupName The name of the stack group.
     * @param stackInstanceAccountId The account to which the stack instance belongs.
     * @param stackInstanceRegionId The region of the stack instance.
     * @param status The status of the stack instance. Valid values: `CURRENT` or `OUTDATED`.
     * * `CURRENT`: The stack corresponding to the stack instance is up to date with the stack group.
     * * `OUTDATED`: The stack corresponding to the stack instance is not up to date with the stack group. The `OUTDATED` state has the following possible causes:
     * * When the CreateStackInstances operation is called to create stack instances, the corresponding stacks fail to be created.
     * * When the UpdateStackInstances or UpdateStackGroup operation is called to update stack instances, the corresponding stacks fail to be updated, or only some of the stack instances are updated.
     * * The create or update operation is not complete.
     * @return A collection of values returned by getStackInstances.
     */
    public suspend fun getStackInstances(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        stackGroupName: String,
        stackInstanceAccountId: String? = null,
        stackInstanceRegionId: String? = null,
        status: String? = null,
    ): GetStackInstancesResult {
        val argument = GetStackInstancesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            outputFile = outputFile,
            stackGroupName = stackGroupName,
            stackInstanceAccountId = stackInstanceAccountId,
            stackInstanceRegionId = stackInstanceRegionId,
            status = status,
        )
        return getStackInstancesResultToKotlin(getStackInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getStackInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ros&#46;kotlin&#46;inputs&#46;GetStackInstancesPlainArgs].
     * @return A collection of values returned by getStackInstances.
     */
    public suspend fun getStackInstances(argument: suspend GetStackInstancesPlainArgsBuilder.() -> Unit): GetStackInstancesResult {
        val builder = GetStackInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStackInstancesResultToKotlin(getStackInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ros Stacks of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.106.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ros.getStacks({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstRosStackId = example.then(example => example.stacks?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ros.get_stacks(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstRosStackId", example.stacks[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ros.GetStacks.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRosStackId"] = example&#46;Apply(getStacksResult => getStacksResult&#46;Stacks[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ros.GetStacks(ctx, &ros.GetStacksArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRosStackId", example.Stacks[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ros.RosFunctions;
     * import com.pulumi.alicloud.ros.inputs.GetStacksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RosFunctions.getStacks(GetStacksArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstRosStackId", example.applyValue(getStacksResult -> getStacksResult.stacks()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ros:getStacks
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstRosStackId: ${example.stacks[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getStacks.
     * @return A collection of values returned by getStacks.
     */
    public suspend fun getStacks(argument: GetStacksPlainArgs): GetStacksResult =
        getStacksResultToKotlin(getStacksPlain(argument.toJava()).await())

    /**
     * @see [getStacks].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Stack IDs.
     * @param nameRegex A regex string to filter results by Stack name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param parentStackId ParentStackId.
     * @param showNestedStack The show nested stack.
     * @param stackName StackName.
     * @param status The status of Stack. Valid Values: `CREATE_COMPLETE`, `CREATE_FAILED`, `CREATE_IN_PROGRESS`, `DELETE_COMPLETE`, `DELETE_FAILED`, `DELETE_IN_PROGRESS`, `ROLLBACK_COMPLETE`, `ROLLBACK_FAILED`, `ROLLBACK_IN_PROGRESS`.
     * @param tags Query the instance bound to the tag. The format of the incoming value is `json` string, including `TagKey` and `TagValue`. `TagKey` cannot be null, and `TagValue` can be empty. Format example `{"key1":"value1"}`.
     * @return A collection of values returned by getStacks.
     */
    public suspend fun getStacks(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        parentStackId: String? = null,
        showNestedStack: Boolean? = null,
        stackName: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetStacksResult {
        val argument = GetStacksPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            parentStackId = parentStackId,
            showNestedStack = showNestedStack,
            stackName = stackName,
            status = status,
            tags = tags,
        )
        return getStacksResultToKotlin(getStacksPlain(argument.toJava()).await())
    }

    /**
     * @see [getStacks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ros&#46;kotlin&#46;inputs&#46;GetStacksPlainArgs].
     * @return A collection of values returned by getStacks.
     */
    public suspend fun getStacks(argument: suspend GetStacksPlainArgsBuilder.() -> Unit): GetStacksResult {
        val builder = GetStacksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStacksResultToKotlin(getStacksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ros Template Scratches of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.151.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.ros.getTemplateScratches({
     *     ids: ["example_value"],
     * });
     * export const rosTemplateScratchId1 = ids.then(ids => ids.scratches?.[0]?.id);
     * const status = alicloud.ros.getTemplateScratches({
     *     status: "GENERATE_COMPLETE",
     * });
     * export const rosTemplateScratchId2 = status.then(status => status.scratches?.[0]?.id);
     * const templateScratchType = alicloud.ros.getTemplateScratches({
     *     templateScratchType: "ResourceImport",
     * });
     * export const rosTemplateScratchId3 = templateScratchType.then(templateScratchType => templateScratchType.scratches?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.ros.get_template_scratches(ids=["example_value"])
     * pulumi.export("rosTemplateScratchId1", ids.scratches[0].id)
     * status = alicloud.ros.get_template_scratches(status="GENERATE_COMPLETE")
     * pulumi.export("rosTemplateScratchId2", status.scratches[0].id)
     * template_scratch_type = alicloud.ros.get_template_scratches(template_scratch_type="ResourceImport")
     * pulumi.export("rosTemplateScratchId3", template_scratch_type.scratches[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Ros.GetTemplateScratches.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     var status = AliCloud.Ros.GetTemplateScratches.Invoke(new()
     *     {
     *         Status = "GENERATE_COMPLETE",
     *     });
     *     var templateScratchType = AliCloud.Ros.GetTemplateScratches.Invoke(new()
     *     {
     *         TemplateScratchType = "ResourceImport",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["rosTemplateScratchId1"] = ids&#46;Apply(getTemplateScratchesResult => getTemplateScratchesResult&#46;Scratches[0]?.Id),
     *         ["rosTemplateScratchId2"] = status&#46;Apply(getTemplateScratchesResult => getTemplateScratchesResult&#46;Scratches[0]?.Id),
     *         ["rosTemplateScratchId3"] = templateScratchType&#46;Apply(getTemplateScratchesResult => getTemplateScratchesResult&#46;Scratches[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := ros.GetTemplateScratches(ctx, &ros.GetTemplateScratchesArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("rosTemplateScratchId1", ids.Scratches[0].Id)
     * 		status, err := ros.GetTemplateScratches(ctx, &ros.GetTemplateScratchesArgs{
     * 			Status: pulumi.StringRef("GENERATE_COMPLETE"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("rosTemplateScratchId2", status.Scratches[0].Id)
     * 		templateScratchType, err := ros.GetTemplateScratches(ctx, &ros.GetTemplateScratchesArgs{
     * 			TemplateScratchType: pulumi.StringRef("ResourceImport"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("rosTemplateScratchId3", templateScratchType.Scratches[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ros.RosFunctions;
     * import com.pulumi.alicloud.ros.inputs.GetTemplateScratchesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = RosFunctions.getTemplateScratches(GetTemplateScratchesArgs.builder()
     *             .ids("example_value")
     *             .build());
     *         ctx.export("rosTemplateScratchId1", ids.applyValue(getTemplateScratchesResult -> getTemplateScratchesResult.scratches()[0].id()));
     *         final var status = RosFunctions.getTemplateScratches(GetTemplateScratchesArgs.builder()
     *             .status("GENERATE_COMPLETE")
     *             .build());
     *         ctx.export("rosTemplateScratchId2", status.applyValue(getTemplateScratchesResult -> getTemplateScratchesResult.scratches()[0].id()));
     *         final var templateScratchType = RosFunctions.getTemplateScratches(GetTemplateScratchesArgs.builder()
     *             .templateScratchType("ResourceImport")
     *             .build());
     *         ctx.export("rosTemplateScratchId3", templateScratchType.applyValue(getTemplateScratchesResult -> getTemplateScratchesResult.scratches()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:ros:getTemplateScratches
     *       Arguments:
     *         ids:
     *           - example_value
     *   status:
     *     fn::invoke:
     *       Function: alicloud:ros:getTemplateScratches
     *       Arguments:
     *         status: GENERATE_COMPLETE
     *   templateScratchType:
     *     fn::invoke:
     *       Function: alicloud:ros:getTemplateScratches
     *       Arguments:
     *         templateScratchType: ResourceImport
     * outputs:
     *   rosTemplateScratchId1: ${ids.scratches[0].id}
     *   rosTemplateScratchId2: ${status.scratches[0].id}
     *   rosTemplateScratchId3: ${templateScratchType.scratches[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTemplateScratches.
     * @return A collection of values returned by getTemplateScratches.
     */
    public suspend fun getTemplateScratches(argument: GetTemplateScratchesPlainArgs): GetTemplateScratchesResult =
        getTemplateScratchesResultToKotlin(getTemplateScratchesPlain(argument.toJava()).await())

    /**
     * @see [getTemplateScratches].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Template Scratch IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid Values: `GENERATE_IN_PROGRESS`, `GENERATE_COMPLETE` and `GENERATE_FAILED`.
     * @param templateScratchType The type of the template scratch. Valid Values: `ResourceImport`, `ArchitectureReplication`.
     * @return A collection of values returned by getTemplateScratches.
     */
    public suspend fun getTemplateScratches(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
        templateScratchType: String? = null,
    ): GetTemplateScratchesResult {
        val argument = GetTemplateScratchesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            outputFile = outputFile,
            status = status,
            templateScratchType = templateScratchType,
        )
        return getTemplateScratchesResultToKotlin(getTemplateScratchesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTemplateScratches].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ros&#46;kotlin&#46;inputs&#46;GetTemplateScratchesPlainArgs].
     * @return A collection of values returned by getTemplateScratches.
     */
    public suspend fun getTemplateScratches(argument: suspend GetTemplateScratchesPlainArgsBuilder.() -> Unit): GetTemplateScratchesResult {
        val builder = GetTemplateScratchesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTemplateScratchesResultToKotlin(getTemplateScratchesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ros Templates of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.108.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.ros.getTemplates({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstRosTemplateId = example.then(example => example.templates?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.ros.get_templates(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstRosTemplateId", example.templates[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Ros.GetTemplates.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRosTemplateId"] = example&#46;Apply(getTemplatesResult => getTemplatesResult&#46;Templates[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ros.GetTemplates(ctx, &ros.GetTemplatesArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRosTemplateId", example.Templates[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ros.RosFunctions;
     * import com.pulumi.alicloud.ros.inputs.GetTemplatesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RosFunctions.getTemplates(GetTemplatesArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstRosTemplateId", example.applyValue(getTemplatesResult -> getTemplatesResult.templates()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:ros:getTemplates
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstRosTemplateId: ${example.templates[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTemplates.
     * @return A collection of values returned by getTemplates.
     */
    public suspend fun getTemplates(argument: GetTemplatesPlainArgs): GetTemplatesResult =
        getTemplatesResultToKotlin(getTemplatesPlain(argument.toJava()).await())

    /**
     * @see [getTemplates].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Template IDs.
     * @param nameRegex A regex string to filter results by Template name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param shareType Share Type. Valid Values: `Private`, `Shared`
     * @param tags Query the resource bound to the tag. The format of the incoming value is `json` string, including `TagKey` and `TagValue`. `TagKey` cannot be null, and `TagValue` can be empty. Format example `{"key1":"value1"}`.
     * @param templateName The name of the template.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
     * @return A collection of values returned by getTemplates.
     */
    public suspend fun getTemplates(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        shareType: String? = null,
        tags: Map<String, String>? = null,
        templateName: String? = null,
    ): GetTemplatesResult {
        val argument = GetTemplatesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            shareType = shareType,
            tags = tags,
            templateName = templateName,
        )
        return getTemplatesResultToKotlin(getTemplatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTemplates].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ros&#46;kotlin&#46;inputs&#46;GetTemplatesPlainArgs].
     * @return A collection of values returned by getTemplates.
     */
    public suspend fun getTemplates(argument: suspend GetTemplatesPlainArgsBuilder.() -> Unit): GetTemplatesResult {
        val builder = GetTemplatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTemplatesResultToKotlin(getTemplatesPlain(builtArgument.toJava()).await())
    }
}
