@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin

import com.pulumi.alicloud.ros.kotlin.outputs.StackParameter
import com.pulumi.alicloud.ros.kotlin.outputs.StackParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Stack].
 */
@PulumiTagMarker
public class StackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StackArgs = StackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StackArgsBuilder.() -> Unit) {
        val builder = StackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Stack {
        val builtJavaResource = com.pulumi.alicloud.ros.Stack(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Stack(builtJavaResource)
    }
}

/**
 * Provides a ROS Stack resource.
 * For information about ROS Stack and how to use it, see [What is Stack](https://www.alibabacloud.com/help/en/doc-detail/132086.htm).
 * > **NOTE:** Available in v1.106.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ros.Stack("example", {
 *     stackName: "tf-testaccstack",
 *     templateBody: `    {
 *     \x09"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 * `,
 *     stackPolicyBody: `    {
 *     \x09"Statement": [{
 *     \x09\x09"Action": "Update:Delete",
 *     \x09\x09"Resource": "*",
 *     \x09\x09"Effect": "Allow",
 *     \x09\x09"Principal": "*"
 *     \x09}]
 *     }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ros.Stack("example",
 *     stack_name="tf-testaccstack",
 *     template_body="""    {
 *     \x09"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 * """,
 *     stack_policy_body="""    {
 *     \x09"Statement": [{
 *     \x09\x09"Action": "Update:Delete",
 *     \x09\x09"Resource": "*",
 *     \x09\x09"Effect": "Allow",
 *     \x09\x09"Principal": "*"
 *     \x09}]
 *     }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ros.Stack("example", new()
 *     {
 *         StackName = "tf-testaccstack",
 *         TemplateBody = @"    {
 *     	""ROSTemplateFormatVersion"": ""2015-09-01""
 *     }
 * ",
 *         StackPolicyBody = @"    {
 *     	""Statement"": [{
 *     		""Action"": ""Update:Delete"",
 *     		""Resource"": ""*"",
 *     		""Effect"": ""Allow"",
 *     		""Principal"": ""*""
 *     	}]
 *     }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ros.NewStack(ctx, "example", &ros.StackArgs{
 * 			StackName:    pulumi.String("tf-testaccstack"),
 * 			TemplateBody: pulumi.String("    {\n    	\"ROSTemplateFormatVersion\": \"2015-09-01\"\n    }\n"),
 * 			StackPolicyBody: pulumi.String(`    {
 *     	"Statement": [{
 *     		"Action": "Update:Delete",
 *     		"Resource": "*",
 *     		"Effect": "Allow",
 *     		"Principal": "*"
 *     	}]
 *     }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ros.Stack;
 * import com.pulumi.alicloud.ros.StackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Stack("example", StackArgs.builder()
 *             .stackName("tf-testaccstack")
 *             .templateBody("""
 *     {
 *     	"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 *             """)
 *             .stackPolicyBody("""
 *     {
 *     	"Statement": [{
 *     		"Action": "Update:Delete",
 *     		"Resource": "*",
 *     		"Effect": "Allow",
 *     		"Principal": "*"
 *     	}]
 *     }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ros:Stack
 *     properties:
 *       stackName: tf-testaccstack
 *       templateBody: |2
 *             {
 *             	"ROSTemplateFormatVersion": "2015-09-01"
 *             }
 *       stackPolicyBody: |2
 *             {
 *             	"Statement": [{
 *             		"Action": "Update:Delete",
 *             		"Resource": "*",
 *             		"Effect": "Allow",
 *             		"Principal": "*"
 *             	}]
 *             }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ROS Stack can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ros/stack:Stack example <stack_id>
 * ```
 */
public class Stack internal constructor(
    override val javaResource: com.pulumi.alicloud.ros.Stack,
) : KotlinCustomResource(javaResource, StackMapper) {
    /**
     * Specifies whether to delete the stack after it is created.
     */
    public val createOption: Output<String>?
        get() = javaResource.createOption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to enable deletion protection on the stack. Valid values: `Disabled`, `Enabled`. Default to: `Disabled`
     */
    public val deletionProtection: Output<String>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to disable rollback on stack creation failure. Default to: `false`.
     */
    public val disableRollback: Output<Boolean>?
        get() = javaResource.disableRollback().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The callback URL for receiving stack event N. Only HTTP POST is supported. Maximum value of N: 5.
     */
    public val notificationUrls: Output<List<String>>?
        get() = javaResource.notificationUrls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    public val parameters: Output<List<StackParameter>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the RAM role. ROS assumes the specified RAM role to create the stack and call API operations by using the credentials of the role.
     */
    public val ramRoleName: Output<String>?
        get() = javaResource.ramRoleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to enable replacement update after a resource attribute that does not support modification update is changed. Modification update keeps the physical ID of the resource unchanged. However, the resource is deleted and then recreated, and its physical ID is changed if replacement update is enabled.
     */
    public val replacementOption: Output<String>?
        get() = javaResource.replacementOption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The retain all resources.
     */
    public val retainAllResources: Output<Boolean>?
        get() = javaResource.retainAllResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to retain the resources in the stack.
     */
    public val retainResources: Output<List<String>>?
        get() = javaResource.retainResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
     */
    public val stackName: Output<String>
        get() = javaResource.stackName().applyValue({ args0 -> args0 })

    /**
     * The structure that contains the stack policy body. The stack policy body must be 1 to 16,384 bytes in length.
     */
    public val stackPolicyBody: Output<String>?
        get() = javaResource.stackPolicyBody().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The structure that contains the body of the temporary overriding stack policy. The stack policy body must be 1 to 16,384 bytes in length.
     */
    public val stackPolicyDuringUpdateBody: Output<String>?
        get() = javaResource.stackPolicyDuringUpdateBody().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The URL of the file that contains the temporary overriding stack policy. The URL must point to a policy located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/stack-policy/demo and oss://ros/stack-policy/demo?RegionId=cn-hangzhou. The policy can be up to 16,384 bytes in length and the URL can be up to 1,350 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
     */
    public val stackPolicyDuringUpdateUrl: Output<String>?
        get() = javaResource.stackPolicyDuringUpdateUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The URL of the file that contains the stack policy. The URL must point to a policy located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/stack-policy/demo and oss://ros/stack-policy/demo?RegionId=cn-hangzhou. The policy can be up to 16,384 bytes in length and the URL can be up to 1,350 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
     */
    public val stackPolicyUrl: Output<String>?
        get() = javaResource.stackPolicyUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of Stack.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
     */
    public val templateBody: Output<String>?
        get() = javaResource.templateBody().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
     */
    public val templateUrl: Output<String>?
        get() = javaResource.templateUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version of the template.
     */
    public val templateVersion: Output<String>?
        get() = javaResource.templateVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The timeout period that is specified for the stack creation request. Default to: `60`.
     */
    public val timeoutInMinutes: Output<Int>?
        get() = javaResource.timeoutInMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to use the values that were passed last time for the parameters that you do not specify in the current request.
     */
    public val usePreviousParameters: Output<Boolean>?
        get() = javaResource.usePreviousParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object StackMapper : ResourceMapper<Stack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ros.Stack::class == javaResource::class

    override fun map(javaResource: Resource): Stack = Stack(
        javaResource as
            com.pulumi.alicloud.ros.Stack,
    )
}

/**
 * @see [Stack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Stack].
 */
public suspend fun stack(name: String, block: suspend StackResourceBuilder.() -> Unit): Stack {
    val builder = StackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Stack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun stack(name: String): Stack {
    val builder = StackResourceBuilder()
    builder.name(name)
    return builder.build()
}
