@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin

import com.pulumi.alicloud.ros.StackArgs.builder
import com.pulumi.alicloud.ros.kotlin.inputs.StackParameterArgs
import com.pulumi.alicloud.ros.kotlin.inputs.StackParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ROS Stack resource.
 * For information about ROS Stack and how to use it, see [What is Stack](https://www.alibabacloud.com/help/en/doc-detail/132086.htm).
 * > **NOTE:** Available in v1.106.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ros.Stack("example", {
 *     stackName: "tf-testaccstack",
 *     templateBody: `    {
 *     \x09"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 * `,
 *     stackPolicyBody: `    {
 *     \x09"Statement": [{
 *     \x09\x09"Action": "Update:Delete",
 *     \x09\x09"Resource": "*",
 *     \x09\x09"Effect": "Allow",
 *     \x09\x09"Principal": "*"
 *     \x09}]
 *     }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ros.Stack("example",
 *     stack_name="tf-testaccstack",
 *     template_body="""    {
 *     \x09"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 * """,
 *     stack_policy_body="""    {
 *     \x09"Statement": [{
 *     \x09\x09"Action": "Update:Delete",
 *     \x09\x09"Resource": "*",
 *     \x09\x09"Effect": "Allow",
 *     \x09\x09"Principal": "*"
 *     \x09}]
 *     }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ros.Stack("example", new()
 *     {
 *         StackName = "tf-testaccstack",
 *         TemplateBody = @"    {
 *     	""ROSTemplateFormatVersion"": ""2015-09-01""
 *     }
 * ",
 *         StackPolicyBody = @"    {
 *     	""Statement"": [{
 *     		""Action"": ""Update:Delete"",
 *     		""Resource"": ""*"",
 *     		""Effect"": ""Allow"",
 *     		""Principal"": ""*""
 *     	}]
 *     }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ros.NewStack(ctx, "example", &ros.StackArgs{
 * 			StackName:    pulumi.String("tf-testaccstack"),
 * 			TemplateBody: pulumi.String("    {\n    	\"ROSTemplateFormatVersion\": \"2015-09-01\"\n    }\n"),
 * 			StackPolicyBody: pulumi.String(`    {
 *     	"Statement": [{
 *     		"Action": "Update:Delete",
 *     		"Resource": "*",
 *     		"Effect": "Allow",
 *     		"Principal": "*"
 *     	}]
 *     }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ros.Stack;
 * import com.pulumi.alicloud.ros.StackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Stack("example", StackArgs.builder()
 *             .stackName("tf-testaccstack")
 *             .templateBody("""
 *     {
 *     	"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 *             """)
 *             .stackPolicyBody("""
 *     {
 *     	"Statement": [{
 *     		"Action": "Update:Delete",
 *     		"Resource": "*",
 *     		"Effect": "Allow",
 *     		"Principal": "*"
 *     	}]
 *     }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ros:Stack
 *     properties:
 *       stackName: tf-testaccstack
 *       templateBody: |2
 *             {
 *             	"ROSTemplateFormatVersion": "2015-09-01"
 *             }
 *       stackPolicyBody: |2
 *             {
 *             	"Statement": [{
 *             		"Action": "Update:Delete",
 *             		"Resource": "*",
 *             		"Effect": "Allow",
 *             		"Principal": "*"
 *             	}]
 *             }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ROS Stack can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ros/stack:Stack example <stack_id>
 * ```
 * @property createOption Specifies whether to delete the stack after it is created.
 * @property deletionProtection Specifies whether to enable deletion protection on the stack. Valid values: `Disabled`, `Enabled`. Default to: `Disabled`
 * @property disableRollback Specifies whether to disable rollback on stack creation failure. Default to: `false`.
 * @property notificationUrls The callback URL for receiving stack event N. Only HTTP POST is supported. Maximum value of N: 5.
 * @property parameters The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
 * @property ramRoleName The name of the RAM role. ROS assumes the specified RAM role to create the stack and call API operations by using the credentials of the role.
 * @property replacementOption Specifies whether to enable replacement update after a resource attribute that does not support modification update is changed. Modification update keeps the physical ID of the resource unchanged. However, the resource is deleted and then recreated, and its physical ID is changed if replacement update is enabled.
 * @property retainAllResources The retain all resources.
 * @property retainResources Specifies whether to retain the resources in the stack.
 * @property stackName The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
 * @property stackPolicyBody The structure that contains the stack policy body. The stack policy body must be 1 to 16,384 bytes in length.
 * @property stackPolicyDuringUpdateBody The structure that contains the body of the temporary overriding stack policy. The stack policy body must be 1 to 16,384 bytes in length.
 * @property stackPolicyDuringUpdateUrl The URL of the file that contains the temporary overriding stack policy. The URL must point to a policy located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/stack-policy/demo and oss://ros/stack-policy/demo?RegionId=cn-hangzhou. The policy can be up to 16,384 bytes in length and the URL can be up to 1,350 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
 * @property stackPolicyUrl The URL of the file that contains the stack policy. The URL must point to a policy located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/stack-policy/demo and oss://ros/stack-policy/demo?RegionId=cn-hangzhou. The policy can be up to 16,384 bytes in length and the URL can be up to 1,350 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
 * @property tags A mapping of tags to assign to the resource.
 * @property templateBody The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
 * @property templateUrl The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
 * @property templateVersion The version of the template.
 * @property timeoutInMinutes The timeout period that is specified for the stack creation request. Default to: `60`.
 * @property usePreviousParameters Specifies whether to use the values that were passed last time for the parameters that you do not specify in the current request.
 */
public data class StackArgs(
    public val createOption: Output<String>? = null,
    public val deletionProtection: Output<String>? = null,
    public val disableRollback: Output<Boolean>? = null,
    public val notificationUrls: Output<List<String>>? = null,
    public val parameters: Output<List<StackParameterArgs>>? = null,
    public val ramRoleName: Output<String>? = null,
    public val replacementOption: Output<String>? = null,
    public val retainAllResources: Output<Boolean>? = null,
    public val retainResources: Output<List<String>>? = null,
    public val stackName: Output<String>? = null,
    public val stackPolicyBody: Output<String>? = null,
    public val stackPolicyDuringUpdateBody: Output<String>? = null,
    public val stackPolicyDuringUpdateUrl: Output<String>? = null,
    public val stackPolicyUrl: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateBody: Output<String>? = null,
    public val templateUrl: Output<String>? = null,
    public val templateVersion: Output<String>? = null,
    public val timeoutInMinutes: Output<Int>? = null,
    public val usePreviousParameters: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.StackArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.StackArgs =
        com.pulumi.alicloud.ros.StackArgs.builder()
            .createOption(createOption?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .disableRollback(disableRollback?.applyValue({ args0 -> args0 }))
            .notificationUrls(notificationUrls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ramRoleName(ramRoleName?.applyValue({ args0 -> args0 }))
            .replacementOption(replacementOption?.applyValue({ args0 -> args0 }))
            .retainAllResources(retainAllResources?.applyValue({ args0 -> args0 }))
            .retainResources(retainResources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .stackName(stackName?.applyValue({ args0 -> args0 }))
            .stackPolicyBody(stackPolicyBody?.applyValue({ args0 -> args0 }))
            .stackPolicyDuringUpdateBody(stackPolicyDuringUpdateBody?.applyValue({ args0 -> args0 }))
            .stackPolicyDuringUpdateUrl(stackPolicyDuringUpdateUrl?.applyValue({ args0 -> args0 }))
            .stackPolicyUrl(stackPolicyUrl?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateBody(templateBody?.applyValue({ args0 -> args0 }))
            .templateUrl(templateUrl?.applyValue({ args0 -> args0 }))
            .templateVersion(templateVersion?.applyValue({ args0 -> args0 }))
            .timeoutInMinutes(timeoutInMinutes?.applyValue({ args0 -> args0 }))
            .usePreviousParameters(usePreviousParameters?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackArgs].
 */
@PulumiTagMarker
public class StackArgsBuilder internal constructor() {
    private var createOption: Output<String>? = null

    private var deletionProtection: Output<String>? = null

    private var disableRollback: Output<Boolean>? = null

    private var notificationUrls: Output<List<String>>? = null

    private var parameters: Output<List<StackParameterArgs>>? = null

    private var ramRoleName: Output<String>? = null

    private var replacementOption: Output<String>? = null

    private var retainAllResources: Output<Boolean>? = null

    private var retainResources: Output<List<String>>? = null

    private var stackName: Output<String>? = null

    private var stackPolicyBody: Output<String>? = null

    private var stackPolicyDuringUpdateBody: Output<String>? = null

    private var stackPolicyDuringUpdateUrl: Output<String>? = null

    private var stackPolicyUrl: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateBody: Output<String>? = null

    private var templateUrl: Output<String>? = null

    private var templateVersion: Output<String>? = null

    private var timeoutInMinutes: Output<Int>? = null

    private var usePreviousParameters: Output<Boolean>? = null

    /**
     * @param value Specifies whether to delete the stack after it is created.
     */
    @JvmName("alygtisnwgkdwqsx")
    public suspend fun createOption(`value`: Output<String>) {
        this.createOption = value
    }

    /**
     * @param value Specifies whether to enable deletion protection on the stack. Valid values: `Disabled`, `Enabled`. Default to: `Disabled`
     */
    @JvmName("tvccnwejnqnhmkxd")
    public suspend fun deletionProtection(`value`: Output<String>) {
        this.deletionProtection = value
    }

    /**
     * @param value Specifies whether to disable rollback on stack creation failure. Default to: `false`.
     */
    @JvmName("dajhfmmbwuxujjrq")
    public suspend fun disableRollback(`value`: Output<Boolean>) {
        this.disableRollback = value
    }

    /**
     * @param value The callback URL for receiving stack event N. Only HTTP POST is supported. Maximum value of N: 5.
     */
    @JvmName("frsxqvioaqpqrlbn")
    public suspend fun notificationUrls(`value`: Output<List<String>>) {
        this.notificationUrls = value
    }

    @JvmName("inqqhgolajnhjiij")
    public suspend fun notificationUrls(vararg values: Output<String>) {
        this.notificationUrls = Output.all(values.asList())
    }

    /**
     * @param values The callback URL for receiving stack event N. Only HTTP POST is supported. Maximum value of N: 5.
     */
    @JvmName("prbneslikvdxgxga")
    public suspend fun notificationUrls(values: List<Output<String>>) {
        this.notificationUrls = Output.all(values)
    }

    /**
     * @param value The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("jjqmlgopvcwqsdhw")
    public suspend fun parameters(`value`: Output<List<StackParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("aghehbivijxxqtnf")
    public suspend fun parameters(vararg values: Output<StackParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("njrdemsomfiihpuu")
    public suspend fun parameters(values: List<Output<StackParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The name of the RAM role. ROS assumes the specified RAM role to create the stack and call API operations by using the credentials of the role.
     */
    @JvmName("mnbnamxeftcrmyen")
    public suspend fun ramRoleName(`value`: Output<String>) {
        this.ramRoleName = value
    }

    /**
     * @param value Specifies whether to enable replacement update after a resource attribute that does not support modification update is changed. Modification update keeps the physical ID of the resource unchanged. However, the resource is deleted and then recreated, and its physical ID is changed if replacement update is enabled.
     */
    @JvmName("diuqbckbkxgsjxtm")
    public suspend fun replacementOption(`value`: Output<String>) {
        this.replacementOption = value
    }

    /**
     * @param value The retain all resources.
     */
    @JvmName("tsdjynmdeiodmiqg")
    public suspend fun retainAllResources(`value`: Output<Boolean>) {
        this.retainAllResources = value
    }

    /**
     * @param value Specifies whether to retain the resources in the stack.
     */
    @JvmName("kbukmunybvsqlprv")
    public suspend fun retainResources(`value`: Output<List<String>>) {
        this.retainResources = value
    }

    @JvmName("mgqisvrxvdhhtnmt")
    public suspend fun retainResources(vararg values: Output<String>) {
        this.retainResources = Output.all(values.asList())
    }

    /**
     * @param values Specifies whether to retain the resources in the stack.
     */
    @JvmName("ixhnfjywiarvxlnc")
    public suspend fun retainResources(values: List<Output<String>>) {
        this.retainResources = Output.all(values)
    }

    /**
     * @param value The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
     */
    @JvmName("bdlhiryuqqoijjmt")
    public suspend fun stackName(`value`: Output<String>) {
        this.stackName = value
    }

    /**
     * @param value The structure that contains the stack policy body. The stack policy body must be 1 to 16,384 bytes in length.
     */
    @JvmName("chulhpdabsudpuoa")
    public suspend fun stackPolicyBody(`value`: Output<String>) {
        this.stackPolicyBody = value
    }

    /**
     * @param value The structure that contains the body of the temporary overriding stack policy. The stack policy body must be 1 to 16,384 bytes in length.
     */
    @JvmName("dgcqlqpmloyidfko")
    public suspend fun stackPolicyDuringUpdateBody(`value`: Output<String>) {
        this.stackPolicyDuringUpdateBody = value
    }

    /**
     * @param value The URL of the file that contains the temporary overriding stack policy. The URL must point to a policy located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/stack-policy/demo and oss://ros/stack-policy/demo?RegionId=cn-hangzhou. The policy can be up to 16,384 bytes in length and the URL can be up to 1,350 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
     */
    @JvmName("hckiiytdrhpjyyfa")
    public suspend fun stackPolicyDuringUpdateUrl(`value`: Output<String>) {
        this.stackPolicyDuringUpdateUrl = value
    }

    /**
     * @param value The URL of the file that contains the stack policy. The URL must point to a policy located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/stack-policy/demo and oss://ros/stack-policy/demo?RegionId=cn-hangzhou. The policy can be up to 16,384 bytes in length and the URL can be up to 1,350 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
     */
    @JvmName("hltssbtgpvtcrccx")
    public suspend fun stackPolicyUrl(`value`: Output<String>) {
        this.stackPolicyUrl = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("cxnqgdpiaywqrqvj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
     */
    @JvmName("yahtsmhbgogmiwqk")
    public suspend fun templateBody(`value`: Output<String>) {
        this.templateBody = value
    }

    /**
     * @param value The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
     */
    @JvmName("fbfxotwhdohajhaa")
    public suspend fun templateUrl(`value`: Output<String>) {
        this.templateUrl = value
    }

    /**
     * @param value The version of the template.
     */
    @JvmName("flonekdgujuxrteg")
    public suspend fun templateVersion(`value`: Output<String>) {
        this.templateVersion = value
    }

    /**
     * @param value The timeout period that is specified for the stack creation request. Default to: `60`.
     */
    @JvmName("qogktywclrpwdunu")
    public suspend fun timeoutInMinutes(`value`: Output<Int>) {
        this.timeoutInMinutes = value
    }

    /**
     * @param value Specifies whether to use the values that were passed last time for the parameters that you do not specify in the current request.
     */
    @JvmName("mnubrmgpmiwnmtsr")
    public suspend fun usePreviousParameters(`value`: Output<Boolean>) {
        this.usePreviousParameters = value
    }

    /**
     * @param value Specifies whether to delete the stack after it is created.
     */
    @JvmName("vaccqogddlmaxpdf")
    public suspend fun createOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value Specifies whether to enable deletion protection on the stack. Valid values: `Disabled`, `Enabled`. Default to: `Disabled`
     */
    @JvmName("xptiqbfibxeucrbh")
    public suspend fun deletionProtection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value Specifies whether to disable rollback on stack creation failure. Default to: `false`.
     */
    @JvmName("egjspdobcjixrpvs")
    public suspend fun disableRollback(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableRollback = mapped
    }

    /**
     * @param value The callback URL for receiving stack event N. Only HTTP POST is supported. Maximum value of N: 5.
     */
    @JvmName("wlyyeosksujhmonq")
    public suspend fun notificationUrls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationUrls = mapped
    }

    /**
     * @param values The callback URL for receiving stack event N. Only HTTP POST is supported. Maximum value of N: 5.
     */
    @JvmName("nhtbtqbltbdysknc")
    public suspend fun notificationUrls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationUrls = mapped
    }

    /**
     * @param value The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("hbtlmoxhwdofhdws")
    public suspend fun parameters(`value`: List<StackParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("ocbwdjvvllfpxgsn")
    public suspend fun parameters(argument: List<suspend StackParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StackParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("gubylynasujwnvfv")
    public suspend fun parameters(vararg argument: suspend StackParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StackParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("evkjioekfystucqg")
    public suspend fun parameters(argument: suspend StackParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StackParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("nijbqchubyejedvy")
    public suspend fun parameters(vararg values: StackParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The name of the RAM role. ROS assumes the specified RAM role to create the stack and call API operations by using the credentials of the role.
     */
    @JvmName("ufdxnvwsvhsykcwk")
    public suspend fun ramRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramRoleName = mapped
    }

    /**
     * @param value Specifies whether to enable replacement update after a resource attribute that does not support modification update is changed. Modification update keeps the physical ID of the resource unchanged. However, the resource is deleted and then recreated, and its physical ID is changed if replacement update is enabled.
     */
    @JvmName("ypfgmdphmnavxojt")
    public suspend fun replacementOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replacementOption = mapped
    }

    /**
     * @param value The retain all resources.
     */
    @JvmName("euerbdqrtrnmpgsb")
    public suspend fun retainAllResources(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainAllResources = mapped
    }

    /**
     * @param value Specifies whether to retain the resources in the stack.
     */
    @JvmName("xiustygfakrrhxop")
    public suspend fun retainResources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainResources = mapped
    }

    /**
     * @param values Specifies whether to retain the resources in the stack.
     */
    @JvmName("qniiiiudgpfrrayq")
    public suspend fun retainResources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retainResources = mapped
    }

    /**
     * @param value The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
     */
    @JvmName("vhvvpmbetvuljkqr")
    public suspend fun stackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackName = mapped
    }

    /**
     * @param value The structure that contains the stack policy body. The stack policy body must be 1 to 16,384 bytes in length.
     */
    @JvmName("sfravicbyawclloo")
    public suspend fun stackPolicyBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackPolicyBody = mapped
    }

    /**
     * @param value The structure that contains the body of the temporary overriding stack policy. The stack policy body must be 1 to 16,384 bytes in length.
     */
    @JvmName("kmcbmphievqxcnkb")
    public suspend fun stackPolicyDuringUpdateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackPolicyDuringUpdateBody = mapped
    }

    /**
     * @param value The URL of the file that contains the temporary overriding stack policy. The URL must point to a policy located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/stack-policy/demo and oss://ros/stack-policy/demo?RegionId=cn-hangzhou. The policy can be up to 16,384 bytes in length and the URL can be up to 1,350 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
     */
    @JvmName("bmgssbvipoqfjttu")
    public suspend fun stackPolicyDuringUpdateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackPolicyDuringUpdateUrl = mapped
    }

    /**
     * @param value The URL of the file that contains the stack policy. The URL must point to a policy located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/stack-policy/demo and oss://ros/stack-policy/demo?RegionId=cn-hangzhou. The policy can be up to 16,384 bytes in length and the URL can be up to 1,350 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
     */
    @JvmName("akncuaqvhxgptfxu")
    public suspend fun stackPolicyUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackPolicyUrl = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ubtlcxibblernhyc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("qoeiyoyevfihtvxv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
     */
    @JvmName("liublyoggpplbqbh")
    public suspend fun templateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateBody = mapped
    }

    /**
     * @param value The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
     */
    @JvmName("njjaahukifvvfssx")
    public suspend fun templateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateUrl = mapped
    }

    /**
     * @param value The version of the template.
     */
    @JvmName("gchbrfqkkwdfwrla")
    public suspend fun templateVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateVersion = mapped
    }

    /**
     * @param value The timeout period that is specified for the stack creation request. Default to: `60`.
     */
    @JvmName("vxavcegkuwttoygh")
    public suspend fun timeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInMinutes = mapped
    }

    /**
     * @param value Specifies whether to use the values that were passed last time for the parameters that you do not specify in the current request.
     */
    @JvmName("iqlscpujdlbluujc")
    public suspend fun usePreviousParameters(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePreviousParameters = mapped
    }

    internal fun build(): StackArgs = StackArgs(
        createOption = createOption,
        deletionProtection = deletionProtection,
        disableRollback = disableRollback,
        notificationUrls = notificationUrls,
        parameters = parameters,
        ramRoleName = ramRoleName,
        replacementOption = replacementOption,
        retainAllResources = retainAllResources,
        retainResources = retainResources,
        stackName = stackName,
        stackPolicyBody = stackPolicyBody,
        stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody,
        stackPolicyDuringUpdateUrl = stackPolicyDuringUpdateUrl,
        stackPolicyUrl = stackPolicyUrl,
        tags = tags,
        templateBody = templateBody,
        templateUrl = templateUrl,
        templateVersion = templateVersion,
        timeoutInMinutes = timeoutInMinutes,
        usePreviousParameters = usePreviousParameters,
    )
}
