@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin

import com.pulumi.alicloud.ros.kotlin.outputs.StackGroupParameter
import com.pulumi.alicloud.ros.kotlin.outputs.StackGroupParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [StackGroup].
 */
@PulumiTagMarker
public class StackGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StackGroupArgs = StackGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StackGroupArgsBuilder.() -> Unit) {
        val builder = StackGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StackGroup {
        val builtJavaResource = com.pulumi.alicloud.ros.StackGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StackGroup(builtJavaResource)
    }
}

/**
 * Provides a ROS Stack Group resource.
 * For information about ROS Stack Group and how to use it, see [What is Stack Group](https://www.alibabacloud.com/help/en/doc-detail/151333.htm).
 * > **NOTE:** Available in v1.107.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ros.StackGroup("example", {
 *     stackGroupName: "example_value",
 *     templateBody: `    {
 *     \x09"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ros.StackGroup("example",
 *     stack_group_name="example_value",
 *     template_body="""    {
 *     \x09"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ros.StackGroup("example", new()
 *     {
 *         StackGroupName = "example_value",
 *         TemplateBody = @"    {
 *     	""ROSTemplateFormatVersion"": ""2015-09-01""
 *     }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ros.NewStackGroup(ctx, "example", &ros.StackGroupArgs{
 * 			StackGroupName: pulumi.String("example_value"),
 * 			TemplateBody:   pulumi.String("    {\n    	\"ROSTemplateFormatVersion\": \"2015-09-01\"\n    }\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ros.StackGroup;
 * import com.pulumi.alicloud.ros.StackGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StackGroup("example", StackGroupArgs.builder()
 *             .stackGroupName("example_value")
 *             .templateBody("""
 *     {
 *     	"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ros:StackGroup
 *     properties:
 *       stackGroupName: example_value
 *       templateBody: |2
 *             {
 *             	"ROSTemplateFormatVersion": "2015-09-01"
 *             }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ROS Stack Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ros/stackGroup:StackGroup example <stack_group_name>
 * ```
 */
public class StackGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.ros.StackGroup,
) : KotlinCustomResource(javaResource, StackGroupMapper) {
    /**
     * The list of target account IDs, in JSON format. A maximum of 20 accounts can be specified.
     */
    public val accountIds: Output<String>?
        get() = javaResource.accountIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the RAM administrator role assumed by ROS. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
     */
    public val administrationRoleName: Output<String>
        get() = javaResource.administrationRoleName().applyValue({ args0 -> args0 })

    /**
     * The description of the stack group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the RAM execution role assumed by the administrator role. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
     */
    public val executionRoleName: Output<String>
        get() = javaResource.executionRoleName().applyValue({ args0 -> args0 })

    /**
     * The description of the operation.
     */
    public val operationDescription: Output<String>?
        get() = javaResource.operationDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The operation settings, in JSON format.
     */
    public val operationPreferences: Output<String>?
        get() = javaResource.operationPreferences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    public val parameters: Output<List<StackGroupParameter>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The list of target regions, in JSON format. A maximum of 20 accounts can be specified.
     */
    public val regionIds: Output<String>?
        get() = javaResource.regionIds().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The id of Stack Group.
     */
    public val stackGroupId: Output<String>
        get() = javaResource.stackGroupId().applyValue({ args0 -> args0 })

    /**
     * The name of the stack group. The name must be unique in a region.
     */
    public val stackGroupName: Output<String>
        get() = javaResource.stackGroupName().applyValue({ args0 -> args0 })

    /**
     * The status of Stack Group.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
     */
    public val templateBody: Output<String>?
        get() = javaResource.templateBody().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
     */
    public val templateUrl: Output<String>?
        get() = javaResource.templateUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version of the template.
     */
    public val templateVersion: Output<String>?
        get() = javaResource.templateVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object StackGroupMapper : ResourceMapper<StackGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ros.StackGroup::class == javaResource::class

    override fun map(javaResource: Resource): StackGroup = StackGroup(
        javaResource as
            com.pulumi.alicloud.ros.StackGroup,
    )
}

/**
 * @see [StackGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StackGroup].
 */
public suspend fun stackGroup(name: String, block: suspend StackGroupResourceBuilder.() -> Unit): StackGroup {
    val builder = StackGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StackGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun stackGroup(name: String): StackGroup {
    val builder = StackGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
