@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin

import com.pulumi.alicloud.ros.StackGroupArgs.builder
import com.pulumi.alicloud.ros.kotlin.inputs.StackGroupParameterArgs
import com.pulumi.alicloud.ros.kotlin.inputs.StackGroupParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a ROS Stack Group resource.
 * For information about ROS Stack Group and how to use it, see [What is Stack Group](https://www.alibabacloud.com/help/en/doc-detail/151333.htm).
 * > **NOTE:** Available in v1.107.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ros.StackGroup("example", {
 *     stackGroupName: "example_value",
 *     templateBody: `    {
 *     \x09"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ros.StackGroup("example",
 *     stack_group_name="example_value",
 *     template_body="""    {
 *     \x09"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ros.StackGroup("example", new()
 *     {
 *         StackGroupName = "example_value",
 *         TemplateBody = @"    {
 *     	""ROSTemplateFormatVersion"": ""2015-09-01""
 *     }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ros.NewStackGroup(ctx, "example", &ros.StackGroupArgs{
 * 			StackGroupName: pulumi.String("example_value"),
 * 			TemplateBody:   pulumi.String("    {\n    	\"ROSTemplateFormatVersion\": \"2015-09-01\"\n    }\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ros.StackGroup;
 * import com.pulumi.alicloud.ros.StackGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StackGroup("example", StackGroupArgs.builder()
 *             .stackGroupName("example_value")
 *             .templateBody("""
 *     {
 *     	"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ros:StackGroup
 *     properties:
 *       stackGroupName: example_value
 *       templateBody: |2
 *             {
 *             	"ROSTemplateFormatVersion": "2015-09-01"
 *             }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ROS Stack Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ros/stackGroup:StackGroup example <stack_group_name>
 * ```
 * @property accountIds The list of target account IDs, in JSON format. A maximum of 20 accounts can be specified.
 * @property administrationRoleName The name of the RAM administrator role assumed by ROS. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
 * @property description The description of the stack group.
 * @property executionRoleName The name of the RAM execution role assumed by the administrator role. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
 * @property operationDescription The description of the operation.
 * @property operationPreferences The operation settings, in JSON format.
 * @property parameters The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
 * @property regionIds The list of target regions, in JSON format. A maximum of 20 accounts can be specified.
 * @property stackGroupName The name of the stack group. The name must be unique in a region.
 * @property templateBody The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
 * @property templateUrl The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
 * @property templateVersion The version of the template.
 */
public data class StackGroupArgs(
    public val accountIds: Output<String>? = null,
    public val administrationRoleName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val executionRoleName: Output<String>? = null,
    public val operationDescription: Output<String>? = null,
    public val operationPreferences: Output<String>? = null,
    public val parameters: Output<List<StackGroupParameterArgs>>? = null,
    public val regionIds: Output<String>? = null,
    public val stackGroupName: Output<String>? = null,
    public val templateBody: Output<String>? = null,
    public val templateUrl: Output<String>? = null,
    public val templateVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.StackGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.StackGroupArgs =
        com.pulumi.alicloud.ros.StackGroupArgs.builder()
            .accountIds(accountIds?.applyValue({ args0 -> args0 }))
            .administrationRoleName(administrationRoleName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .executionRoleName(executionRoleName?.applyValue({ args0 -> args0 }))
            .operationDescription(operationDescription?.applyValue({ args0 -> args0 }))
            .operationPreferences(operationPreferences?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .regionIds(regionIds?.applyValue({ args0 -> args0 }))
            .stackGroupName(stackGroupName?.applyValue({ args0 -> args0 }))
            .templateBody(templateBody?.applyValue({ args0 -> args0 }))
            .templateUrl(templateUrl?.applyValue({ args0 -> args0 }))
            .templateVersion(templateVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackGroupArgs].
 */
@PulumiTagMarker
public class StackGroupArgsBuilder internal constructor() {
    private var accountIds: Output<String>? = null

    private var administrationRoleName: Output<String>? = null

    private var description: Output<String>? = null

    private var executionRoleName: Output<String>? = null

    private var operationDescription: Output<String>? = null

    private var operationPreferences: Output<String>? = null

    private var parameters: Output<List<StackGroupParameterArgs>>? = null

    private var regionIds: Output<String>? = null

    private var stackGroupName: Output<String>? = null

    private var templateBody: Output<String>? = null

    private var templateUrl: Output<String>? = null

    private var templateVersion: Output<String>? = null

    /**
     * @param value The list of target account IDs, in JSON format. A maximum of 20 accounts can be specified.
     */
    @JvmName("ukpeaglbcxxuvcjw")
    public suspend fun accountIds(`value`: Output<String>) {
        this.accountIds = value
    }

    /**
     * @param value The name of the RAM administrator role assumed by ROS. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
     */
    @JvmName("fdndoggyllqsjokt")
    public suspend fun administrationRoleName(`value`: Output<String>) {
        this.administrationRoleName = value
    }

    /**
     * @param value The description of the stack group.
     */
    @JvmName("firlssjwrfvwulah")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the RAM execution role assumed by the administrator role. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
     */
    @JvmName("ldmriexsjixioxak")
    public suspend fun executionRoleName(`value`: Output<String>) {
        this.executionRoleName = value
    }

    /**
     * @param value The description of the operation.
     */
    @JvmName("flofskvmhkfqsdva")
    public suspend fun operationDescription(`value`: Output<String>) {
        this.operationDescription = value
    }

    /**
     * @param value The operation settings, in JSON format.
     */
    @JvmName("nfyenbgtfhenbrpb")
    public suspend fun operationPreferences(`value`: Output<String>) {
        this.operationPreferences = value
    }

    /**
     * @param value The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("keuiknjyhiuoxsea")
    public suspend fun parameters(`value`: Output<List<StackGroupParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("rvaeyadpbeortivx")
    public suspend fun parameters(vararg values: Output<StackGroupParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("jkpnjltvlqvkxsad")
    public suspend fun parameters(values: List<Output<StackGroupParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The list of target regions, in JSON format. A maximum of 20 accounts can be specified.
     */
    @JvmName("lkyjcglsbjqvueio")
    public suspend fun regionIds(`value`: Output<String>) {
        this.regionIds = value
    }

    /**
     * @param value The name of the stack group. The name must be unique in a region.
     */
    @JvmName("gdynxjaxmqcfbjpx")
    public suspend fun stackGroupName(`value`: Output<String>) {
        this.stackGroupName = value
    }

    /**
     * @param value The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
     */
    @JvmName("mvgiskwfjfivhctu")
    public suspend fun templateBody(`value`: Output<String>) {
        this.templateBody = value
    }

    /**
     * @param value The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
     */
    @JvmName("oheanotjelrrkslb")
    public suspend fun templateUrl(`value`: Output<String>) {
        this.templateUrl = value
    }

    /**
     * @param value The version of the template.
     */
    @JvmName("aauyhlugkmrrdeef")
    public suspend fun templateVersion(`value`: Output<String>) {
        this.templateVersion = value
    }

    /**
     * @param value The list of target account IDs, in JSON format. A maximum of 20 accounts can be specified.
     */
    @JvmName("tuyfiimlgnqtfrex")
    public suspend fun accountIds(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountIds = mapped
    }

    /**
     * @param value The name of the RAM administrator role assumed by ROS. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
     */
    @JvmName("cbormtiksnbossoy")
    public suspend fun administrationRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administrationRoleName = mapped
    }

    /**
     * @param value The description of the stack group.
     */
    @JvmName("wnmxnhlhhofrmtju")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the RAM execution role assumed by the administrator role. ROS assumes this role to perform operations on the stack corresponding to the stack instance in the stack group.
     */
    @JvmName("unirmuwxngoddgnj")
    public suspend fun executionRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRoleName = mapped
    }

    /**
     * @param value The description of the operation.
     */
    @JvmName("uthfeaotrdagxufm")
    public suspend fun operationDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationDescription = mapped
    }

    /**
     * @param value The operation settings, in JSON format.
     */
    @JvmName("qovbufkdeighnrjs")
    public suspend fun operationPreferences(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationPreferences = mapped
    }

    /**
     * @param value The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("rgnyorrldciiyoxf")
    public suspend fun parameters(`value`: List<StackGroupParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("txyrqaggjxrdihlq")
    public suspend fun parameters(argument: List<suspend StackGroupParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StackGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("wqpkfitsnaqybqft")
    public suspend fun parameters(vararg argument: suspend StackGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StackGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("rvcfiiencvndfoqu")
    public suspend fun parameters(argument: suspend StackGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StackGroupParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters. If the parameter name and value are not specified, ROS will use the default value specified in the template.
     */
    @JvmName("ujllnnktsqytcfvy")
    public suspend fun parameters(vararg values: StackGroupParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The list of target regions, in JSON format. A maximum of 20 accounts can be specified.
     */
    @JvmName("redeoaydrogsojqq")
    public suspend fun regionIds(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionIds = mapped
    }

    /**
     * @param value The name of the stack group. The name must be unique in a region.
     */
    @JvmName("shllwfjlkbtbbppa")
    public suspend fun stackGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackGroupName = mapped
    }

    /**
     * @param value The structure that contains the template body. The template body must be 1 to 524,288 bytes in length. If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.
     */
    @JvmName("snefafwcyxdeyecs")
    public suspend fun templateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateBody = mapped
    }

    /**
     * @param value The URL of the file that contains the template body. The URL must point to a template located in an HTTP or HTTPS web server or an Alibaba Cloud OSS bucket. Examples: oss://ros/template/demo and oss://ros/template/demo?RegionId=cn-hangzhou. The template must be 1 to 524,288 bytes in length. If the region of the OSS bucket is not specified, the RegionId value is used by default.
     */
    @JvmName("vpajfanwdesnbtys")
    public suspend fun templateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateUrl = mapped
    }

    /**
     * @param value The version of the template.
     */
    @JvmName("lkpcetofcwhrlsjg")
    public suspend fun templateVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateVersion = mapped
    }

    internal fun build(): StackGroupArgs = StackGroupArgs(
        accountIds = accountIds,
        administrationRoleName = administrationRoleName,
        description = description,
        executionRoleName = executionRoleName,
        operationDescription = operationDescription,
        operationPreferences = operationPreferences,
        parameters = parameters,
        regionIds = regionIds,
        stackGroupName = stackGroupName,
        templateBody = templateBody,
        templateUrl = templateUrl,
        templateVersion = templateVersion,
    )
}
