@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin

import com.pulumi.alicloud.ros.StackInstanceArgs.builder
import com.pulumi.alicloud.ros.kotlin.inputs.StackInstanceParameterOverrideArgs
import com.pulumi.alicloud.ros.kotlin.inputs.StackInstanceParameterOverrideArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a ROS Stack Instance resource.
 * For information about ROS Stack Instance and how to use it, see [What is Stack Instance](https://www.alibabacloud.com/help/en/doc-detail/151338.html).
 * > **NOTE:** Available in v1.145.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const this = alicloud.getAccount({});
 * const default = alicloud.ros.getRegions({});
 * const defaultStackGroup = new alicloud.ros.StackGroup("default", {
 *     stackGroupName: name,
 *     templateBody: "{\"ROSTemplateFormatVersion\":\"2015-09-01\", \"Parameters\": {\"VpcName\": {\"Type\": \"String\"},\"InstanceType\": {\"Type\": \"String\"}}}",
 *     description: "test for stack groups",
 *     parameters: [
 *         {
 *             parameterKey: "VpcName",
 *             parameterValue: "VpcName",
 *         },
 *         {
 *             parameterKey: "InstanceType",
 *             parameterValue: "InstanceType",
 *         },
 *     ],
 * });
 * const example = new alicloud.ros.StackInstance("example", {
 *     stackGroupName: defaultStackGroup.stackGroupName,
 *     stackInstanceAccountId: _this.then(_this => _this.id),
 *     stackInstanceRegionId: _default.then(_default => _default.regions?.[0]?.regionId),
 *     operationPreferences: "{\"FailureToleranceCount\": 1, \"MaxConcurrentCount\": 2}",
 *     timeoutInMinutes: "60",
 *     operationDescription: "tf-example",
 *     retainStacks: true,
 *     parameterOverrides: [{
 *         parameterValue: "VpcName",
 *         parameterKey: "VpcName",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * this = alicloud.get_account()
 * default = alicloud.ros.get_regions()
 * default_stack_group = alicloud.ros.StackGroup("default",
 *     stack_group_name=name,
 *     template_body="{\"ROSTemplateFormatVersion\":\"2015-09-01\", \"Parameters\": {\"VpcName\": {\"Type\": \"String\"},\"InstanceType\": {\"Type\": \"String\"}}}",
 *     description="test for stack groups",
 *     parameters=[
 *         {
 *             "parameter_key": "VpcName",
 *             "parameter_value": "VpcName",
 *         },
 *         {
 *             "parameter_key": "InstanceType",
 *             "parameter_value": "InstanceType",
 *         },
 *     ])
 * example = alicloud.ros.StackInstance("example",
 *     stack_group_name=default_stack_group.stack_group_name,
 *     stack_instance_account_id=this.id,
 *     stack_instance_region_id=default.regions[0].region_id,
 *     operation_preferences="{\"FailureToleranceCount\": 1, \"MaxConcurrentCount\": 2}",
 *     timeout_in_minutes="60",
 *     operation_description="tf-example",
 *     retain_stacks=True,
 *     parameter_overrides=[{
 *         "parameter_value": "VpcName",
 *         "parameter_key": "VpcName",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @this = AliCloud.GetAccount.Invoke();
 *     var @default = AliCloud.Ros.GetRegions.Invoke();
 *     var defaultStackGroup = new AliCloud.Ros.StackGroup("default", new()
 *     {
 *         StackGroupName = name,
 *         TemplateBody = "{\"ROSTemplateFormatVersion\":\"2015-09-01\", \"Parameters\": {\"VpcName\": {\"Type\": \"String\"},\"InstanceType\": {\"Type\": \"String\"}}}",
 *         Description = "test for stack groups",
 *         Parameters = new[]
 *         {
 *             new AliCloud.Ros.Inputs.StackGroupParameterArgs
 *             {
 *                 ParameterKey = "VpcName",
 *                 ParameterValue = "VpcName",
 *             },
 *             new AliCloud.Ros.Inputs.StackGroupParameterArgs
 *             {
 *                 ParameterKey = "InstanceType",
 *                 ParameterValue = "InstanceType",
 *             },
 *         },
 *     });
 *     var example = new AliCloud.Ros.StackInstance("example", new()
 *     {
 *         StackGroupName = defaultStackGroup.StackGroupName,
 *         StackInstanceAccountId = @this.Apply(@this => @this.Apply(getAccountResult => getAccountResult.Id)),
 *         StackInstanceRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.RegionId)),
 *         OperationPreferences = "{\"FailureToleranceCount\": 1, \"MaxConcurrentCount\": 2}",
 *         TimeoutInMinutes = "60",
 *         OperationDescription = "tf-example",
 *         RetainStacks = true,
 *         ParameterOverrides = new[]
 *         {
 *             new AliCloud.Ros.Inputs.StackInstanceParameterOverrideArgs
 *             {
 *                 ParameterValue = "VpcName",
 *                 ParameterKey = "VpcName",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		this, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := ros.GetRegions(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultStackGroup, err := ros.NewStackGroup(ctx, "default", &ros.StackGroupArgs{
 * 			StackGroupName: pulumi.String(name),
 * 			TemplateBody:   pulumi.String("{\"ROSTemplateFormatVersion\":\"2015-09-01\", \"Parameters\": {\"VpcName\": {\"Type\": \"String\"},\"InstanceType\": {\"Type\": \"String\"}}}"),
 * 			Description:    pulumi.String("test for stack groups"),
 * 			Parameters: ros.StackGroupParameterArray{
 * 				&ros.StackGroupParameterArgs{
 * 					ParameterKey:   pulumi.String("VpcName"),
 * 					ParameterValue: pulumi.String("VpcName"),
 * 				},
 * 				&ros.StackGroupParameterArgs{
 * 					ParameterKey:   pulumi.String("InstanceType"),
 * 					ParameterValue: pulumi.String("InstanceType"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ros.NewStackInstance(ctx, "example", &ros.StackInstanceArgs{
 * 			StackGroupName:         defaultStackGroup.StackGroupName,
 * 			StackInstanceAccountId: pulumi.String(this.Id),
 * 			StackInstanceRegionId:  pulumi.String(_default.Regions[0].RegionId),
 * 			OperationPreferences:   pulumi.String("{\"FailureToleranceCount\": 1, \"MaxConcurrentCount\": 2}"),
 * 			TimeoutInMinutes:       pulumi.String("60"),
 * 			OperationDescription:   pulumi.String("tf-example"),
 * 			RetainStacks:           pulumi.Bool(true),
 * 			ParameterOverrides: ros.StackInstanceParameterOverrideArray{
 * 				&ros.StackInstanceParameterOverrideArgs{
 * 					ParameterValue: pulumi.String("VpcName"),
 * 					ParameterKey:   pulumi.String("VpcName"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.ros.RosFunctions;
 * import com.pulumi.alicloud.ros.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.ros.StackGroup;
 * import com.pulumi.alicloud.ros.StackGroupArgs;
 * import com.pulumi.alicloud.ros.inputs.StackGroupParameterArgs;
 * import com.pulumi.alicloud.ros.StackInstance;
 * import com.pulumi.alicloud.ros.StackInstanceArgs;
 * import com.pulumi.alicloud.ros.inputs.StackInstanceParameterOverrideArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var this = AlicloudFunctions.getAccount();
 *         final var default = RosFunctions.getRegions();
 *         var defaultStackGroup = new StackGroup("defaultStackGroup", StackGroupArgs.builder()
 *             .stackGroupName(name)
 *             .templateBody("{\"ROSTemplateFormatVersion\":\"2015-09-01\", \"Parameters\": {\"VpcName\": {\"Type\": \"String\"},\"InstanceType\": {\"Type\": \"String\"}}}")
 *             .description("test for stack groups")
 *             .parameters(
 *                 StackGroupParameterArgs.builder()
 *                     .parameterKey("VpcName")
 *                     .parameterValue("VpcName")
 *                     .build(),
 *                 StackGroupParameterArgs.builder()
 *                     .parameterKey("InstanceType")
 *                     .parameterValue("InstanceType")
 *                     .build())
 *             .build());
 *         var example = new StackInstance("example", StackInstanceArgs.builder()
 *             .stackGroupName(defaultStackGroup.stackGroupName())
 *             .stackInstanceAccountId(this_.id())
 *             .stackInstanceRegionId(default_.regions()[0].regionId())
 *             .operationPreferences("{\"FailureToleranceCount\": 1, \"MaxConcurrentCount\": 2}")
 *             .timeoutInMinutes("60")
 *             .operationDescription("tf-example")
 *             .retainStacks("true")
 *             .parameterOverrides(StackInstanceParameterOverrideArgs.builder()
 *                 .parameterValue("VpcName")
 *                 .parameterKey("VpcName")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultStackGroup:
 *     type: alicloud:ros:StackGroup
 *     name: default
 *     properties:
 *       stackGroupName: ${name}
 *       templateBody: '{"ROSTemplateFormatVersion":"2015-09-01", "Parameters": {"VpcName": {"Type": "String"},"InstanceType": {"Type": "String"}}}'
 *       description: test for stack groups
 *       parameters:
 *         - parameterKey: VpcName
 *           parameterValue: VpcName
 *         - parameterKey: InstanceType
 *           parameterValue: InstanceType
 *   example:
 *     type: alicloud:ros:StackInstance
 *     properties:
 *       stackGroupName: ${defaultStackGroup.stackGroupName}
 *       stackInstanceAccountId: ${this.id}
 *       stackInstanceRegionId: ${default.regions[0].regionId}
 *       operationPreferences: '{"FailureToleranceCount": 1, "MaxConcurrentCount": 2}'
 *       timeoutInMinutes: '60'
 *       operationDescription: tf-example
 *       retainStacks: 'true'
 *       parameterOverrides:
 *         - parameterValue: VpcName
 *           parameterKey: VpcName
 * variables:
 *   this:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 *   default:
 *     fn::invoke:
 *       Function: alicloud:ros:getRegions
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ROS Stack Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ros/stackInstance:StackInstance example <stack_group_name>:<stack_instance_account_id>:<stack_instance_region_id>
 * ```
 * @property operationDescription The operation description.
 * @property operationPreferences The operation preferences. The operation settings. The following fields are supported:
 * * `FailureToleranceCount` The maximum number of stack group operation failures that can occur. In a stack group operation, if the total number of failures does not exceed the FailureToleranceCount value, the operation succeeds. Otherwise, the operation fails. If the FailureToleranceCount parameter is not specified, the default value 0 is used. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `20`.
 * * `FailureTolerancePercentage`: The percentage of stack group operation failures that can occur. In a stack group operation, if the percentage of failures does not exceed the FailureTolerancePercentage value, the operation succeeds. Otherwise, the operation fails. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `100`.
 * * `MaxConcurrentCount`: The maximum number of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `20`.
 * * `MaxConcurrentPercentage`: The maximum percentage of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `100`
 * @property parameterOverrides ParameterOverrides. See the following `Block parameter_overrides`.
 * @property retainStacks Specifies whether to retain the stack corresponding to the stack instance.Default value `false`. **NOTE:** When `retain_stacks` is `true`, the stack is retained. If the stack is retained, the corresponding stack is not deleted when the stack instance is deleted from the stack group.
 * @property stackGroupName The name of the stack group.
 * @property stackInstanceAccountId The account to which the stack instance belongs.
 * @property stackInstanceRegionId The region of the stack instance.
 * @property timeoutInMinutes The timeout period that is specified for the stack creation request. Default value: `60`. Unit: `minutes`.
 */
public data class StackInstanceArgs(
    public val operationDescription: Output<String>? = null,
    public val operationPreferences: Output<String>? = null,
    public val parameterOverrides: Output<List<StackInstanceParameterOverrideArgs>>? = null,
    public val retainStacks: Output<Boolean>? = null,
    public val stackGroupName: Output<String>? = null,
    public val stackInstanceAccountId: Output<String>? = null,
    public val stackInstanceRegionId: Output<String>? = null,
    public val timeoutInMinutes: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.StackInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.StackInstanceArgs =
        com.pulumi.alicloud.ros.StackInstanceArgs.builder()
            .operationDescription(operationDescription?.applyValue({ args0 -> args0 }))
            .operationPreferences(operationPreferences?.applyValue({ args0 -> args0 }))
            .parameterOverrides(
                parameterOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .retainStacks(retainStacks?.applyValue({ args0 -> args0 }))
            .stackGroupName(stackGroupName?.applyValue({ args0 -> args0 }))
            .stackInstanceAccountId(stackInstanceAccountId?.applyValue({ args0 -> args0 }))
            .stackInstanceRegionId(stackInstanceRegionId?.applyValue({ args0 -> args0 }))
            .timeoutInMinutes(timeoutInMinutes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackInstanceArgs].
 */
@PulumiTagMarker
public class StackInstanceArgsBuilder internal constructor() {
    private var operationDescription: Output<String>? = null

    private var operationPreferences: Output<String>? = null

    private var parameterOverrides: Output<List<StackInstanceParameterOverrideArgs>>? = null

    private var retainStacks: Output<Boolean>? = null

    private var stackGroupName: Output<String>? = null

    private var stackInstanceAccountId: Output<String>? = null

    private var stackInstanceRegionId: Output<String>? = null

    private var timeoutInMinutes: Output<String>? = null

    /**
     * @param value The operation description.
     */
    @JvmName("bqgemdaxukmhelec")
    public suspend fun operationDescription(`value`: Output<String>) {
        this.operationDescription = value
    }

    /**
     * @param value The operation preferences. The operation settings. The following fields are supported:
     * * `FailureToleranceCount` The maximum number of stack group operation failures that can occur. In a stack group operation, if the total number of failures does not exceed the FailureToleranceCount value, the operation succeeds. Otherwise, the operation fails. If the FailureToleranceCount parameter is not specified, the default value 0 is used. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `20`.
     * * `FailureTolerancePercentage`: The percentage of stack group operation failures that can occur. In a stack group operation, if the percentage of failures does not exceed the FailureTolerancePercentage value, the operation succeeds. Otherwise, the operation fails. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `100`.
     * * `MaxConcurrentCount`: The maximum number of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `20`.
     * * `MaxConcurrentPercentage`: The maximum percentage of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `100`
     */
    @JvmName("wrjesifbfbdarpbr")
    public suspend fun operationPreferences(`value`: Output<String>) {
        this.operationPreferences = value
    }

    /**
     * @param value ParameterOverrides. See the following `Block parameter_overrides`.
     */
    @JvmName("aerbpureghmbufqw")
    public suspend fun parameterOverrides(`value`: Output<List<StackInstanceParameterOverrideArgs>>) {
        this.parameterOverrides = value
    }

    @JvmName("owpxohqbletuouoh")
    public suspend fun parameterOverrides(vararg values: Output<StackInstanceParameterOverrideArgs>) {
        this.parameterOverrides = Output.all(values.asList())
    }

    /**
     * @param values ParameterOverrides. See the following `Block parameter_overrides`.
     */
    @JvmName("owcajxayjhgrctcc")
    public suspend fun parameterOverrides(values: List<Output<StackInstanceParameterOverrideArgs>>) {
        this.parameterOverrides = Output.all(values)
    }

    /**
     * @param value Specifies whether to retain the stack corresponding to the stack instance.Default value `false`. **NOTE:** When `retain_stacks` is `true`, the stack is retained. If the stack is retained, the corresponding stack is not deleted when the stack instance is deleted from the stack group.
     */
    @JvmName("rjwalcxxvhmlhjqh")
    public suspend fun retainStacks(`value`: Output<Boolean>) {
        this.retainStacks = value
    }

    /**
     * @param value The name of the stack group.
     */
    @JvmName("yqfpsphqelhakvwa")
    public suspend fun stackGroupName(`value`: Output<String>) {
        this.stackGroupName = value
    }

    /**
     * @param value The account to which the stack instance belongs.
     */
    @JvmName("tkhunjtmjgbfcwai")
    public suspend fun stackInstanceAccountId(`value`: Output<String>) {
        this.stackInstanceAccountId = value
    }

    /**
     * @param value The region of the stack instance.
     */
    @JvmName("hqvxsblvxwuvbhmn")
    public suspend fun stackInstanceRegionId(`value`: Output<String>) {
        this.stackInstanceRegionId = value
    }

    /**
     * @param value The timeout period that is specified for the stack creation request. Default value: `60`. Unit: `minutes`.
     */
    @JvmName("aggboagjwyuscopb")
    public suspend fun timeoutInMinutes(`value`: Output<String>) {
        this.timeoutInMinutes = value
    }

    /**
     * @param value The operation description.
     */
    @JvmName("yhinsfxvlfwvksvj")
    public suspend fun operationDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationDescription = mapped
    }

    /**
     * @param value The operation preferences. The operation settings. The following fields are supported:
     * * `FailureToleranceCount` The maximum number of stack group operation failures that can occur. In a stack group operation, if the total number of failures does not exceed the FailureToleranceCount value, the operation succeeds. Otherwise, the operation fails. If the FailureToleranceCount parameter is not specified, the default value 0 is used. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `20`.
     * * `FailureTolerancePercentage`: The percentage of stack group operation failures that can occur. In a stack group operation, if the percentage of failures does not exceed the FailureTolerancePercentage value, the operation succeeds. Otherwise, the operation fails. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `100`.
     * * `MaxConcurrentCount`: The maximum number of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `20`.
     * * `MaxConcurrentPercentage`: The maximum percentage of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `100`
     */
    @JvmName("bjstknorjpotqnpt")
    public suspend fun operationPreferences(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationPreferences = mapped
    }

    /**
     * @param value ParameterOverrides. See the following `Block parameter_overrides`.
     */
    @JvmName("osdsvqmremqykcov")
    public suspend fun parameterOverrides(`value`: List<StackInstanceParameterOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterOverrides = mapped
    }

    /**
     * @param argument ParameterOverrides. See the following `Block parameter_overrides`.
     */
    @JvmName("axbelikoekcfoebp")
    public suspend fun parameterOverrides(argument: List<suspend StackInstanceParameterOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StackInstanceParameterOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameterOverrides = mapped
    }

    /**
     * @param argument ParameterOverrides. See the following `Block parameter_overrides`.
     */
    @JvmName("xyfwurotlsnjdege")
    public suspend fun parameterOverrides(vararg argument: suspend StackInstanceParameterOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StackInstanceParameterOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameterOverrides = mapped
    }

    /**
     * @param argument ParameterOverrides. See the following `Block parameter_overrides`.
     */
    @JvmName("iwsnknbscqbuhkve")
    public suspend fun parameterOverrides(argument: suspend StackInstanceParameterOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            StackInstanceParameterOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameterOverrides = mapped
    }

    /**
     * @param values ParameterOverrides. See the following `Block parameter_overrides`.
     */
    @JvmName("wuquufjyawymfqhl")
    public suspend fun parameterOverrides(vararg values: StackInstanceParameterOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterOverrides = mapped
    }

    /**
     * @param value Specifies whether to retain the stack corresponding to the stack instance.Default value `false`. **NOTE:** When `retain_stacks` is `true`, the stack is retained. If the stack is retained, the corresponding stack is not deleted when the stack instance is deleted from the stack group.
     */
    @JvmName("hcfgalmjefrungpi")
    public suspend fun retainStacks(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainStacks = mapped
    }

    /**
     * @param value The name of the stack group.
     */
    @JvmName("lfalghxqcfovjpdj")
    public suspend fun stackGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackGroupName = mapped
    }

    /**
     * @param value The account to which the stack instance belongs.
     */
    @JvmName("rtmsgjqpgdjhgnxv")
    public suspend fun stackInstanceAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackInstanceAccountId = mapped
    }

    /**
     * @param value The region of the stack instance.
     */
    @JvmName("ucagbsnkoqdqkxdo")
    public suspend fun stackInstanceRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackInstanceRegionId = mapped
    }

    /**
     * @param value The timeout period that is specified for the stack creation request. Default value: `60`. Unit: `minutes`.
     */
    @JvmName("iwytodbquyxoqmbg")
    public suspend fun timeoutInMinutes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInMinutes = mapped
    }

    internal fun build(): StackInstanceArgs = StackInstanceArgs(
        operationDescription = operationDescription,
        operationPreferences = operationPreferences,
        parameterOverrides = parameterOverrides,
        retainStacks = retainStacks,
        stackGroupName = stackGroupName,
        stackInstanceAccountId = stackInstanceAccountId,
        stackInstanceRegionId = stackInstanceRegionId,
        timeoutInMinutes = timeoutInMinutes,
    )
}
