@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Template].
 */
@PulumiTagMarker
public class TemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TemplateArgs = TemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TemplateArgsBuilder.() -> Unit) {
        val builder = TemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Template {
        val builtJavaResource = com.pulumi.alicloud.ros.Template(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Template(builtJavaResource)
    }
}

/**
 * Provides a ROS Template resource.
 * For information about ROS Template and how to use it, see [What is Template](https://www.alibabacloud.com/help/en/doc-detail/141851.htm).
 * > **NOTE:** Available in v1.108.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ros.Template("example", {
 *     templateName: "example_value",
 *     templateBody: `    {
 *     \x09"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ros.Template("example",
 *     template_name="example_value",
 *     template_body="""    {
 *     \x09"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ros.Template("example", new()
 *     {
 *         TemplateName = "example_value",
 *         TemplateBody = @"    {
 *     	""ROSTemplateFormatVersion"": ""2015-09-01""
 *     }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ros.NewTemplate(ctx, "example", &ros.TemplateArgs{
 * 			TemplateName: pulumi.String("example_value"),
 * 			TemplateBody: pulumi.String("    {\n    	\"ROSTemplateFormatVersion\": \"2015-09-01\"\n    }\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ros.Template;
 * import com.pulumi.alicloud.ros.TemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Template("example", TemplateArgs.builder()
 *             .templateName("example_value")
 *             .templateBody("""
 *     {
 *     	"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ros:Template
 *     properties:
 *       templateName: example_value
 *       templateBody: |2
 *             {
 *             	"ROSTemplateFormatVersion": "2015-09-01"
 *             }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ROS Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ros/template:Template example <template_id>
 * ```
 */
public class Template internal constructor(
    override val javaResource: com.pulumi.alicloud.ros.Template,
) : KotlinCustomResource(javaResource, TemplateMapper) {
    /**
     * The description of the template. The description can be up to 256 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You must specify one of the TemplateBody and TemplateURL parameters, but you cannot specify both of them.
     */
    public val templateBody: Output<String>?
        get() = javaResource.templateBody().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the template. The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
     */
    public val templateName: Output<String>
        get() = javaResource.templateName().applyValue({ args0 -> args0 })

    /**
     * The template url.
     */
    public val templateUrl: Output<String>?
        get() = javaResource.templateUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object TemplateMapper : ResourceMapper<Template> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ros.Template::class == javaResource::class

    override fun map(javaResource: Resource): Template = Template(
        javaResource as
            com.pulumi.alicloud.ros.Template,
    )
}

/**
 * @see [Template].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Template].
 */
public suspend fun template(name: String, block: suspend TemplateResourceBuilder.() -> Unit): Template {
    val builder = TemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Template].
 * @param name The _unique_ name of the resulting resource.
 */
public fun template(name: String): Template {
    val builder = TemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
